/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.enhancedcelestials.lunarevent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import dev.corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public class LunarEventInstance {
    public static final Codec<LunarEventInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceKey.m_195966_(EnhancedCelestialsRegistry.LUNAR_EVENT_KEY).fieldOf("lunarEventKey").forGetter(lunarEventInstance -> lunarEventInstance.lunarEventKey), (App)Codec.LONG.fieldOf("scheduledDay").forGetter(lunarEventInstance -> lunarEventInstance.scheduledDay), (App)Codec.BOOL.fieldOf("forced").forGetter(lunarEventInstance -> lunarEventInstance.forced)).apply((Applicative)builder, LunarEventInstance::new));
    public static final Codec<List<LunarEventInstance>> LIST_CODEC = CODEC.listOf();
    private final ResourceKey<LunarEvent> lunarEventKey;
    private final long scheduledDay;
    private final boolean forced;

    public LunarEventInstance(ResourceKey<LunarEvent> lunarEventKey, long scheduledDay) {
        this(lunarEventKey, scheduledDay, false);
    }

    public LunarEventInstance(ResourceKey<LunarEvent> lunarEventKey, long scheduledDay, boolean forced) {
        this.lunarEventKey = lunarEventKey;
        this.scheduledDay = scheduledDay;
        this.forced = forced;
    }

    public ResourceKey<LunarEvent> getLunarEventKey() {
        return this.lunarEventKey;
    }

    public Holder<LunarEvent> getEvent(Registry<LunarEvent> events) {
        return events.m_246971_(this.lunarEventKey);
    }

    public long scheduledDay() {
        return this.scheduledDay;
    }

    public long getDaysUntil(long currentDay) {
        return this.scheduledDay - currentDay;
    }

    public boolean passed(long currentDay) {
        return this.scheduledDay - currentDay <= -1L;
    }

    public boolean active(long currentDay) {
        return this.scheduledDay - currentDay == 0L;
    }
}

