/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.trunkplacer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import quek.undergarden.registry.UGTrunkPlacerTypes;

public class SmogstemTrunkPlacer
extends TrunkPlacer {
    protected final int width;
    public static final Codec<SmogstemTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(placer -> placer.f_70263_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(placer -> placer.f_70264_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(placer -> placer.f_70265_), (App)Codec.intRange((int)1, (int)2).fieldOf("width").forGetter(placer -> placer.width)).apply((Applicative)instance, SmogstemTrunkPlacer::new));

    public SmogstemTrunkPlacer(int baseHeight, int firstRandHeight, int secondRandHeight, int width) {
        super(baseHeight, firstRandHeight, secondRandHeight);
        this.width = width;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)UGTrunkPlacerTypes.SMOGSTEM_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BlockGetter blockGetter = (BlockGetter)level;
        int treeBaseHeight = config.f_68190_.m_226153_(random);
        int width = this.width;
        for (int y = 0; y < treeBaseHeight; ++y) {
            float thiccness = (1.0f - (float)y / (float)treeBaseHeight) * (float)width;
            int l = Mth.m_14167_((float)treeBaseHeight);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)Mth.m_14040_((int)i1) - 0.25f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)Mth.m_14040_((int)j1) - 0.25f;
                    if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > thiccness * thiccness || (i1 == -l || i1 == l || j1 == -l || j1 == l) && random.m_188501_() > 0.75f) continue;
                    BlockState blockstate = blockGetter.m_8055_(pos.m_7918_(i1, y, j1));
                    if (blockstate.m_60795_()) {
                        this.m_226187_(level, blockSetter, random, pos.m_7918_(i1, y, j1), config);
                    }
                    if (y == 0 || l <= 1 || !(blockstate = blockGetter.m_8055_(pos.m_7918_(i1, -y, j1))).m_60795_()) continue;
                    this.m_226187_(level, blockSetter, random, pos.m_7918_(i1, y, j1), config);
                }
            }
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.m_6630_(treeBaseHeight), 0, false));
    }
}

