/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.rotspawn;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.entity.animal.Mog;
import quek.undergarden.entity.stoneborn.Stoneborn;
import quek.undergarden.registry.UGDamageSources;

public class RotspawnMonster
extends Monster {
    private int fleeTime = 0;

    protected RotspawnMonster(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, false));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, new RotspawnTargetGoal<Player>((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, new RotspawnTargetGoal<Stoneborn>((Mob)this, Stoneborn.class, true));
        this.f_21346_.m_25352_(3, new RotspawnTargetGoal<Animal>((Mob)this, Animal.class, true, target -> !(target instanceof Mog)));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.fleeTime > 0) {
            --this.fleeTime;
        }
        if (this.f_19797_ % 40 == 0 && this.fleeTime == 0) {
            Optional repelPos = BlockPos.m_121930_((BlockPos)this.m_20183_(), (int)16, (int)4, pos -> this.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_13084_));
            repelPos.ifPresent(pos -> this.fleePosition(pos.m_252807_()));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (source.m_276093_(UGDamageSources.SHARD_TORCH) && flag) {
            if (source.m_7270_() == null) {
                throw new IllegalArgumentException("Please pass a Vec3 into the DamageSource when calling SHARD_TORCH, otherwise Rotspawn will not flee them.\nYou can use UGDamageSources.getShardTorchDamage to do this easily.");
            }
            this.fleePosition(source.m_7270_());
        }
        return flag;
    }

    private void fleePosition(Vec3 damagePos) {
        for (int i = 0; i < 5; ++i) {
            Vec3 fleePos = DefaultRandomPos.m_148407_((PathfinderMob)this, (int)16, (int)5, (Vec3)damagePos);
            if (fleePos == null) continue;
            this.m_21573_().m_26573_();
            this.m_21573_().m_26519_(fleePos.m_7096_(), fleePos.m_7098_(), fleePos.m_7094_(), 1.45);
            this.m_6710_(null);
            this.fleeTime = 100;
            break;
        }
    }

    public static boolean canRotspawnSpawn(EntityType<? extends Monster> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return random.m_188503_(10) == 0 && RotspawnMonster.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random);
    }

    public static class RotspawnTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public RotspawnTargetGoal(Mob mob, Class<T> targetClass, boolean mustSee) {
            super(mob, targetClass, mustSee);
        }

        public RotspawnTargetGoal(Mob mob, Class<T> targetClass, boolean mustSee, Predicate<LivingEntity> predicate) {
            super(mob, targetClass, mustSee, predicate);
        }

        public boolean m_8036_() {
            return ((RotspawnMonster)this.f_26135_).fleeTime <= 0 && super.m_8036_();
        }
    }
}

