/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.Mog;

public class MogModel<E extends Mog>
extends AgeableListModel<E> {
    private final ModelPart frontLegLeft;
    private final ModelPart frontLegRight;
    private final ModelPart backLegRight;
    private final ModelPart backLegLeft;
    private final ModelPart head;
    private final ModelPart body;

    public MogModel(ModelPart root) {
        this.frontLegLeft = root.m_171324_("frontLegLeft");
        this.frontLegRight = root.m_171324_("frontLegRight");
        this.backLegRight = root.m_171324_("backLegRight");
        this.backLegLeft = root.m_171324_("backLegLeft");
        this.head = root.m_171324_("head");
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition frontLegLeft = partdefinition.m_171599_("frontLegLeft", CubeListBuilder.m_171558_().m_171514_(32, 36).m_171480_().m_171488_(0.0f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)20.0f, (float)-2.0f));
        PartDefinition frontLegRight = partdefinition.m_171599_("frontLegRight", CubeListBuilder.m_171558_().m_171514_(20, 36).m_171488_(-3.0f, 0.0f, -3.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)20.0f, (float)-2.0f));
        PartDefinition backLegRight = partdefinition.m_171599_("backLegRight", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-7.0f, 0.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)20.0f, (float)2.0f));
        PartDefinition backLegLeft = partdefinition.m_171599_("backLegLeft", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171480_().m_171488_(4.0f, 0.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)20.0f, (float)2.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(26, 26).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.0f, (float)-6.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(0.0f, -21.0f, -4.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-6.0f, -17.0f, -6.0f, 12.0f, 14.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(0, 26).m_171488_(-4.0f, -19.0f, -3.0f, 6.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.head, (Object)this.body, (Object)this.frontLegLeft, (Object)this.frontLegRight, (Object)this.backLegLeft, (Object)this.backLegRight);
    }

    public void setupAnim(E entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.f_104205_ = 0.1f * Mth.m_14031_((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
        this.frontLegLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
        this.frontLegRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 4.0f * limbSwingAmount;
        this.backLegLeft.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f + (float)Math.PI)) * 4.0f * limbSwingAmount;
        this.backLegRight.f_104203_ = Mth.m_14089_((float)(limbSwing * 2.0f)) * 4.0f * limbSwingAmount;
    }
}

