/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.the_harvest.configs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class HarvestConfig {
    public static final ForgeConfigSpec SPEC;
    public static final HarvestConfig CONFIG;
    public ForgeConfigSpec.DoubleValue MAP_SPAWN_CHANCE_ON_CHEST_LOOT;
    public ForgeConfigSpec.DoubleValue LOOT_TABLE_CHANCE_PER_MOB;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_CHANCE_MULTI;
    public ForgeConfigSpec.IntValue MAX_TOTAL_MOB_SPAWNS;
    public HashMap<String, Float> dimChanceMap = new HashMap();

    public static HarvestConfig get() {
        return CONFIG;
    }

    public HashMap<String, Float> getDimChanceMap() {
        if (this.dimChanceMap.isEmpty()) {
            for (String s : (List)this.DIMENSION_CHANCE_MULTI.get()) {
                String dim = s.split("-")[0];
                Float multi = Float.valueOf(Float.parseFloat(s.split("-")[1]));
                this.dimChanceMap.put(dim, multi);
            }
        }
        return this.dimChanceMap;
    }

    public float getDimChanceMulti(Level level) {
        String dimid = level.m_220362_().m_135782_().toString();
        HashMap<String, Float> map = this.getDimChanceMap();
        return map.getOrDefault(dimid, Float.valueOf(1.0f)).floatValue();
    }

    HarvestConfig(ForgeConfigSpec.Builder b) {
        b.comment("The Harvest Configs").push("general");
        this.DIMENSION_CHANCE_MULTI = b.comment("Harvest map spawn chance multi per dimension").defineList("DIMENSION_CHANCE_MULTI", () -> Arrays.asList("mmorpg:dungeon-0"), x -> true);
        this.MAX_TOTAL_MOB_SPAWNS = b.comment("Max mobs spawned in a harvest arena").defineInRange("MAX_TOTAL_MOB_SPAWNS", 200, 20, 2000);
        this.MAP_SPAWN_CHANCE_ON_CHEST_LOOT = b.comment("When you loot new chests with loot tables, harvest maps have a chance to spawn as extra loot").defineInRange("MAP_SPAWN_CHANCE_ON_CHEST_LOOT", 5.0, 0.0, 100.0);
        this.LOOT_TABLE_CHANCE_PER_MOB = b.comment("Mobs inside the harvest have a chance to drop this loot table as a bonus").defineInRange("LOOT_TABLE_CHANCE_PER_MOB", 5.0, 0.0, 100.0);
        b.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(HarvestConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (HarvestConfig)specPair.getLeft();
    }
}

