/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.optifine;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.RecordComponent;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;
import org.vivecraft.client_vr.render.helpers.RenderHelper;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mod_compat_vr.shaders.ShadersHelper;

public class OptifineHelper {
    private static boolean CHECKED_FOR_OPTIFINE = false;
    private static boolean OPTIFINE_LOADED = false;
    private static final Map<String, Pair<ShadersHelper.UniformType, Object>> SHADER_UNIFORMS = new HashMap<String, Pair<ShadersHelper.UniformType, Object>>();
    private static final Map<String, Object> SHADER_UNIFORMS_DATA = new HashMap<String, Object>();
    private static Class<?> Config;
    private static Method Config_IsShaders;
    private static Method Config_IsRenderRegions;
    private static Method Config_IsSkyEnabled;
    private static Method Config_IsSunMoonEnabled;
    private static Method Config_IsStarsEnabled;
    private static Method Config_IsCustomColors;
    private static Method Config_IsAntialiasing;
    private static Method Config_IsAntialiasingConfigured;
    private static Class<?> SmartAnimations;
    private static Method SmartAnimations_SpriteRendered;
    private static Class<?> CustomColors;
    private static Method CustomColors_GetSkyColor;
    private static Method CustomColors_GetSkyColoEnd;
    private static Method CustomColors_GetUnderwaterColor;
    private static Method CustomColors_GetUnderlavaColor;
    private static Method CustomColors_GetFogColor;
    private static Method CustomColors_GetFogColorEnd;
    private static Method CustomColors_GetFogColorNether;
    private static Class<?> ShadersRender;
    private static Method ShadersRender_BeginOutline;
    private static Method ShadersRender_EndOutline;
    private static Class<?> Shaders;
    private static Method Shaders_BeginEntities;
    private static Method Shaders_EndEntities;
    private static Method Shaders_SetCameraShadow;
    private static Field Shaders_DFB;
    private static Field Shaders_isShadowPass;
    private static Field Shaders_shaderUniforms;
    private static Method GlState_unbindFramebuffer;
    private static Method ShadersFramebuffer_BindFramebuffer;
    private static Method ShaderUniforms_make1i;
    private static Method ShaderUniforms_make3f;
    private static Method ShaderUniforms_makeM4;
    private static Method ShaderUniform1i_setValue;
    private static Method ShaderUniform3f_setValue;
    private static Method ShaderUniformM4_setValue;
    private static Field Options_ofRenderRegions;
    private static Field Options_ofCloudHeight;
    private static Field Options_ofAoLevel;
    private static Field Vertex_renderPositions;
    private static Method VertexRecord_renderPositions;
    private static Method Mutable_get;
    private static Method Mutable_set;

    public static boolean isOptifineLoaded() {
        if (!CHECKED_FOR_OPTIFINE) {
            CHECKED_FOR_OPTIFINE = true;
            try {
                Class.forName("net.optifine.Config");
                VRSettings.LOGGER.info("Vivecraft: Optifine detected");
                OPTIFINE_LOADED = true;
            }
            catch (ClassNotFoundException ignore) {
                VRSettings.LOGGER.info("Vivecraft: Optifine not detected");
                OPTIFINE_LOADED = false;
            }
            if (OPTIFINE_LOADED) {
                OptifineHelper.init();
            }
        }
        return OPTIFINE_LOADED;
    }

    public static boolean isShaderActive() {
        try {
            return (Boolean)Config_IsShaders.invoke(Config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "IsShaders");
            return false;
        }
    }

    public static boolean isRenderingShadows() {
        try {
            return (Boolean)Shaders_isShadowPass.get(Shaders);
        }
        catch (IllegalAccessException e) {
            OptifineHelper.logError(e, "isShadowPass");
            return false;
        }
    }

    public static boolean bindShaderFramebuffer() {
        try {
            Object dfb = Shaders_DFB.get(Shaders);
            if (dfb != null) {
                ShadersFramebuffer_BindFramebuffer.invoke(dfb, new Object[0]);
                return true;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "dfb.BindFramebuffer");
        }
        return false;
    }

    public static void unbindShaderFramebuffer() {
        try {
            GlState_unbindFramebuffer.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "GlState.unbindFramebuffer");
        }
    }

    public static void copyOptifineShaderDepth(RenderTarget renderTarget) {
        if (!OptifineHelper.bindShaderFramebuffer()) {
            return;
        }
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)renderTarget.m_83980_());
        RenderHelper.checkGLError("pre copy depth");
        GlStateManager._glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderTarget.f_83915_, (int)renderTarget.f_83916_);
        RenderHelper.checkGLError("post copy depth");
        OptifineHelper.unbindShaderFramebuffer();
        renderTarget.m_83947_(false);
    }

    public static void beginOutlineShader() {
        try {
            ShadersRender_BeginOutline.invoke(ShadersRender, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "beginOutline");
        }
    }

    public static void endOutlineShader() {
        try {
            ShadersRender_EndOutline.invoke(ShadersRender, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "endOutline");
        }
    }

    public static void beginEntities() {
        try {
            Shaders_BeginEntities.invoke(Shaders, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "beginEntities");
        }
    }

    public static void endEntities() {
        try {
            Shaders_EndEntities.invoke(Shaders, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "endEntities");
        }
    }

    public static void setCameraShadow(PoseStack poseStack, Camera camera, float partialTick) {
        try {
            Shaders_SetCameraShadow.invoke(Shaders, poseStack, camera, Float.valueOf(partialTick));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "setCameraShadow");
        }
    }

    public static boolean isSunMoonEnabled() {
        try {
            return (Boolean)Config_IsSunMoonEnabled.invoke(Config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "isSunMoonEnabled");
            return true;
        }
    }

    public static boolean isSkyEnabled() {
        try {
            return (Boolean)Config_IsSkyEnabled.invoke(Config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "isSkyEnabled");
            return true;
        }
    }

    public static boolean isStarsEnabled() {
        try {
            return (Boolean)Config_IsStarsEnabled.invoke(Config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "isStarsEnabled");
            return true;
        }
    }

    public static boolean isCustomColors() {
        try {
            return (Boolean)Config_IsCustomColors.invoke(Config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "isCustomColors");
            return false;
        }
    }

    public static boolean isAntialiasing() {
        try {
            return (Boolean)Config_IsAntialiasing.invoke(Config, new Object[0]) != false || (Boolean)Config_IsAntialiasingConfigured.invoke(Config, new Object[0]) != false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "isAntialiasing");
            return false;
        }
    }

    public static boolean isRenderRegions() {
        try {
            return (Boolean)Config_IsRenderRegions.invoke(Config, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "isRenderRegions");
            return false;
        }
    }

    public static void setRenderRegions(boolean active) {
        try {
            Options_ofRenderRegions.set(Minecraft.m_91087_().f_91066_, active);
        }
        catch (IllegalAccessException e) {
            VRSettings.LOGGER.error("Vivecraft: error setting Optifine render regions:", (Throwable)e);
        }
    }

    public static Vec3 getCustomSkyColor(Vec3 skyColor, BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)CustomColors_GetSkyColor.invoke(CustomColors, skyColor, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "getSkyColor");
            return skyColor;
        }
    }

    public static Vec3 getCustomSkyColorEnd(Vec3 skyColor) {
        try {
            return (Vec3)CustomColors_GetSkyColoEnd.invoke(CustomColors, skyColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "getSkyColorEnd");
            return skyColor;
        }
    }

    public static Vec3 getCustomUnderwaterColor(BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)CustomColors_GetUnderwaterColor.invoke(CustomColors, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "getUnderwaterColor");
            return null;
        }
    }

    public static Vec3 getCustomUnderlavaColor(BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)CustomColors_GetUnderlavaColor.invoke(CustomColors, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "getUnderlavaColor");
            return null;
        }
    }

    public static Vec3 getCustomFogColor(Vec3 fogColor, BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)CustomColors_GetFogColor.invoke(CustomColors, fogColor, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "getFogColor");
            return fogColor;
        }
    }

    public static Vec3 getCustomFogColorEnd(Vec3 fogColor) {
        try {
            return (Vec3)CustomColors_GetFogColorEnd.invoke(CustomColors, fogColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "getFogColorEnd");
            return fogColor;
        }
    }

    public static Vec3 getCustomFogColorNether(Vec3 fogColor) {
        try {
            return (Vec3)CustomColors_GetFogColorNether.invoke(CustomColors, fogColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "getFogColorNether");
            return fogColor;
        }
    }

    public static double getCloudHeight() {
        try {
            return (Double)Options_ofCloudHeight.get(Minecraft.m_91087_().f_91066_);
        }
        catch (IllegalAccessException e) {
            OptifineHelper.logError(e, "getCloudHeight");
            return 0.0;
        }
    }

    public static double getAoLevel() {
        try {
            return (Double)Options_ofAoLevel.get(Minecraft.m_91087_().f_91066_);
        }
        catch (IllegalAccessException e) {
            OptifineHelper.logError(e, "getAoLevel");
            return 1.0;
        }
    }

    public static void markTextureAsActive(TextureAtlasSprite sprite) {
        try {
            SmartAnimations_SpriteRendered.invoke(SmartAnimations, sprite);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            OptifineHelper.logError(e, "spriteRendered");
        }
    }

    public static void copyRenderPositions(ModelPart.Vertex source, ModelPart.Vertex dest) {
        try {
            if (Vertex_renderPositions != null) {
                Vertex_renderPositions.set(dest, Vertex_renderPositions.get(source));
            } else if (VertexRecord_renderPositions != null) {
                Mutable_set.invoke(VertexRecord_renderPositions.invoke((Object)dest, new Object[0]), Mutable_get.invoke(VertexRecord_renderPositions.invoke((Object)source, new Object[0]), new Object[0]));
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            VRSettings.LOGGER.error("Vivecraft: error copying Optifine vertex data:", (Throwable)e);
        }
    }

    public static void updateUniforms() {
        if (!OptifineHelper.isOptifineLoaded()) {
            return;
        }
        try {
            block18: for (Triple<String, ShadersHelper.UniformType, Supplier<?>> uniform : ShadersHelper.getUniforms()) {
                String name = (String)uniform.getLeft();
                if (!SHADER_UNIFORMS.containsKey(name)) {
                    Method m = switch ((ShadersHelper.UniformType)((Object)uniform.getMiddle())) {
                        default -> throw new IncompatibleClassChangeError();
                        case ShadersHelper.UniformType.MATRIX4F -> ShaderUniforms_makeM4;
                        case ShadersHelper.UniformType.VECTOR3F -> ShaderUniforms_make3f;
                        case ShadersHelper.UniformType.BOOLEAN, ShadersHelper.UniformType.INTEGER -> ShaderUniforms_make1i;
                    };
                    SHADER_UNIFORMS.put((String)uniform.getLeft(), (Pair<ShadersHelper.UniformType, Object>)Pair.of((Object)((Object)((ShadersHelper.UniformType)((Object)uniform.getMiddle()))), (Object)m.invoke(Shaders_shaderUniforms.get(null), name)));
                    SHADER_UNIFORMS_DATA.put(name, switch ((ShadersHelper.UniformType)((Object)uniform.getMiddle())) {
                        default -> throw new IncompatibleClassChangeError();
                        case ShadersHelper.UniformType.MATRIX4F -> MemoryUtil.memAllocFloat((int)16);
                        case ShadersHelper.UniformType.VECTOR3F -> new Vector3f();
                        case ShadersHelper.UniformType.BOOLEAN, ShadersHelper.UniformType.INTEGER -> Integer.valueOf(0);
                    });
                }
                switch ((ShadersHelper.UniformType)((Object)uniform.getMiddle())) {
                    case MATRIX4F: {
                        FloatBuffer floatBuffer = (FloatBuffer)SHADER_UNIFORMS_DATA.get(name);
                        floatBuffer.clear();
                        ((Matrix4fc)((Supplier)uniform.getRight()).get()).get(floatBuffer);
                        continue block18;
                    }
                    case VECTOR3F: {
                        ((Vector3f)SHADER_UNIFORMS_DATA.get(name)).set((Vector3fc)((Supplier)uniform.getRight()).get());
                        continue block18;
                    }
                    case INTEGER: {
                        SHADER_UNIFORMS_DATA.put(name, ((Supplier)uniform.getRight()).get());
                        continue block18;
                    }
                    case BOOLEAN: {
                        SHADER_UNIFORMS_DATA.put(name, (Boolean)((Supplier)uniform.getRight()).get() != false ? 1 : 0);
                        continue block18;
                    }
                }
                throw new IllegalStateException("Unexpected uniform type: " + uniform.getMiddle());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            VRSettings.LOGGER.error("Vivecraft: error updating shader uniform data:", (Throwable)e);
        }
    }

    public static void setUniforms() {
        if (!OptifineHelper.isOptifineLoaded()) {
            return;
        }
        try {
            block7: for (Map.Entry<String, Pair<ShadersHelper.UniformType, Object>> entry : SHADER_UNIFORMS.entrySet()) {
                String name = entry.getKey();
                Object data = SHADER_UNIFORMS_DATA.get(name);
                Object uniform = entry.getValue().getRight();
                switch ((ShadersHelper.UniformType)((Object)entry.getValue().getLeft())) {
                    case MATRIX4F: {
                        ShaderUniformM4_setValue.invoke(uniform, false, data);
                        continue block7;
                    }
                    case VECTOR3F: {
                        Vector3f vec = (Vector3f)data;
                        ShaderUniform3f_setValue.invoke(uniform, Float.valueOf(vec.x), Float.valueOf(vec.y), Float.valueOf(vec.z));
                        continue block7;
                    }
                    case BOOLEAN: 
                    case INTEGER: {
                        ShaderUniform1i_setValue.invoke(uniform, data);
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unexpected uniform type: " + entry.getValue().getLeft());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            VRSettings.LOGGER.error("Vivecraft: error updating shader uniform data:", (Throwable)e);
        }
    }

    private static void init() {
        try {
            Config = Class.forName("net.optifine.Config");
            Config_IsShaders = Config.getMethod("isShaders", new Class[0]);
            Config_IsRenderRegions = Config.getMethod("isRenderRegions", new Class[0]);
            Config_IsSkyEnabled = Config.getMethod("isSkyEnabled", new Class[0]);
            Config_IsSunMoonEnabled = Config.getMethod("isSunMoonEnabled", new Class[0]);
            Config_IsStarsEnabled = Config.getMethod("isStarsEnabled", new Class[0]);
            Config_IsCustomColors = Config.getMethod("isCustomColors", new Class[0]);
            Config_IsAntialiasing = Config.getMethod("isAntialiasing", new Class[0]);
            Config_IsAntialiasingConfigured = Config.getMethod("isAntialiasingConfigured", new Class[0]);
            SmartAnimations = Class.forName("net.optifine.SmartAnimations");
            SmartAnimations_SpriteRendered = SmartAnimations.getMethod("spriteRendered", TextureAtlasSprite.class);
            Options_ofRenderRegions = Options.class.getField("ofRenderRegions");
            Options_ofCloudHeight = Options.class.getField("ofCloudsHeight");
            Options_ofAoLevel = Options.class.getField("ofAoLevel");
            CustomColors = Class.forName("net.optifine.CustomColors");
            CustomColors_GetSkyColor = CustomColors.getMethod("getSkyColor", Vec3.class, BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            CustomColors_GetUnderwaterColor = CustomColors.getMethod("getUnderwaterColor", BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            CustomColors_GetUnderlavaColor = CustomColors.getMethod("getUnderlavaColor", BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            ShadersRender = Class.forName("net.optifine.shaders.ShadersRender");
            ShadersRender_BeginOutline = ShadersRender.getMethod("beginOutline", new Class[0]);
            ShadersRender_EndOutline = ShadersRender.getMethod("endOutline", new Class[0]);
            Shaders = Class.forName("net.optifine.shaders.Shaders");
            Shaders_BeginEntities = Shaders.getMethod("beginEntities", new Class[0]);
            Shaders_EndEntities = Shaders.getMethod("endEntities", new Class[0]);
            Shaders_SetCameraShadow = Shaders.getMethod("setCameraShadow", PoseStack.class, Camera.class, Float.TYPE);
            Shaders_isShadowPass = Shaders.getField("isShadowPass");
            Class<?> ShaderUniforms = Class.forName("net.optifine.shaders.uniform.ShaderUniforms");
            ShaderUniforms_make1i = ShaderUniforms.getMethod("make1i", String.class);
            ShaderUniforms_make3f = ShaderUniforms.getMethod("make3f", String.class);
            ShaderUniforms_makeM4 = ShaderUniforms.getMethod("makeM4", String.class);
            ShaderUniform1i_setValue = Class.forName("net.optifine.shaders.uniform.ShaderUniform1i").getMethod("setValue", Integer.TYPE);
            ShaderUniform3f_setValue = Class.forName("net.optifine.shaders.uniform.ShaderUniform3f").getMethod("setValue", Float.TYPE, Float.TYPE, Float.TYPE);
            ShaderUniformM4_setValue = Class.forName("net.optifine.shaders.uniform.ShaderUniformM4").getMethod("setValue", Boolean.TYPE, FloatBuffer.class);
            Class<?> ShadersFramebuffer = Class.forName("net.optifine.shaders.ShadersFramebuffer");
            ShadersFramebuffer_BindFramebuffer = ShadersFramebuffer.getMethod("bindFramebuffer", new Class[0]);
            Class<?> GlState = Class.forName("net.optifine.shaders.GlState");
            GlState_unbindFramebuffer = GlState.getMethod("unbindFramebuffer", new Class[0]);
            CustomColors_GetSkyColoEnd = CustomColors.getDeclaredMethod("getSkyColorEnd", Vec3.class);
            CustomColors_GetSkyColoEnd.setAccessible(true);
            CustomColors_GetFogColor = CustomColors.getDeclaredMethod("getFogColor", Vec3.class, BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            CustomColors_GetFogColor.setAccessible(true);
            CustomColors_GetFogColorEnd = CustomColors.getDeclaredMethod("getFogColorEnd", Vec3.class);
            CustomColors_GetFogColorEnd.setAccessible(true);
            CustomColors_GetFogColorNether = CustomColors.getDeclaredMethod("getFogColorNether", Vec3.class);
            CustomColors_GetFogColorNether.setAccessible(true);
            Shaders_DFB = Shaders.getDeclaredField("dfb");
            Shaders_DFB.setAccessible(true);
            Shaders_shaderUniforms = Shaders.getDeclaredField("shaderUniforms");
            Shaders_shaderUniforms.setAccessible(true);
            try {
                Vertex_renderPositions = ModelPart.Vertex.class.getField("renderPositions");
            }
            catch (NoSuchFieldException e) {
                Vertex_renderPositions = null;
                if (ModelPart.Vertex.class.isRecord()) {
                    for (RecordComponent comp : ModelPart.Vertex.class.getRecordComponents()) {
                        if (!comp.getName().equals("renderPositions")) continue;
                        VertexRecord_renderPositions = comp.getAccessor();
                    }
                }
                try {
                    Class<?> Mutable2 = Class.forName("net.optifine.util.Mutable");
                    Mutable_get = Mutable2.getMethod("get", new Class[0]);
                    Mutable_set = Mutable2.getMethod("set", Object.class);
                }
                catch (ClassNotFoundException | NoSuchMethodException eRecord) {
                    VertexRecord_renderPositions = null;
                    Mutable_get = null;
                    Mutable_set = null;
                }
            }
        }
        catch (ClassNotFoundException e) {
            VRSettings.LOGGER.error("Vivecraft: Optifine detected, but couldn't load class:", (Throwable)e);
            OPTIFINE_LOADED = false;
        }
        catch (NoSuchMethodException e) {
            VRSettings.LOGGER.error("Vivecraft: Optifine detected, but couldn't load Method:", (Throwable)e);
            OPTIFINE_LOADED = false;
        }
        catch (NoSuchFieldException e) {
            VRSettings.LOGGER.error("Vivecraft: Optifine detected, but couldn't load Field:", (Throwable)e);
        }
    }

    private static void logError(Exception e, String call) {
        VRSettings.LOGGER.error("Vivecraft: error calling Optifine '{}':", (Object)call, (Object)e);
    }
}

