/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.client_vr.world;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRState;

@Mixin(value={Boat.class})
public abstract class BoatMixin
extends Entity {
    @Shadow
    private float f_38266_;
    @Shadow
    private boolean f_38273_;
    @Shadow
    private boolean f_38274_;
    @Shadow
    private boolean f_38275_;

    public BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyExpressionValue(method={"controlBoat"}, at={@At(value="CONSTANT", args={"floatValue=1F"}, ordinal=0)})
    private float vivecraft$inputLeft(float leftInput) {
        return VRState.VR_RUNNING ? Minecraft.m_91087_().f_91074_.f_108618_.f_108566_ : leftInput;
    }

    @ModifyExpressionValue(method={"controlBoat"}, at={@At(value="CONSTANT", args={"floatValue=1F"}, ordinal=1)})
    private float vivecraft$inputRight(float rightInput) {
        return VRState.VR_RUNNING ? -Minecraft.m_91087_().f_91074_.f_108618_.f_108566_ : rightInput;
    }

    @ModifyVariable(method={"controlBoat"}, at=@At(value="LOAD", ordinal=3))
    private float vivecraft$modifyAcceleration(float acceleration) {
        ClientDataHolderVR dataHolder = ClientDataHolderVR.getInstance();
        if (VRState.VR_RUNNING && !dataHolder.vrSettings.seated) {
            if (this.f_38275_) {
                float yaw;
                switch (dataHolder.vrSettings.getVrFreeMoveMode(false, dataHolder.vrPlayer.vrdata_world_pre.fbtMode)) {
                    case HMD: {
                        float f = dataHolder.vrPlayer.vrdata_world_pre.hmd.getYaw();
                        break;
                    }
                    case WAIST: {
                        float f = dataHolder.vrPlayer.vrdata_world_pre.waist.getYaw();
                        break;
                    }
                    default: {
                        float f = yaw = dataHolder.vrPlayer.vrdata_world_pre.getController(1).getYaw();
                    }
                }
                if (dataHolder.vrSettings.vehicleRotation) {
                    float start;
                    float end = this.m_146908_() % 360.0f;
                    float difference = Math.abs(end - (start = yaw));
                    if (difference > 180.0f) {
                        if (end > start) {
                            start += 360.0f;
                        } else {
                            end += 360.0f;
                        }
                    }
                    difference = end - start;
                    acceleration = 0.0f;
                    if (Math.abs(difference) < 30.0f) {
                        acceleration = 0.04f;
                    } else if (Math.abs(difference) > 150.0f) {
                        acceleration = -0.005f;
                    } else if (difference != 0.0f) {
                        acceleration = 0.005f;
                    }
                    if (Math.abs(difference) > 10.0f && Math.abs(difference) < 150.0f) {
                        this.f_38266_ -= Math.signum(difference) * Math.min(1.0f, Math.max(0.0f, Math.abs(difference) - 25.0f) / 40.0f);
                    }
                } else {
                    this.m_146922_(yaw);
                }
            } else if (dataHolder.rowTracker.isRowing()) {
                this.f_38266_ += dataHolder.rowTracker.LOar / 1.5f;
                this.f_38266_ -= dataHolder.rowTracker.ROar / 1.5f;
                if (this.f_38266_ < 0.0f) {
                    this.f_38273_ = true;
                }
                if (this.f_38266_ > 0.0f) {
                    this.f_38274_ = true;
                }
                if ((acceleration = Math.min(0.04f, 0.06f * dataHolder.rowTracker.FOar)) > 0.0f) {
                    this.f_38275_ = true;
                }
            }
        }
        return acceleration;
    }
}

