/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client_vr.menuworlds;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.Util;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.Xplat;
import org.vivecraft.client.extensions.BufferBuilderExtension;
import org.vivecraft.client.utils.ClientUtils;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.menuworlds.FakeBlockAccess;
import org.vivecraft.client_vr.menuworlds.MenuWorldDownloader;
import org.vivecraft.client_vr.menuworlds.MenuWorldExporter;
import org.vivecraft.client_vr.settings.VRSettings;
import org.vivecraft.mixin.client.renderer.RenderStateShardAccessor;
import org.vivecraft.mod_compat_vr.iris.IrisHelper;
import org.vivecraft.mod_compat_vr.optifine.OptifineHelper;
import org.vivecraft.mod_compat_vr.sodium.SodiumHelper;

public class MenuWorldRenderer {
    private static final ResourceLocation MOON_LOCATION = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation CLOUDS_LOCATION = new ResourceLocation("textures/environment/clouds.png");
    private static final ResourceLocation END_SKY_LOCATION = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation FORCEFIELD_LOCATION = new ResourceLocation("textures/misc/forcefield.png");
    private static final ResourceLocation RAIN_LOCATION = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation SNOW_LOCATION = new ResourceLocation("textures/environment/snow.png");
    private final Minecraft mc;
    private DimensionSpecialEffects dimensionInfo;
    private FakeBlockAccess blockAccess;
    private final DynamicTexture lightTexture;
    private final NativeImage lightPixels;
    private final ResourceLocation lightTextureLocation;
    private boolean lightmapUpdateNeeded;
    private float blockLightRedFlicker;
    private int waterVisionTime;
    public int ticks = 0;
    public long time = 1000L;
    public boolean fastTime;
    private HashMap<RenderType, List<VertexBuffer>> vertexBuffers;
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;
    private VertexBuffer endSkyVBO;
    private VertexBuffer cloudVBO;
    private int renderDistance;
    private int renderDistanceChunks;
    public final MenuFogRenderer fogRenderer;
    public Set<TextureAtlasSprite> animatedSprites;
    private final Random rand;
    private boolean ready;
    private CloudStatus prevCloudsType;
    private int prevCloudX;
    private int prevCloudY;
    private int prevCloudZ;
    private Vec3 prevCloudColor;
    private boolean generateClouds = true;
    private int skyFlashTime;
    private float rainLevel;
    private float thunderLevel;
    private float worldRotation;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];
    private CompletableFuture<FakeBlockAccess> getWorldTask;
    public int renderMaxTime = 40;
    public Vec3i segmentSize = new Vec3i(64, 64, 64);
    private boolean building = false;
    private boolean reenableShaders = false;
    private long buildStartTime;
    private Map<Pair<RenderType, BlockPos>, BufferBuilder> bufferBuilders;
    private Map<Pair<RenderType, BlockPos>, BlockPos.MutableBlockPos> currentPositions;
    private Map<Pair<RenderType, BlockPos>, Integer> blockCounts;
    private Map<Pair<RenderType, BlockPos>, Long> renderTimes;
    private final List<CompletableFuture<Void>> builderFutures = new ArrayList<CompletableFuture<Void>>();
    private final Queue<Thread> builderThreads = new ConcurrentLinkedQueue<Thread>();
    private Throwable builderError;
    private static boolean FIRST_RENDER_DONE;
    private boolean rendering = false;

    public MenuWorldRenderer() {
        this.mc = Minecraft.m_91087_();
        this.lightTexture = new DynamicTexture(16, 16, false);
        this.lightTextureLocation = this.mc.m_91097_().m_118490_("vivecraft_light_map", this.lightTexture);
        this.lightPixels = this.lightTexture.m_117991_();
        this.fogRenderer = new MenuFogRenderer(this);
        this.rand = new Random();
        this.rand.nextInt();
    }

    public void init() {
        if (ClientDataHolderVR.getInstance().vrSettings.menuWorldSelection == VRSettings.MenuWorld.NONE) {
            VRSettings.LOGGER.info("Vivecraft: Main menu worlds disabled.");
            return;
        }
        try {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Initializing main menu world renderer...");
            this.loadRenderers();
            this.getWorldTask = CompletableFuture.supplyAsync(() -> {
                FakeBlockAccess fakeBlockAccess;
                block8: {
                    InputStream inputStream = MenuWorldDownloader.getRandomWorld();
                    try {
                        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Loading world data...");
                        FakeBlockAccess fakeBlockAccess2 = fakeBlockAccess = inputStream != null ? MenuWorldExporter.loadWorld(inputStream) : null;
                        if (inputStream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            VRSettings.LOGGER.error("Vivecraft: Exception thrown when loading main menu world, falling back to old menu room.", (Throwable)e);
                            return null;
                        }
                    }
                    inputStream.close();
                }
                return fakeBlockAccess;
            }, Util.m_183991_());
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: Exception thrown when initializing main menu world renderer, falling back to old menu room.", (Throwable)e);
        }
    }

    public void checkTask() {
        if (this.getWorldTask == null || !this.getWorldTask.isDone()) {
            return;
        }
        try {
            FakeBlockAccess world = this.getWorldTask.get();
            if (world != null) {
                this.setWorld(world);
                this.prepare();
            } else {
                VRSettings.LOGGER.warn("Vivecraft: Failed to load any main menu world, falling back to old menu room");
            }
        }
        catch (Exception e) {
            VRSettings.LOGGER.error("Vivecraft: error starting menuworld building:", (Throwable)e);
        }
        finally {
            this.getWorldTask = null;
        }
    }

    public void render(PoseStack poseStack) {
        this.rendering = true;
        GraphicsStatus current = (GraphicsStatus)this.mc.f_91066_.m_232060_().m_231551_();
        if (current == GraphicsStatus.FABULOUS) {
            this.mc.f_91066_.m_232060_().m_231514_((Object)GraphicsStatus.FANCY);
        }
        this.turnOnLightLayer();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.worldRotation));
        poseStack.m_252880_(-0.5f, -Mth.m_14187_((float)this.blockAccess.getGround()), -0.5f);
        Vec3 offset = new Vec3(0.5, (double)(-Mth.m_14187_((float)this.blockAccess.getGround())), 0.5).m_82524_(this.worldRotation * ((float)Math.PI / 180));
        Vec3 eyePosition = this.getEyePos().m_82549_(offset).m_82524_(-this.worldRotation * ((float)Math.PI / 180));
        this.fogRenderer.levelFogColor();
        this.renderSky(poseStack, eyePosition);
        this.fogRenderer.setupFog(FogRenderer.FogMode.FOG_TERRAIN);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Matrix4f modelView = poseStack.m_85850_().m_252922_();
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        RenderSystem.disableBlend();
        this.renderChunkLayer(RenderType.m_110451_(), modelView, projection);
        this.renderChunkLayer(RenderType.m_110457_(), modelView, projection);
        this.renderChunkLayer(RenderType.m_110463_(), modelView, projection);
        RenderSystem.enableBlend();
        float cloudHeight = this.dimensionInfo.m_108871_();
        if (OptifineHelper.isOptifineLoaded()) {
            cloudHeight += (float)(OptifineHelper.getCloudHeight() * 128.0);
        }
        if (eyePosition.f_82480_ + (double)this.blockAccess.getGround() + (double)this.blockAccess.m_141937_() < (double)cloudHeight) {
            this.renderClouds(poseStack, eyePosition.f_82479_, eyePosition.f_82480_ + (double)this.blockAccess.getGround() + (double)this.blockAccess.m_141937_(), eyePosition.f_82481_);
        }
        this.renderChunkLayer(RenderType.m_110466_(), modelView, projection);
        this.renderChunkLayer(RenderType.m_110503_(), modelView, projection);
        if (eyePosition.f_82480_ + (double)this.blockAccess.getGround() + (double)this.blockAccess.m_141937_() >= (double)cloudHeight) {
            this.renderClouds(poseStack, eyePosition.f_82479_, eyePosition.f_82480_ + (double)this.blockAccess.getGround() + (double)this.blockAccess.m_141937_(), eyePosition.f_82481_);
        }
        RenderSystem.depthMask((boolean)false);
        this.renderSnowAndRain(poseStack, eyePosition.f_82479_, 0.0, eyePosition.f_82481_);
        RenderSystem.depthMask((boolean)true);
        poseStack.m_85849_();
        this.turnOffLightLayer();
        this.mc.f_91066_.m_232060_().m_231514_((Object)current);
        this.rendering = false;
    }

    private void renderChunkLayer(RenderType layer, Matrix4f modelView, Matrix4f Projection) {
        List<VertexBuffer> buffers = this.vertexBuffers.get(layer);
        if (buffers.isEmpty()) {
            return;
        }
        layer.m_110185_();
        ShaderInstance shaderInstance = RenderSystem.getShader();
        shaderInstance.m_173363_();
        this.turnOnLightLayer();
        for (VertexBuffer vertexBuffer : buffers) {
            vertexBuffer.m_85921_();
            vertexBuffer.m_253207_(modelView, Projection, shaderInstance);
        }
        this.turnOffLightLayer();
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public void prepare() {
        if (this.vertexBuffers == null && !this.building) {
            VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Building geometry...");
            if (this.rand.nextInt(1000) == 0) {
                this.blockAccess.setGroundOffset(100.0f);
            }
            this.fastTime = new Random().nextInt(10) == 0;
            this.animatedSprites = ConcurrentHashMap.newKeySet();
            this.blockCounts = new ConcurrentHashMap<Pair<RenderType, BlockPos>, Integer>();
            this.renderTimes = new ConcurrentHashMap<Pair<RenderType, BlockPos>, Long>();
            if (IrisHelper.isLoaded() && IrisHelper.isShaderActive() && IrisHelper.hasIssuesWithMenuWorld()) {
                VRSettings.LOGGER.info("Vivecraft: Temporarily disabling shaders to build Menuworld.");
                this.reenableShaders = true;
                ClientUtils.addChatMessage((Component)Component.m_237115_((String)"vivecraft.messages.menuworldshaderdisable"));
                IrisHelper.setShadersActive(false);
            }
            try {
                this.vertexBuffers = new HashMap();
                this.bufferBuilders = new HashMap<Pair<RenderType, BlockPos>, BufferBuilder>();
                this.currentPositions = new HashMap<Pair<RenderType, BlockPos>, BlockPos.MutableBlockPos>();
                for (RenderType layer : RenderType.m_110506_()) {
                    this.vertexBuffers.put(layer, new LinkedList());
                    for (int x = -this.blockAccess.getXSize() / 2; x < this.blockAccess.getXSize() / 2; x += this.segmentSize.m_123341_()) {
                        for (int y = (int)(-this.blockAccess.getGround()); y < this.blockAccess.getYSize() - (int)this.blockAccess.getGround(); y += this.segmentSize.m_123342_()) {
                            for (int z = -this.blockAccess.getZSize() / 2; z < this.blockAccess.getZSize() / 2; z += this.segmentSize.m_123343_()) {
                                BlockPos pos = new BlockPos(x, y, z);
                                Pair pair = Pair.of((Object)layer, (Object)pos);
                                BufferBuilder vertBuffer = new BufferBuilder(32768);
                                vertBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                                this.bufferBuilders.put((Pair<RenderType, BlockPos>)pair, vertBuffer);
                                this.currentPositions.put((Pair<RenderType, BlockPos>)pair, pos.m_122032_());
                            }
                        }
                    }
                }
            }
            catch (OutOfMemoryError e) {
                VRSettings.LOGGER.error("Vivecraft: OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?", (Throwable)e);
                this.destroy();
                return;
            }
            catch (NullPointerException e) {
                VRSettings.LOGGER.error("Vivecraft: Something canceled menu world building while preparing", (Throwable)e);
                this.destroy();
                return;
            }
            this.buildStartTime = ClientUtils.milliTime();
            this.building = true;
        }
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void buildNext() {
        if (!this.builderFutures.stream().allMatch(CompletableFuture::isDone) || this.builderError != null) {
            return;
        }
        this.builderFutures.clear();
        if (this.currentPositions.entrySet().stream().allMatch(entry -> ((BlockPos.MutableBlockPos)entry.getValue()).m_123342_() >= Math.min(this.segmentSize.m_123342_() + ((BlockPos)((Pair)entry.getKey()).getRight()).m_123342_(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()))) {
            this.finishBuilding();
            return;
        }
        long startTime = ClientUtils.milliTime();
        for (Pair<RenderType, BlockPos> pair : this.bufferBuilders.keySet()) {
            if (this.currentPositions.get(pair).m_123342_() >= Math.min(this.segmentSize.m_123342_() + ((BlockPos)pair.getRight()).m_123342_(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) continue;
            if (FIRST_RENDER_DONE || !SodiumHelper.isLoaded() || !SodiumHelper.hasIssuesWithParallelBlockBuilding()) {
                this.builderFutures.add(CompletableFuture.runAsync(() -> this.buildGeometry(pair, startTime, this.renderMaxTime), Util.m_183991_()));
                continue;
            }
            this.buildGeometry(pair, startTime, this.renderMaxTime);
            if (this.blockCounts.getOrDefault(pair, 0) <= 0) continue;
            FIRST_RENDER_DONE = true;
        }
        CompletableFuture.allOf(this.builderFutures.toArray(new CompletableFuture[0])).thenRunAsync(this::handleError, Util.m_183991_());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildGeometry(Pair<RenderType, BlockPos> pair, long startTime, int maxTime) {
        if (ClientUtils.milliTime() - startTime >= (long)maxTime) {
            return;
        }
        RenderType layer = (RenderType)pair.getLeft();
        BlockPos offset = (BlockPos)pair.getRight();
        this.builderThreads.add(Thread.currentThread());
        long realStartTime = ClientUtils.milliTime();
        try {
            PoseStack thisPose = new PoseStack();
            int renderDistSquare = (this.renderDistance + 1) * (this.renderDistance + 1);
            BlockRenderDispatcher blockRenderer = this.mc.m_91289_();
            BufferBuilder vertBuffer = this.bufferBuilders.get(pair);
            BlockPos.MutableBlockPos pos = this.currentPositions.get(pair);
            RandomSource randomSource = RandomSource.m_216327_();
            int count = 0;
            while (ClientUtils.milliTime() - startTime < (long)maxTime && pos.m_123342_() < Math.min(this.segmentSize.m_123342_() + offset.m_123342_(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround()) && this.building) {
                BlockState state;
                if (Mth.m_14040_((int)pos.m_123342_()) <= this.renderDistance + 1 && Mth.m_211589_((double)pos.m_123341_(), (double)pos.m_123343_()) <= (double)renderDistSquare && (state = this.blockAccess.m_8055_((BlockPos)pos)) != null) {
                    FluidState fluidState = state.m_60819_();
                    if (!fluidState.m_76178_() && ItemBlockRenderTypes.m_109287_((FluidState)fluidState) == layer) {
                        for (TextureAtlasSprite sprite : Xplat.getFluidTextures((BlockAndTintGetter)this.blockAccess, (BlockPos)pos, fluidState)) {
                            if (sprite == null || sprite.m_245424_().m_245638_().sum() <= 1) continue;
                            this.animatedSprites.add(sprite);
                        }
                        blockRenderer.m_234363_((BlockPos)pos, (BlockAndTintGetter)this.blockAccess, (VertexConsumer)vertBuffer, state, (FluidState)new FluidStateWrapper(fluidState));
                        ++count;
                    }
                    if (state.m_60799_() != RenderShape.INVISIBLE && ItemBlockRenderTypes.m_109282_((BlockState)state) == layer) {
                        for (BakedQuad quad : this.mc.m_91304_().m_119430_().m_110893_(state).m_213637_(state, null, randomSource)) {
                            if (quad.m_173410_().m_245424_().m_245638_().sum() <= 1) continue;
                            this.animatedSprites.add(quad.m_173410_());
                        }
                        thisPose.m_85836_();
                        thisPose.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                        blockRenderer.m_234355_(state, (BlockPos)pos, (BlockAndTintGetter)this.blockAccess, thisPose, (VertexConsumer)vertBuffer, true, randomSource);
                        ++count;
                        thisPose.m_85849_();
                    }
                }
                pos.m_142451_(pos.m_123341_() + 1);
                if (pos.m_123341_() < Math.min(this.segmentSize.m_123341_() + offset.m_123341_(), this.blockAccess.getXSize() / 2)) continue;
                pos.m_142451_(offset.m_123341_());
                pos.m_142443_(pos.m_123343_() + 1);
                if (pos.m_123343_() < Math.min(this.segmentSize.m_123343_() + offset.m_123343_(), this.blockAccess.getZSize() / 2)) continue;
                pos.m_142443_(offset.m_123343_());
                pos.m_142448_(pos.m_123342_() + 1);
            }
            this.blockCounts.put(pair, this.blockCounts.getOrDefault(pair, 0) + count);
            this.renderTimes.put(pair, this.renderTimes.getOrDefault(pair, 0L) + (ClientUtils.milliTime() - realStartTime));
            if (pos.m_123342_() >= Math.min(this.segmentSize.m_123342_() + offset.m_123342_(), this.blockAccess.getYSize() - (int)this.blockAccess.getGround())) {
                VRSettings.LOGGER.debug("Vivecraft: MenuWorlds: Built {} blocks on {} layer at {},{},{} in {} ms", new Object[]{this.blockCounts.get(pair), ((RenderStateShardAccessor)layer).getName(), offset.m_123341_(), offset.m_123342_(), offset.m_123343_(), this.renderTimes.get(pair)});
            }
        }
        catch (Throwable e) {
            this.builderError = e;
        }
        finally {
            this.builderThreads.remove(Thread.currentThread());
        }
    }

    private void finishBuilding() {
        this.building = false;
        ArrayList<Map.Entry<Pair<RenderType, BlockPos>, BufferBuilder>> entryList = new ArrayList<Map.Entry<Pair<RenderType, BlockPos>, BufferBuilder>>(this.bufferBuilders.entrySet());
        entryList.sort(Comparator.comparing(entry -> (BlockPos)((Pair)entry.getKey()).getRight(), (posA, posB) -> {
            Vec3i center = new Vec3i(this.segmentSize.m_123341_() / 2, this.segmentSize.m_123342_() / 2, this.segmentSize.m_123343_() / 2);
            double distA = posA.m_121955_(center).m_123331_((Vec3i)BlockPos.f_121853_);
            double distB = posB.m_121955_(center).m_123331_((Vec3i)BlockPos.f_121853_);
            return Double.compare(distA, distB);
        }));
        int totalMemory = 0;
        int count = 0;
        for (Map.Entry<Pair<RenderType, BlockPos>, BufferBuilder> entry2 : entryList) {
            BufferBuilder.RenderedBuffer renderedBuffer;
            RenderType layer = (RenderType)entry2.getKey().getLeft();
            BufferBuilder vertBuffer = entry2.getValue();
            if (layer == RenderType.m_110466_()) {
                vertBuffer.m_277127_(VertexSorting.m_277071_((float)0.0f, (float)Mth.m_14187_((float)this.blockAccess.getGround()), (float)0.0f));
            }
            if (!(renderedBuffer = vertBuffer.m_231175_()).m_231199_()) {
                this.uploadGeometry(layer, renderedBuffer);
                ++count;
            }
            totalMemory += ((BufferBuilderExtension)vertBuffer).vivecraft$getBufferSize();
            ((BufferBuilderExtension)vertBuffer).vivecraft$freeBuffer();
        }
        this.bufferBuilders = null;
        this.currentPositions = null;
        this.ready = true;
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Built {} blocks in {} ms ({} ms CPU time)", new Object[]{this.blockCounts.values().stream().reduce(Integer::sum).orElse(0), ClientUtils.milliTime() - this.buildStartTime, this.renderTimes.values().stream().reduce(Long::sum).orElse(0L)});
        VRSettings.LOGGER.info("Vivecraft: MenuWorlds: Used {} temporary buffers ({} MiB), uploaded {} non-empty buffers", new Object[]{entryList.size(), totalMemory / 0x100000, count});
        if (this.reenableShaders) {
            this.reenableShaders = false;
            IrisHelper.setShadersActive(true);
        }
    }

    public boolean isOnBuilderThread() {
        return this.builderThreads.contains(Thread.currentThread());
    }

    private void handleError() {
        if (this.builderError == null) {
            return;
        }
        if (this.builderError instanceof OutOfMemoryError || this.builderError.getCause() instanceof OutOfMemoryError) {
            VRSettings.LOGGER.error("Vivecraft: OutOfMemoryError while building main menu world. Low system memory or 32-bit Java?", this.builderError);
        } else {
            VRSettings.LOGGER.error("Vivecraft: Exception thrown when building main menu world, falling back to old menu room.:", this.builderError);
        }
        this.destroy();
        this.setWorld(null);
        this.builderError = null;
    }

    private void uploadGeometry(RenderType layer, BufferBuilder.RenderedBuffer renderedBuffer) {
        VertexBuffer buffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        buffer.m_85921_();
        buffer.m_231221_(renderedBuffer);
        VertexBuffer.m_85931_();
        this.vertexBuffers.get(layer).add(buffer);
    }

    public void cancelBuilding() {
        this.building = false;
        this.builderFutures.forEach(CompletableFuture::join);
        this.builderFutures.clear();
        if (this.bufferBuilders != null) {
            for (BufferBuilder vertBuffer : this.bufferBuilders.values()) {
                ((BufferBuilderExtension)vertBuffer).vivecraft$freeBuffer();
            }
            this.bufferBuilders = null;
        }
        this.currentPositions = null;
    }

    public void destroy() {
        this.cancelBuilding();
        if (this.vertexBuffers != null) {
            for (List<VertexBuffer> buffers : this.vertexBuffers.values()) {
                for (VertexBuffer vertexBuffer : buffers) {
                    if (vertexBuffer == null) continue;
                    vertexBuffer.close();
                }
            }
            this.vertexBuffers = null;
        }
        this.animatedSprites = null;
        this.ready = false;
    }

    public void completeDestroy() {
        this.destroy();
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        if (this.endSkyVBO != null) {
            this.endSkyVBO.close();
        }
        if (this.cloudVBO != null) {
            this.cloudVBO.close();
        }
        this.lightTexture.close();
        this.ready = false;
    }

    public void tick() {
        ++this.ticks;
        this.updateTorchFlicker();
        if (this.areEyesInFluid((TagKey<Fluid>)FluidTags.f_13131_)) {
            int i = 1;
            this.waterVisionTime = Mth.m_14045_((int)(this.waterVisionTime + i), (int)0, (int)600);
        } else if (this.waterVisionTime > 0) {
            this.areEyesInFluid((TagKey<Fluid>)FluidTags.f_13131_);
            this.waterVisionTime = Mth.m_14045_((int)(this.waterVisionTime - 10), (int)0, (int)600);
        }
        if (SodiumHelper.isLoaded() && this.animatedSprites != null) {
            for (TextureAtlasSprite sprite : this.animatedSprites) {
                SodiumHelper.markTextureAsActive(sprite);
            }
        }
        if (OptifineHelper.isOptifineLoaded()) {
            for (TextureAtlasSprite sprite : this.animatedSprites) {
                OptifineHelper.markTextureAsActive(sprite);
            }
        }
    }

    public FakeBlockAccess getLevel() {
        return this.blockAccess;
    }

    public void setWorld(FakeBlockAccess blockAccess) {
        this.blockAccess = blockAccess;
        if (blockAccess != null) {
            this.dimensionInfo = blockAccess.getDimensionReaderInfo();
            this.lightmapUpdateNeeded = true;
            this.renderDistance = blockAccess.getXSize() / 2;
            this.renderDistanceChunks = this.renderDistance / 16;
            this.rainLevel = blockAccess.getRain() ? 1.0f : 0.0f;
            this.thunderLevel = blockAccess.getThunder() ? 1.0f : 0.0f;
            this.worldRotation = blockAccess.getRotation();
        }
    }

    public void loadRenderers() {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float g = i - 16;
                float h = Mth.m_14116_((float)(f * f + g * g));
                this.rainSizeX[i << 5 | j] = -g / h;
                this.rainSizeZ[i << 5 | j] = f / h;
            }
        }
        this.generateSky();
        this.generateEndSky();
        this.generateStars();
    }

    public boolean isReady() {
        return this.ready;
    }

    private void copyVisibleTextures() {
    }

    public void pushVisibleTextures() {
    }

    public void renderSky(PoseStack poseStack, Vec3 position) {
        if (this.dimensionInfo.m_108883_() == DimensionSpecialEffects.SkyType.END) {
            this.renderEndSky(poseStack);
        } else if (this.dimensionInfo.m_108883_() == DimensionSpecialEffects.SkyType.NORMAL) {
            float starBrightness;
            RenderSystem.setShader(GameRenderer::m_172808_);
            ShaderInstance skyShader = RenderSystem.getShader();
            this.fogRenderer.setupFog(FogRenderer.FogMode.FOG_SKY);
            Vec3 skyColor = this.getSkyColor(position);
            if (OptifineHelper.isOptifineLoaded()) {
                skyColor = OptifineHelper.getCustomSkyColor(skyColor, (BlockAndTintGetter)this.blockAccess, position.f_82479_, position.f_82480_, position.f_82481_);
            }
            this.fogRenderer.levelFogColor();
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)((float)skyColor.f_82479_), (float)((float)skyColor.f_82480_), (float)((float)skyColor.f_82481_), (float)1.0f);
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
                this.skyVBO.m_85921_();
                this.skyVBO.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), skyShader);
                VertexBuffer.m_85931_();
            }
            RenderSystem.enableBlend();
            float[] sunriseColor = null;
            try {
                sunriseColor = this.dimensionInfo.m_7518_(this.getTimeOfDay(), 0.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sunriseColor != null && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled())) {
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShader(GameRenderer::m_172811_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)this.getSunAngle()) < 0.0f ? 180.0f : 0.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                Matrix4f modelView = poseStack.m_85850_().m_252922_();
                bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
                bufferBuilder.m_252986_(modelView, 0.0f, 100.0f, 0.0f).m_85950_(sunriseColor[0], sunriseColor[1], sunriseColor[2], sunriseColor[3]).m_5752_();
                for (int j = 0; j <= 16; ++j) {
                    float f6 = (float)j * ((float)Math.PI * 2) / 16.0f;
                    float f7 = Mth.m_14031_((float)f6);
                    float f8 = Mth.m_14089_((float)f6);
                    bufferBuilder.m_252986_(modelView, f7 * 120.0f, f8 * 120.0f, -f8 * 40.0f * sunriseColor[3]).m_85950_(sunriseColor[0], sunriseColor[1], sunriseColor[2], 0.0f).m_5752_();
                }
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
                poseStack.m_85849_();
            }
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            float skyVisibility = 1.0f - this.getRainLevel();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)skyVisibility);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            Matrix4f modelView = poseStack.m_85850_().m_252922_();
            poseStack.m_252781_(Axis.f_252529_.m_252977_(this.getTimeOfDay() * 360.0f));
            float size = 30.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)SUN_LOCATION);
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferBuilder.m_252986_(modelView, -size, 100.0f, -size).m_7421_(0.0f, 0.0f).m_5752_();
                bufferBuilder.m_252986_(modelView, size, 100.0f, -size).m_7421_(1.0f, 0.0f).m_5752_();
                bufferBuilder.m_252986_(modelView, size, 100.0f, size).m_7421_(1.0f, 1.0f).m_5752_();
                bufferBuilder.m_252986_(modelView, -size, 100.0f, size).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            }
            size = 20.0f;
            if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSunMoonEnabled()) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
                int moonPhase = this.getMoonPhase();
                int l = moonPhase % 4;
                int i1 = moonPhase / 4 % 2;
                float u0 = (float)l / 4.0f;
                float v0 = (float)i1 / 2.0f;
                float u1 = (float)(l + 1) / 4.0f;
                float v1 = (float)(i1 + 1) / 2.0f;
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferBuilder.m_252986_(modelView, -size, -100.0f, size).m_7421_(u0, v1).m_5752_();
                bufferBuilder.m_252986_(modelView, size, -100.0f, size).m_7421_(u1, v1).m_5752_();
                bufferBuilder.m_252986_(modelView, size, -100.0f, -size).m_7421_(u1, v0).m_5752_();
                bufferBuilder.m_252986_(modelView, -size, -100.0f, -size).m_7421_(u0, v0).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            }
            if ((starBrightness = this.getStarBrightness() * skyVisibility) > 0.0f && (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isStarsEnabled())) {
                this.fogRenderer.setupNoFog();
                RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)starBrightness);
                this.starVBO.m_85921_();
                this.starVBO.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), GameRenderer.m_172808_());
                VertexBuffer.m_85931_();
                this.fogRenderer.setupFog(FogRenderer.FogMode.FOG_SKY);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
            double horizonDistance = position.f_82480_ - this.blockAccess.getHorizon();
            if (horizonDistance < 0.0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 12.0f, 0.0f);
                this.sky2VBO.m_85921_();
                this.sky2VBO.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), skyShader);
                VertexBuffer.m_85931_();
                poseStack.m_85849_();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
    }

    private void renderEndSky(PoseStack poseStack) {
        if (!OptifineHelper.isOptifineLoaded() || OptifineHelper.isSkyEnabled()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)END_SKY_LOCATION);
            this.endSkyVBO.m_85921_();
            this.endSkyVBO.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            VertexBuffer.m_85931_();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    public void renderClouds(PoseStack poseStack, double x, double y, double z) {
        float cloudHeight = this.dimensionInfo.m_108871_();
        if (!Float.isNaN(cloudHeight) && this.mc.f_91066_.m_92174_() != CloudStatus.OFF) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.depthMask((boolean)true);
            float cloudSizeXZ = 12.0f;
            float cloudSizeY = 4.0f;
            double cloudOffset = ((float)this.ticks + ClientUtils.getCurrentPartialTick()) * 0.03f;
            double cloudX = (x + cloudOffset) / 12.0;
            double cloudY = (double)cloudHeight - y + 0.33;
            if (OptifineHelper.isOptifineLoaded()) {
                cloudY += OptifineHelper.getCloudHeight() * 128.0;
            }
            double cloudZ = z / 12.0 + 0.33;
            cloudX -= (double)(Mth.m_14107_((double)(cloudX / 2048.0)) * 2048);
            cloudZ -= (double)(Mth.m_14107_((double)(cloudZ / 2048.0)) * 2048);
            float cloudXfract = (float)(cloudX - (double)Mth.m_14107_((double)cloudX));
            float cloudYfract = (float)(cloudY / 4.0 - (double)Mth.m_14107_((double)(cloudY / 4.0))) * 4.0f;
            float cloudZfract = (float)(cloudZ - (double)Mth.m_14107_((double)cloudZ));
            Vec3 cloudColor = this.getCloudColour();
            int cloudXfloor = (int)Math.floor(cloudX);
            int cloudYfloor = (int)Math.floor(cloudY / 4.0);
            int cloudZfloor = (int)Math.floor(cloudZ);
            if (cloudXfloor != this.prevCloudX || cloudYfloor != this.prevCloudY || cloudZfloor != this.prevCloudZ || this.mc.f_91066_.m_92174_() != this.prevCloudsType || this.prevCloudColor.m_82557_(cloudColor) > 2.0E-4) {
                this.prevCloudX = cloudXfloor;
                this.prevCloudY = cloudYfloor;
                this.prevCloudZ = cloudZfloor;
                this.prevCloudColor = cloudColor;
                this.prevCloudsType = this.mc.f_91066_.m_92174_();
                this.generateClouds = true;
            }
            if (this.generateClouds) {
                this.generateClouds = false;
                BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
                if (this.cloudVBO != null) {
                    this.cloudVBO.close();
                }
                this.cloudVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
                BufferBuilder.RenderedBuffer renderedBuffer = this.buildClouds(bufferBuilder, cloudX, cloudY, cloudZ, cloudColor);
                this.cloudVBO.m_85921_();
                this.cloudVBO.m_231221_(renderedBuffer);
                VertexBuffer.m_85931_();
            }
            RenderSystem.setShader(GameRenderer::m_172838_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)CLOUDS_LOCATION);
            this.fogRenderer.levelFogColor();
            poseStack.m_85836_();
            poseStack.m_85841_(12.0f, 1.0f, 12.0f);
            poseStack.m_252880_(-cloudXfract, cloudYfract, -cloudZfract);
            if (this.cloudVBO != null) {
                int w;
                this.cloudVBO.m_85921_();
                int n = w = this.prevCloudsType == CloudStatus.FANCY ? 0 : 1;
                while (w < 2) {
                    if (w == 0) {
                        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    } else {
                        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    }
                    this.cloudVBO.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
                    ++w;
                }
                VertexBuffer.m_85931_();
            }
            poseStack.m_85849_();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    private BufferBuilder.RenderedBuffer buildClouds(BufferBuilder bufferBuilder, double cloudX, double cloudY, double cloudZ, Vec3 cloudColor) {
        float texRes = 0.00390625f;
        float l = (float)Mth.m_14107_((double)cloudX) * 0.00390625f;
        float m = (float)Mth.m_14107_((double)cloudZ) * 0.00390625f;
        float redTop = (float)cloudColor.f_82479_;
        float greenTop = (float)cloudColor.f_82480_;
        float blueTop = (float)cloudColor.f_82481_;
        float redX = redTop * 0.9f;
        float greenX = greenTop * 0.9f;
        float blueX = blueTop * 0.9f;
        float redBottom = redTop * 0.7f;
        float greenBottom = greenTop * 0.7f;
        float blueBottom = blueTop * 0.7f;
        float redZ = redTop * 0.8f;
        float greenZ = greenTop * 0.8f;
        float blueZ = blueTop * 0.8f;
        RenderSystem.setShader(GameRenderer::m_172838_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85822_);
        float z = (float)Math.floor(cloudY / 4.0) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int aa = -3; aa <= 4; ++aa) {
                for (int ab = -3; ab <= 4; ++ab) {
                    int ae;
                    float ac = aa * 8;
                    float ad = ab * 8;
                    if (z > -5.0f) {
                        bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + 8.0f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redBottom, greenBottom, blueBottom, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + 8.0f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redBottom, greenBottom, blueBottom, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + 0.0f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redBottom, greenBottom, blueBottom, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + 0.0f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redBottom, greenBottom, blueBottom, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    }
                    if (z <= 5.0f) {
                        bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 8.0f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 8.0f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 0.0f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 4.0f - 9.765625E-4f), (double)(ad + 0.0f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                    }
                    if (aa > -1) {
                        for (ae = 0; ae < 8; ++ae) {
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 0.0f), (double)(z + 0.0f), (double)(ad + 8.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 0.0f), (double)(z + 4.0f), (double)(ad + 8.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 0.0f), (double)(z + 4.0f), (double)(ad + 0.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 0.0f), (double)(z + 0.0f), (double)(ad + 0.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (aa <= 1) {
                        for (ae = 0; ae < 8; ++ae) {
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 0.0f), (double)(ad + 8.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 4.0f), (double)(ad + 8.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 8.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 4.0f), (double)(ad + 0.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + (float)ae + 1.0f - 9.765625E-4f), (double)(z + 0.0f), (double)(ad + 0.0f)).m_7421_((ac + (float)ae + 0.5f) * 0.00390625f + l, (ad + 0.0f) * 0.00390625f + m).m_85950_(redX, greenX, blueX, 0.8f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
                        }
                    }
                    if (ab > -1) {
                        for (ae = 0; ae < 8; ++ae) {
                            bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 0.0f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 0.0f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 0.0f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                            bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 0.0f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
                        }
                    }
                    if (ab > 1) continue;
                    for (ae = 0; ae < 8; ++ae) {
                        bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 4.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 8.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).m_7421_((ac + 8.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                        bufferBuilder.m_5483_((double)(ac + 0.0f), (double)(z + 0.0f), (double)(ad + (float)ae + 1.0f - 9.765625E-4f)).m_7421_((ac + 0.0f) * 0.00390625f + l, (ad + (float)ae + 0.5f) * 0.00390625f + m).m_85950_(redZ, greenZ, blueZ, 0.8f).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
                    }
                }
            }
        } else {
            boolean aa = true;
            int ab = 32;
            for (int af = -32; af < 32; af += 32) {
                for (int ag = -32; ag < 32; ag += 32) {
                    bufferBuilder.m_5483_((double)af, (double)z, (double)(ag + 32)).m_7421_((float)af * 0.00390625f + l, (float)(ag + 32) * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferBuilder.m_5483_((double)(af + 32), (double)z, (double)(ag + 32)).m_7421_((float)(af + 32) * 0.00390625f + l, (float)(ag + 32) * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferBuilder.m_5483_((double)(af + 32), (double)z, (double)ag).m_7421_((float)(af + 32) * 0.00390625f + l, (float)ag * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                    bufferBuilder.m_5483_((double)af, (double)z, (double)ag).m_7421_((float)af * 0.00390625f + l, (float)ag * 0.00390625f + m).m_85950_(redTop, greenTop, blueTop, 0.8f).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                }
            }
        }
        return bufferBuilder.m_231175_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderSnowAndRain(PoseStack poseStack, double inX, double inY, double inZ) {
        if (this.getRainLevel() <= 0.0f) {
            return;
        }
        RenderSystem.getModelViewStack().m_85836_();
        RenderSystem.getModelViewStack().m_252931_(poseStack.m_85850_().m_252922_());
        RenderSystem.applyModelViewMatrix();
        try {
            int xFloor = Mth.m_14107_((double)inX);
            int yFloor = Mth.m_14107_((double)inY);
            int zFloor = Mth.m_14107_((double)inZ);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            int rainDistance = 5;
            if (Minecraft.m_91405_()) {
                rainDistance = 10;
            }
            RenderSystem.depthMask((boolean)true);
            int count = -1;
            float rainAnimationTime = (float)this.ticks + ClientUtils.getCurrentPartialTick();
            RenderSystem.setShader(GameRenderer::m_172829_);
            this.turnOnLightLayer();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int rainZ = zFloor - rainDistance; rainZ <= zFloor + rainDistance; ++rainZ) {
                for (int rainX = xFloor - rainDistance; rainX <= xFloor + rainDistance; ++rainX) {
                    float blend;
                    int upper;
                    int blockingHeight;
                    int lower;
                    int q = (rainZ - zFloor + 16) * 32 + rainX - xFloor + 16;
                    double r = (double)this.rainSizeX[q] * 0.5;
                    double s = (double)this.rainSizeZ[q] * 0.5;
                    mutableBlockPos.m_122169_((double)rainX, inY, (double)rainZ);
                    Biome biome = (Biome)this.blockAccess.m_204166_((BlockPos)mutableBlockPos).m_203334_();
                    if (!biome.m_264473_() || (lower = Math.max(yFloor - rainDistance, blockingHeight = this.blockAccess.getHeightBlocking(rainX, rainZ))) == (upper = Math.max(yFloor + rainDistance, blockingHeight))) continue;
                    int rainY = Math.max(blockingHeight, yFloor);
                    RandomSource randomSource = RandomSource.m_216335_((long)((long)(rainX * rainX) * 3121L + (long)rainX * 45238971L ^ (long)(rainZ * rainZ) * 418711L + (long)rainZ * 13761L));
                    mutableBlockPos.m_142448_(lower);
                    Biome.Precipitation precipitation = biome.m_264600_((BlockPos)mutableBlockPos);
                    if (precipitation == Biome.Precipitation.NONE) continue;
                    mutableBlockPos.m_142448_(rainY);
                    double localX = (double)rainX + 0.5;
                    double localZ = (double)rainZ + 0.5;
                    float distance = (float)Math.sqrt(localX * localX + localZ * localZ) / (float)rainDistance;
                    float xOffset = 0.0f;
                    float yOffset = 0.0f;
                    int skyLight = this.blockAccess.m_45517_(LightLayer.SKY, (BlockPos)mutableBlockPos) << 4;
                    int blockLight = this.blockAccess.m_45517_(LightLayer.BLOCK, (BlockPos)mutableBlockPos) << 4;
                    if (precipitation == Biome.Precipitation.RAIN) {
                        if (count != 0) {
                            if (count >= 0) {
                                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
                            }
                            count = 0;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)RAIN_LOCATION);
                            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        blend = (1.0f - distance * distance) * 0.5f + 0.5f;
                        int x = this.ticks + rainX * rainX * 3121 + rainX * 45238971 + rainZ * rainZ * 418711 + rainZ * 13761 & 0x1F;
                        yOffset = -((float)x + ClientUtils.getCurrentPartialTick()) / 32.0f * (3.0f + randomSource.m_188501_());
                    } else {
                        if (precipitation != Biome.Precipitation.SNOW) continue;
                        if (count != 1) {
                            if (count >= 0) {
                                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
                            }
                            count = 1;
                            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SNOW_LOCATION);
                            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
                        }
                        blend = (1.0f - distance * distance) * 0.3f + 0.5f;
                        xOffset = (float)(randomSource.m_188500_() + (double)rainAnimationTime * 0.01 * (double)((float)randomSource.m_188583_()));
                        float ae = -((float)(this.ticks & 0x1FF) + ClientUtils.getCurrentPartialTick()) / 512.0f;
                        float af = (float)(randomSource.m_188500_() + (double)(rainAnimationTime * (float)randomSource.m_188583_()) * 0.001);
                        yOffset = ae + af;
                        skyLight = (skyLight * 3 + 240) / 4;
                        blockLight = (blockLight * 3 + 240) / 4;
                    }
                    bufferBuilder.m_5483_(localX - r, (double)upper - inY, localZ - s).m_7421_(0.0f + xOffset, (float)lower * 0.25f + yOffset).m_85950_(1.0f, 1.0f, 1.0f, blend).m_7120_(blockLight, skyLight).m_5752_();
                    bufferBuilder.m_5483_(localX + r, (double)upper - inY, localZ + s).m_7421_(1.0f + xOffset, (float)lower * 0.25f + yOffset).m_85950_(1.0f, 1.0f, 1.0f, blend).m_7120_(blockLight, skyLight).m_5752_();
                    bufferBuilder.m_5483_(localX + r, (double)lower - inY, localZ + s).m_7421_(1.0f + xOffset, (float)upper * 0.25f + yOffset).m_85950_(1.0f, 1.0f, 1.0f, blend).m_7120_(blockLight, skyLight).m_5752_();
                    bufferBuilder.m_5483_(localX - r, (double)lower - inY, localZ - s).m_7421_(0.0f + xOffset, (float)upper * 0.25f + yOffset).m_85950_(1.0f, 1.0f, 1.0f, blend).m_7120_(blockLight, skyLight).m_5752_();
                }
            }
            if (count >= 0) {
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            }
        }
        finally {
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            this.turnOffLightLayer();
        }
    }

    public static int getLightColor(BlockAndTintGetter blockAndTintGetter, BlockPos blockPos) {
        int i = blockAndTintGetter.m_45517_(LightLayer.SKY, blockPos);
        int j = blockAndTintGetter.m_45517_(LightLayer.BLOCK, blockPos);
        return i << 20 | j << 4;
    }

    public float getTimeOfDay() {
        return this.blockAccess.m_6042_().m_63904_(this.time);
    }

    public float getSunAngle() {
        float dayTime = this.getTimeOfDay();
        return dayTime * ((float)Math.PI * 2);
    }

    public int getMoonPhase() {
        return this.blockAccess.m_6042_().m_63936_(this.time);
    }

    public float getSkyDarken() {
        float dayTime = this.getTimeOfDay();
        float h = 1.0f - (Mth.m_14089_((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        h = Mth.m_14036_((float)h, (float)0.0f, (float)1.0f);
        h = 1.0f - h;
        h *= 1.0f - this.getRainLevel() * 5.0f / 16.0f;
        return (h *= 1.0f - this.getThunderLevel() * 5.0f / 16.0f) * 0.8f + 0.2f;
    }

    public float getRainLevel() {
        return this.rainLevel;
    }

    public float getThunderLevel() {
        return this.thunderLevel * this.getRainLevel();
    }

    public float getStarBrightness() {
        float f = this.getTimeOfDay();
        float f1 = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        return f1 * f1 * 0.5f;
    }

    public Vec3 getSkyColor(Vec3 position) {
        float f;
        float darkening;
        float luminance;
        float dayTime = this.getTimeOfDay();
        Vec3 samplePosition = position.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        Vec3 skyColor = CubicSampler.m_130038_((Vec3)samplePosition, (i, j, k) -> Vec3.m_82501_((int)((Biome)this.blockAccess.m_7062_().m_204210_(i, j, k).m_203334_()).m_47463_()));
        float h = Mth.m_14089_((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        h = Mth.m_14036_((float)h, (float)0.0f, (float)1.0f);
        float skyColorR = (float)skyColor.f_82479_ * h;
        float skyColorG = (float)skyColor.f_82480_ * h;
        float skyColorB = (float)skyColor.f_82481_ * h;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.6f;
            darkening = 1.0f - rain * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        float thunder = this.getThunderLevel();
        if (f > 0.0f) {
            luminance = (skyColorR * 0.3f + skyColorG * 0.59f + skyColorB * 0.11f) * 0.2f;
            darkening = 1.0f - thunder * 0.75f;
            skyColorR = skyColorR * darkening + luminance * (1.0f - darkening);
            skyColorG = skyColorG * darkening + luminance * (1.0f - darkening);
            skyColorB = skyColorB * darkening + luminance * (1.0f - darkening);
        }
        if (!((Boolean)this.mc.f_91066_.m_231935_().m_231551_()).booleanValue() && this.skyFlashTime > 0) {
            float flash = (float)this.skyFlashTime - ClientUtils.getCurrentPartialTick();
            if (flash > 1.0f) {
                flash = 1.0f;
            }
            skyColorR = skyColorR * (1.0f - (flash *= 0.45f)) + 0.8f * flash;
            skyColorG = skyColorG * (1.0f - flash) + 0.8f * flash;
            skyColorB = skyColorB * (1.0f - flash) + flash;
        }
        return new Vec3((double)skyColorR, (double)skyColorG, (double)skyColorB);
    }

    public Vec3 getFogColor(Vec3 pos) {
        float f = Mth.m_14036_((float)(Mth.m_14089_((float)(this.getTimeOfDay() * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        Vec3 scaledPos = pos.m_82492_(2.0, 2.0, 2.0).m_82490_(0.25);
        return CubicSampler.m_130038_((Vec3)scaledPos, (x, y, z) -> this.dimensionInfo.m_5927_(Vec3.m_82501_((int)((Biome)this.blockAccess.m_7062_().m_204210_(x, y, z).m_203334_()).m_47539_()), f));
    }

    public Vec3 getCloudColour() {
        float dayTime = this.getTimeOfDay();
        float f1 = Mth.m_14089_((float)(dayTime * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float rain = this.getRainLevel();
        if (rain > 0.0f) {
            float luma = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float dark = 1.0f - rain * 0.95f;
            r = r * dark + luma * (1.0f - dark);
            g = g * dark + luma * (1.0f - dark);
            b = b * dark + luma * (1.0f - dark);
        }
        r *= f1 * 0.9f + 0.1f;
        g *= f1 * 0.9f + 0.1f;
        b *= f1 * 0.85f + 0.15f;
        float thunder = this.getThunderLevel();
        if (thunder > 0.0f) {
            float luma = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float dark = 1.0f - thunder * 0.95f;
            r = r * dark + luma * (1.0f - dark);
            g = g * dark + luma * (1.0f - dark);
            b = b * dark + luma * (1.0f - dark);
        }
        return new Vec3((double)r, (double)g, (double)b);
    }

    private void generateSky() {
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        if (this.skyVBO != null) {
            this.skyVBO.close();
        }
        if (this.sky2VBO != null) {
            this.sky2VBO.close();
        }
        this.skyVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.skyVBO.m_85921_();
        this.skyVBO.m_231221_(MenuWorldRenderer.buildSkyDisc(bufferBuilder, 16.0f));
        VertexBuffer.m_85931_();
        this.sky2VBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.sky2VBO.m_85921_();
        this.sky2VBO.m_231221_(MenuWorldRenderer.buildSkyDisc(bufferBuilder, 16.0f));
        VertexBuffer.m_85931_();
    }

    private void generateEndSky() {
        if (this.endSkyVBO != null) {
            this.endSkyVBO.close();
        }
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        for (int i = 0; i < 6; ++i) {
            Matrix4f matrix = new Matrix4f();
            switch (i) {
                case 1: {
                    matrix.rotationX(1.5707964f);
                    break;
                }
                case 2: {
                    matrix.rotationX(-1.5707964f);
                    break;
                }
                case 3: {
                    matrix.rotationX((float)Math.PI);
                    break;
                }
                case 4: {
                    matrix.rotationZ(1.5707964f);
                    break;
                }
                case 5: {
                    matrix.rotationZ(-1.5707964f);
                }
            }
            int r = 40;
            int g = 40;
            int b = 40;
            if (OptifineHelper.isOptifineLoaded() && OptifineHelper.isCustomColors()) {
                Vec3 newSkyColor = new Vec3((double)r / 255.0, (double)g / 255.0, (double)b / 255.0);
                newSkyColor = OptifineHelper.getCustomSkyColorEnd(newSkyColor);
                r = (int)(newSkyColor.f_82479_ * 255.0);
                g = (int)(newSkyColor.f_82480_ * 255.0);
                b = (int)(newSkyColor.f_82481_ * 255.0);
            }
            bufferBuilder.m_252986_(matrix, -100.0f, -100.0f, -100.0f).m_7421_(0.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_252986_(matrix, -100.0f, -100.0f, 100.0f).m_7421_(0.0f, 16.0f).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_252986_(matrix, 100.0f, -100.0f, 100.0f).m_7421_(16.0f, 16.0f).m_6122_(r, g, b, 255).m_5752_();
            bufferBuilder.m_252986_(matrix, 100.0f, -100.0f, -100.0f).m_7421_(16.0f, 0.0f).m_6122_(r, g, b, 255).m_5752_();
        }
        this.endSkyVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.endSkyVBO.m_85921_();
        this.endSkyVBO.m_231221_(bufferBuilder.m_231175_());
        VertexBuffer.m_85931_();
    }

    private static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder bufferBuilder, float posY) {
        float g = Math.signum(posY) * 512.0f;
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85814_);
        bufferBuilder.m_5483_(0.0, (double)posY, 0.0).m_5752_();
        for (int i = -180; i <= 180; i += 45) {
            bufferBuilder.m_5483_((double)(g * Mth.m_14089_((float)((float)i * ((float)Math.PI / 180)))), (double)posY, (double)(512.0f * Mth.m_14031_((float)((float)i * ((float)Math.PI / 180))))).m_5752_();
        }
        return bufferBuilder.m_231175_();
    }

    private void generateStars() {
        if (this.starVBO != null) {
            this.starVBO.close();
        }
        this.starVBO = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.starVBO.m_85921_();
        this.starVBO.m_231221_(this.buildStars(Tesselator.m_85913_().m_85915_()));
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer buildStars(BufferBuilder bufferBuilder) {
        RandomSource randomSource = RandomSource.m_216335_((long)10842L);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        int starCount = 1500;
        float starDistance = 100.0f;
        for (int i = 0; i < starCount; ++i) {
            Vector3f starPoint = new Vector3f(randomSource.m_188501_(), randomSource.m_188501_(), randomSource.m_188501_()).mul(2.0f).sub(1.0f, 1.0f, 1.0f);
            float starSize = 0.15f + randomSource.m_188501_() * 0.1f;
            float distance = starPoint.lengthSquared();
            if (distance <= 0.010000001f || distance >= 1.0f) continue;
            starPoint.normalize(starDistance);
            float starRotation = (float)(randomSource.m_188500_() * Math.PI * 2.0);
            Matrix3f rotation = new Matrix3f().rotateTowards((Vector3fc)starPoint.negate(new Vector3f()), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotateZ(-starRotation);
            Vector3f point = new Vector3f(starSize, -starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint);
            bufferBuilder.m_5483_((double)point.x, (double)point.y, (double)point.z).m_5752_();
            point.set(starSize, starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint);
            bufferBuilder.m_5483_((double)point.x, (double)point.y, (double)point.z).m_5752_();
            point.set(-starSize, starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint);
            bufferBuilder.m_5483_((double)point.x, (double)point.y, (double)point.z).m_5752_();
            point.set(-starSize, -starSize, 0.0f).mul((Matrix3fc)rotation).add((Vector3fc)starPoint);
            bufferBuilder.m_5483_((double)point.x, (double)point.y, (double)point.z).m_5752_();
        }
        return bufferBuilder.m_231175_();
    }

    public void turnOffLightLayer() {
        RenderSystem.setShaderTexture((int)2, (int)0);
    }

    public void turnOnLightLayer() {
        RenderSystem.setShaderTexture((int)2, (ResourceLocation)this.lightTextureLocation);
        this.mc.m_91097_().m_174784_(this.lightTextureLocation);
        RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
    }

    public void updateTorchFlicker() {
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.lightmapUpdateNeeded = true;
    }

    public void updateLightmap() {
        if (this.lightmapUpdateNeeded) {
            float skyLight = this.getSkyDarken();
            float effectiveSkyLight = this.skyFlashTime > 0 ? 1.0f : skyLight * 0.95f + 0.05f;
            float waterVision = this.getWaterVision();
            float nightVision = 0.0f;
            Vector3f skylightColor = new Vector3f(skyLight, skyLight, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
            Vector3f finalColor = new Vector3f();
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    float skyBrightness = this.getBrightness(this.blockAccess.m_6042_(), i) * effectiveSkyLight;
                    float blockBrightnessRed = this.getBrightness(this.blockAccess.m_6042_(), j) * (this.blockLightRedFlicker + 1.5f);
                    float blockBrightnessGreen = blockBrightnessRed * ((blockBrightnessRed * 0.6f + 0.4f) * 0.6f + 0.4f);
                    float blockBrightnessBlue = blockBrightnessRed * (blockBrightnessRed * blockBrightnessRed * 0.6f + 0.4f);
                    finalColor.set(blockBrightnessRed, blockBrightnessGreen, blockBrightnessBlue);
                    if (this.dimensionInfo.m_108884_()) {
                        finalColor.lerp((Vector3fc)new Vector3f(0.99f, 1.12f, 1.0f), 0.25f);
                        finalColor.set(Mth.m_14036_((float)finalColor.x, (float)0.0f, (float)1.0f), Mth.m_14036_((float)finalColor.y, (float)0.0f, (float)1.0f), Mth.m_14036_((float)finalColor.z, (float)0.0f, (float)1.0f));
                    } else {
                        finalColor.add((Vector3fc)new Vector3f((Vector3fc)skylightColor).mul(skyBrightness));
                        finalColor.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                    }
                    if (!this.dimensionInfo.m_108884_()) {
                        finalColor.set(Mth.m_14036_((float)finalColor.x, (float)0.0f, (float)1.0f), Mth.m_14036_((float)finalColor.y, (float)0.0f, (float)1.0f), Mth.m_14036_((float)finalColor.z, (float)0.0f, (float)1.0f));
                    }
                    float gamma = ((Double)this.mc.f_91066_.m_231927_().m_231551_()).floatValue();
                    Vector3f vector3f5 = new Vector3f(this.notGamma(finalColor.x), this.notGamma(finalColor.y), this.notGamma(finalColor.z));
                    finalColor.lerp((Vector3fc)vector3f5, Math.max(0.0f, gamma));
                    finalColor.lerp((Vector3fc)new Vector3f(0.75f, 0.75f, 0.75f), 0.04f);
                    finalColor.set(Mth.m_14036_((float)finalColor.x, (float)0.0f, (float)1.0f), Mth.m_14036_((float)finalColor.y, (float)0.0f, (float)1.0f), Mth.m_14036_((float)finalColor.z, (float)0.0f, (float)1.0f));
                    finalColor.mul(255.0f);
                    int r = (int)finalColor.x();
                    int g = (int)finalColor.y();
                    int b = (int)finalColor.z();
                    this.lightPixels.m_84988_(j, i, 0xFF000000 | b << 16 | g << 8 | r);
                }
            }
            this.lightTexture.m_117985_();
            this.lightmapUpdateNeeded = false;
        }
    }

    private float notGamma(float f) {
        float g = 1.0f - f;
        return 1.0f - g * g * g * g;
    }

    private float getBrightness(DimensionType dimensionType, int lightLevel) {
        float f = (float)lightLevel / 15.0f;
        float g = f / (4.0f - 3.0f * f);
        return Mth.m_14179_((float)dimensionType.f_63838_(), (float)g, (float)1.0f);
    }

    public float getWaterVision() {
        if (!this.areEyesInFluid((TagKey<Fluid>)FluidTags.f_13131_)) {
            return 0.0f;
        }
        if ((float)this.waterVisionTime >= 600.0f) {
            return 1.0f;
        }
        float f2 = Mth.m_14036_((float)((float)this.waterVisionTime / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)this.waterVisionTime < 100.0f ? 0.0f : Mth.m_14036_((float)(((float)this.waterVisionTime - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    public boolean areEyesInFluid(TagKey<Fluid> tagIn) {
        if (this.blockAccess == null) {
            return false;
        }
        Vec3 pos = this.getEyePos();
        BlockPos blockpos = BlockPos.m_274446_((Position)pos);
        FluidState fluidstate = this.blockAccess.m_6425_(blockpos);
        return this.isFluidTagged(fluidstate, tagIn) && pos.f_82480_ < (double)((float)blockpos.m_123342_() + (float)fluidstate.m_76186_() + 0.11111111f);
    }

    public Vec3 getEyePos() {
        return ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getPosition();
    }

    private boolean isFluidTagged(Fluid fluid, TagKey<Fluid> tag) {
        if (tag == FluidTags.f_13131_) {
            return fluid == Fluids.f_76193_ || fluid == Fluids.f_76192_;
        }
        if (tag == FluidTags.f_13132_) {
            return fluid == Fluids.f_76195_ || fluid == Fluids.f_76194_;
        }
        return false;
    }

    private boolean isFluidTagged(FluidState fluidState, TagKey<Fluid> tag) {
        return this.isFluidTagged(fluidState.m_76152_(), tag);
    }

    public static class MenuFogRenderer {
        public float fogRed;
        public float fogGreen;
        public float fogBlue;
        private int targetBiomeFog;
        private int previousBiomeFog;
        private long biomeChangedTime;
        private final MenuWorldRenderer menuWorldRenderer;

        public MenuFogRenderer(MenuWorldRenderer menuWorldRenderer) {
            this.menuWorldRenderer = menuWorldRenderer;
        }

        public void setupFogColor() {
            Vec3 eyePos = this.menuWorldRenderer.getEyePos();
            FogType fogType = this.getEyeFogType();
            if (fogType == FogType.WATER) {
                this.updateWaterFog(this.menuWorldRenderer.getLevel());
            } else if (fogType == FogType.LAVA) {
                this.fogRed = 0.6f;
                this.fogGreen = 0.1f;
                this.fogBlue = 0.0f;
                this.biomeChangedTime = -1L;
            } else if (fogType == FogType.POWDER_SNOW) {
                this.fogRed = 0.623f;
                this.fogGreen = 0.734f;
                this.fogBlue = 0.785f;
                this.biomeChangedTime = -1L;
            } else {
                this.updateSurfaceFog();
                this.biomeChangedTime = -1L;
            }
            float d0 = (float)((eyePos.f_82480_ + (double)this.menuWorldRenderer.getLevel().getGround()) * this.menuWorldRenderer.getLevel().getVoidFogYFactor());
            if ((double)d0 < 1.0 && fogType != FogType.LAVA && fogType != FogType.POWDER_SNOW) {
                if (d0 < 0.0f) {
                    d0 = 0.0f;
                }
                d0 *= d0;
                this.fogRed *= d0;
                this.fogGreen *= d0;
                this.fogBlue *= d0;
            }
            if (fogType == FogType.WATER && this.fogRed != 0.0f && this.fogGreen != 0.0f && this.fogBlue != 0.0f) {
                float f1 = this.menuWorldRenderer.getWaterVision();
                float f3 = Math.min(1.0f / this.fogRed, Math.min(1.0f / this.fogGreen, 1.0f / this.fogBlue));
                this.fogRed = this.fogRed * (1.0f - f1) + this.fogRed * f3 * f1;
                this.fogGreen = this.fogGreen * (1.0f - f1) + this.fogGreen * f3 * f1;
                this.fogBlue = this.fogBlue * (1.0f - f1) + this.fogBlue * f3 * f1;
            }
            if (OptifineHelper.isOptifineLoaded()) {
                Vec3 colUnderlava;
                if (fogType == FogType.WATER) {
                    Vec3 colUnderwater = OptifineHelper.getCustomUnderwaterColor((BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_);
                    if (colUnderwater != null) {
                        this.fogRed = (float)colUnderwater.f_82479_;
                        this.fogGreen = (float)colUnderwater.f_82480_;
                        this.fogBlue = (float)colUnderwater.f_82481_;
                    }
                } else if (fogType == FogType.LAVA && (colUnderlava = OptifineHelper.getCustomUnderlavaColor((BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_)) != null) {
                    this.fogRed = (float)colUnderlava.f_82479_;
                    this.fogGreen = (float)colUnderlava.f_82480_;
                    this.fogBlue = (float)colUnderlava.f_82481_;
                }
            }
            RenderSystem.clearColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue, (float)0.0f);
        }

        private void updateSurfaceFog() {
            float f7;
            float f = 0.25f + 0.75f * (float)this.menuWorldRenderer.renderDistanceChunks / 32.0f;
            f = 1.0f - (float)Math.pow(f, 0.25);
            Vec3 eyePos = this.menuWorldRenderer.getEyePos();
            Vec3 skyColor = this.menuWorldRenderer.getSkyColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.m_6042_().f_63837_().equals((Object)BuiltinDimensionTypes.f_223542_)) {
                    skyColor = OptifineHelper.getCustomSkyColor(skyColor, (BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_);
                } else if (this.menuWorldRenderer.blockAccess.m_6042_().f_63837_().equals((Object)BuiltinDimensionTypes.f_223544_)) {
                    skyColor = OptifineHelper.getCustomSkyColorEnd(skyColor);
                }
            }
            float skyRed = (float)skyColor.f_82479_;
            float skyGreen = (float)skyColor.f_82480_;
            float skyBlue = (float)skyColor.f_82481_;
            Vec3 fogColor = this.menuWorldRenderer.getFogColor(eyePos);
            if (OptifineHelper.isOptifineLoaded()) {
                if (this.menuWorldRenderer.blockAccess.m_6042_().f_63837_().equals((Object)BuiltinDimensionTypes.f_223542_)) {
                    fogColor = OptifineHelper.getCustomFogColor(fogColor, (BlockAndTintGetter)this.menuWorldRenderer.blockAccess, eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_);
                } else if (this.menuWorldRenderer.blockAccess.m_6042_().f_63837_().equals((Object)BuiltinDimensionTypes.f_223544_)) {
                    fogColor = OptifineHelper.getCustomFogColorEnd(fogColor);
                } else if (this.menuWorldRenderer.blockAccess.m_6042_().f_63837_().equals((Object)BuiltinDimensionTypes.f_223543_)) {
                    fogColor = OptifineHelper.getCustomFogColorNether(fogColor);
                }
            }
            this.fogRed = (float)fogColor.f_82479_;
            this.fogGreen = (float)fogColor.f_82480_;
            this.fogBlue = (float)fogColor.f_82481_;
            if (this.menuWorldRenderer.renderDistanceChunks >= 4) {
                float d0 = Mth.m_14031_((float)this.menuWorldRenderer.getSunAngle()) > 0.0f ? -1.0f : 1.0f;
                float f5 = ClientDataHolderVR.getInstance().vrPlayer.vrdata_room_post.hmd.getDirection().rotateY(-this.menuWorldRenderer.worldRotation * ((float)Math.PI / 180)).dot(d0, 0.0f, 0.0f);
                if (f5 < 0.0f) {
                    f5 = 0.0f;
                }
                if (f5 > 0.0f) {
                    float[] sunriseColor = null;
                    try {
                        sunriseColor = this.menuWorldRenderer.dimensionInfo.m_7518_(this.menuWorldRenderer.getTimeOfDay(), 0.0f);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (sunriseColor != null) {
                        this.fogRed = this.fogRed * (1.0f - (f5 *= sunriseColor[3])) + sunriseColor[0] * f5;
                        this.fogGreen = this.fogGreen * (1.0f - f5) + sunriseColor[1] * f5;
                        this.fogBlue = this.fogBlue * (1.0f - f5) + sunriseColor[2] * f5;
                    }
                }
            }
            this.fogRed += (skyRed - this.fogRed) * f;
            this.fogGreen += (skyGreen - this.fogGreen) * f;
            this.fogBlue += (skyBlue - this.fogBlue) * f;
            float f6 = this.menuWorldRenderer.getRainLevel();
            if (f6 > 0.0f) {
                float f4 = 1.0f - f6 * 0.5f;
                float f8 = 1.0f - f6 * 0.4f;
                this.fogRed *= f4;
                this.fogGreen *= f4;
                this.fogBlue *= f8;
            }
            if ((f7 = this.menuWorldRenderer.getThunderLevel()) > 0.0f) {
                float f9 = 1.0f - f7 * 0.5f;
                this.fogRed *= f9;
                this.fogGreen *= f9;
                this.fogBlue *= f9;
            }
            this.biomeChangedTime = -1L;
        }

        private void updateWaterFog(LevelReader levelIn) {
            long currentTime = Util.m_137550_();
            int waterFogColor = ((Biome)levelIn.m_204166_(BlockPos.m_274446_((Position)this.menuWorldRenderer.getEyePos())).m_203334_()).m_47561_();
            if (this.biomeChangedTime < 0L) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = waterFogColor;
                this.biomeChangedTime = currentTime;
            }
            int k = this.targetBiomeFog >> 16 & 0xFF;
            int l = this.targetBiomeFog >> 8 & 0xFF;
            int i1 = this.targetBiomeFog & 0xFF;
            int j1 = this.previousBiomeFog >> 16 & 0xFF;
            int k1 = this.previousBiomeFog >> 8 & 0xFF;
            int l1 = this.previousBiomeFog & 0xFF;
            float f = Mth.m_14036_((float)((float)(currentTime - this.biomeChangedTime) / 5000.0f), (float)0.0f, (float)1.0f);
            float f1 = Mth.m_14179_((float)f, (float)j1, (float)k);
            float f2 = Mth.m_14179_((float)f, (float)k1, (float)l);
            float f3 = Mth.m_14179_((float)f, (float)l1, (float)i1);
            this.fogRed = f1 / 255.0f;
            this.fogGreen = f2 / 255.0f;
            this.fogBlue = f3 / 255.0f;
            if (this.targetBiomeFog != waterFogColor) {
                this.targetBiomeFog = waterFogColor;
                this.previousBiomeFog = Mth.m_14143_((float)f1) << 16 | Mth.m_14143_((float)f2) << 8 | Mth.m_14143_((float)f3);
                this.biomeChangedTime = currentTime;
            }
        }

        public void setupFog(FogRenderer.FogMode fogMode) {
            float fogEnd;
            float fogStart;
            FogType fogType = this.getEyeFogType();
            FogShape fogShape = FogShape.SPHERE;
            if (fogType == FogType.LAVA) {
                fogStart = 0.25f;
                fogEnd = 1.0f;
            } else if (fogType == FogType.POWDER_SNOW) {
                fogStart = 0.0f;
                fogEnd = 2.0f;
            } else if (fogType == FogType.WATER) {
                fogStart = -8.0f;
                fogEnd = 96.0f;
                Holder holder = this.menuWorldRenderer.blockAccess.m_204166_(BlockPos.m_274446_((Position)this.menuWorldRenderer.getEyePos()));
                if (holder.m_203656_(BiomeTags.f_215802_)) {
                    fogEnd *= 0.85f;
                }
                if (fogEnd > (float)this.menuWorldRenderer.renderDistance) {
                    fogEnd = this.menuWorldRenderer.renderDistance;
                    fogShape = FogShape.CYLINDER;
                }
            } else if (this.menuWorldRenderer.blockAccess.getDimensionReaderInfo().m_5781_(0, 0)) {
                fogStart = (float)this.menuWorldRenderer.renderDistance * 0.05f;
                fogEnd = Math.min((float)this.menuWorldRenderer.renderDistance, 192.0f) * 0.5f;
            } else if (fogMode == FogRenderer.FogMode.FOG_SKY) {
                fogStart = 0.0f;
                fogEnd = this.menuWorldRenderer.renderDistance;
                fogShape = FogShape.CYLINDER;
            } else {
                float h = Mth.m_14036_((float)((float)this.menuWorldRenderer.renderDistance / 10.0f), (float)4.0f, (float)64.0f);
                fogStart = (float)this.menuWorldRenderer.renderDistance - h;
                fogEnd = this.menuWorldRenderer.renderDistance;
                fogShape = FogShape.CYLINDER;
            }
            RenderSystem.setShaderFogStart((float)fogStart);
            RenderSystem.setShaderFogEnd((float)fogEnd);
            RenderSystem.setShaderFogShape((FogShape)fogShape);
        }

        private FogType getEyeFogType() {
            FogType fogType = FogType.NONE;
            if (this.menuWorldRenderer.areEyesInFluid((TagKey<Fluid>)FluidTags.f_13131_)) {
                fogType = FogType.WATER;
            } else if (this.menuWorldRenderer.areEyesInFluid((TagKey<Fluid>)FluidTags.f_13132_)) {
                fogType = FogType.LAVA;
            } else if (this.menuWorldRenderer.blockAccess.m_8055_(BlockPos.m_274446_((Position)this.menuWorldRenderer.getEyePos())).m_60713_(Blocks.f_152499_)) {
                fogType = FogType.POWDER_SNOW;
            }
            return fogType;
        }

        public void setupNoFog() {
            RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
        }

        public void levelFogColor() {
            RenderSystem.setShaderFogColor((float)this.fogRed, (float)this.fogGreen, (float)this.fogBlue);
        }
    }

    private static class FluidStateWrapper
    extends FluidState {
        private final FluidState fluidState;

        public FluidStateWrapper(FluidState fluidState) {
            super(fluidState.m_76152_(), fluidState.m_61148_(), fluidState.f_61113_);
            this.fluidState = fluidState;
        }

        public boolean m_205070_(TagKey<Fluid> tagIn) {
            if (tagIn == FluidTags.f_13131_) {
                return this.m_76152_() == Fluids.f_76193_ || this.m_76152_() == Fluids.f_76192_;
            }
            if (tagIn == FluidTags.f_13132_) {
                return this.m_76152_() == Fluids.f_76195_ || this.m_76152_() == Fluids.f_76194_;
            }
            return this.fluidState.m_205070_(tagIn);
        }
    }
}

