/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.client.gui.framework.screens;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.vivecraft.client.gui.framework.screens.GuiListEditorScreen;

public class GuiStringListEditorScreen
extends GuiListEditorScreen<String> {
    public GuiStringListEditorScreen(Component title, Screen lastScreen, boolean fixedEntryCount, Supplier<List<String>> valuesSupplier, Runnable loadDefaults, Consumer<List<String>> save) {
        super(title, lastScreen, fixedEntryCount, valuesSupplier, loadDefaults, save);
        this.searchable = false;
    }

    @Override
    protected void addNewValue() {
        super.addNewValue();
        this.elements.add("");
    }

    @Override
    protected GuiListEditorScreen.ValueEntry<String> toEntry(String value, int index) {
        EditBox box = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 350, 20, (Component)Component.m_237113_((String)value));
        box.m_94199_(1000);
        box.m_94144_(value);
        box.m_94151_(s -> this.elements.set(index, s));
        return new StringValueEntry((Component)Component.m_237119_(), box, button -> {
            this.elements.remove(index);
            this.reinit = true;
        }, !this.fixedEntryCount);
    }

    private static class StringValueEntry
    extends GuiListEditorScreen.ValueEntry<String> {
        private final EditBox editBox;
        private final Button deleteButton;

        public StringValueEntry(Component name, EditBox editBox, Button.OnPress deleteAction, boolean deletable) {
            super(name, null);
            this.editBox = editBox;
            this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)(deletable ? "-" : "X")), (Button.OnPress)(deletable ? deleteAction : b -> this.editBox.m_94144_(""))).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"selectWorld.delete"))).m_252987_(0, 0, 20, 20).m_253136_();
        }

        @Override
        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editBox.m_252865_(left);
            this.editBox.m_253211_(top);
            this.editBox.m_93674_(width - 20);
            this.editBox.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.deleteButton.m_252865_(left + width - 20);
            this.deleteButton.m_253211_(top);
            this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.m_7222_() == this.editBox && keyCode == 262 && this.editBox.m_94155_().length() == this.editBox.m_94207_()) {
                return false;
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.editBox, (Object)this.deleteButton);
        }

        @Override
        public void setActive(boolean active) {
            super.setActive(active);
            this.editBox.f_93623_ = active;
            this.deleteButton.f_93623_ = active;
        }

        @Override
        public String getValue() {
            return this.editBox.m_94155_();
        }
    }
}

