/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.axesareweapons.common;

import io.github.fourmisain.axesareweapons.common.config.AxesAreWeaponsConfig;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class AxesAreWeaponsCommon {
    public static final String MOD_ID = "axesareweapons";
    public static final AxesAreWeaponsConfig CONFIG;

    public static ResourceLocation id(String id) {
        return new ResourceLocation(MOD_ID, id);
    }

    public static void commonInit() {
    }

    public static boolean isWeapon(Item item) {
        return item instanceof AxeItem || AxesAreWeaponsCommon.CONFIG.shovelsAreWeapons && item instanceof ShovelItem || AxesAreWeaponsCommon.CONFIG.hoesAreWeapons && item instanceof HoeItem || AxesAreWeaponsCommon.CONFIG.pickaxesAreWeapons && item instanceof PickaxeItem || AxesAreWeaponsCommon.CONFIG.rangedWeaponsAreWeapons && item instanceof ProjectileWeaponItem || AxesAreWeaponsCommon.CONFIG.weaponIds.contains(BuiltInRegistries.f_257033_.m_7981_((Object)item));
    }

    public static float overrideCobWebMiningSpeed(Item item, BlockState state, float miningSpeed) {
        if (!AxesAreWeaponsCommon.CONFIG.fastCobWebBreaking || state.m_60734_() != Blocks.f_50033_ || !AxesAreWeaponsCommon.isWeapon(item)) {
            return miningSpeed;
        }
        return 15.0f;
    }

    public static boolean overrideCobWebSuitableness(Item item, BlockState state) {
        return AxesAreWeaponsCommon.CONFIG.fastCobWebBreaking && state.m_60734_() == Blocks.f_50033_ && AxesAreWeaponsCommon.isWeapon(item);
    }

    public static void overrideCobWebSuitableness(Item item, BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (AxesAreWeaponsCommon.overrideCobWebSuitableness(item, state)) {
            cir.setReturnValue((Object)true);
        }
    }

    public static void addEnchantmentEntry(List<EnchantmentInstance> entries, int power, Enchantment enchantment) {
        if (entries.stream().anyMatch(entry -> entry.f_44947_ == enchantment)) {
            return;
        }
        for (int level = enchantment.m_6586_(); level >= enchantment.m_44702_(); --level) {
            if (enchantment.m_6183_(level) > power || power > enchantment.m_6175_(level)) continue;
            entries.add(new EnchantmentInstance(enchantment, level));
            break;
        }
    }

    static {
        Jankson jankson = new Jankson.Builder().registerSerializer(ResourceLocation.class, (identifier, marshaller) -> marshaller.serialize((Object)identifier.toString())).registerDeserializer(String.class, ResourceLocation.class, (object, marshaller) -> new ResourceLocation(object)).build();
        CONFIG = (AxesAreWeaponsConfig)AutoConfig.register(AxesAreWeaponsConfig.class, (config, configClass) -> new JanksonConfigSerializer(config, configClass, jankson)).getConfig();
    }
}

