/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.utils;

import com.clefal.nirvana_lib.relocated.io.vavr.collection.List;
import com.clefal.teams.client.gui.screens.invite.TeamsInvitePlayerScreen;
import com.clefal.teams.client.gui.screens.request.TeamApplicationScreen;
import com.clefal.teams.client.gui.toast.ToastApplied;
import com.clefal.teams.client.gui.toast.ToastInviteSent;
import com.clefal.teams.client.gui.toast.ToastInvited;
import com.clefal.teams.client.gui.toast.ToastJoin;
import com.clefal.teams.client.gui.toast.ToastLeave;
import com.clefal.teams.client.gui.util.PlayerWithSkin;
import com.clefal.teams.network.client.S2CTeamUpdatePacket;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;

public final class ClientHelper {
    public static void addToast(Toast toast) {
        Minecraft.m_91087_().m_91300_().m_94922_(toast);
    }

    public static void addRequestToast(String team, String name, UUID id) {
        ClientHelper.addToast(ToastApplied.of(team, name, id));
    }

    public static void addInviteToast(String team) {
        ClientHelper.addToast(new ToastInvited(team));
    }

    public static void addJoinOrLeaveToast(S2CTeamUpdatePacket.Action action, String team, String name, boolean local) {
        switch (action) {
            case JOINED: {
                ClientHelper.addToast(new ToastJoin(team, name, local));
                break;
            }
            case LEFT: {
                ClientHelper.addToast(new ToastLeave(team, name, local));
            }
        }
    }

    public static void addInviteSentToast(String team, String player) {
        ClientHelper.addToast(new ToastInviteSent(team, player));
    }

    public static void tryUpdateInvitationScreenEntryList(List<PlayerWithSkin> names) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof TeamsInvitePlayerScreen) {
            TeamsInvitePlayerScreen screen2 = (TeamsInvitePlayerScreen)screen;
            screen2.entryList.updateList(names.toJavaList());
        }
    }

    public static void tryUpdateApplicationScreenEntryList(List<PlayerWithSkin> names) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof TeamApplicationScreen) {
            TeamApplicationScreen screen2 = (TeamApplicationScreen)screen;
            screen2.entryList.updateList(names.toJavaList());
        }
    }

    @Generated
    private ClientHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

