/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.server;

import com.clefal.nirvana_lib.relocated.io.vavr.control.Either;
import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.event.server.ServerJoinTeamEvent;
import com.clefal.teams.network.client.S2CTeamDataUpdatePacket;
import com.clefal.teams.server.ATServerTeam;
import com.clefal.teams.server.IHasTeam;
import com.clefal.teams.server.Invitation;
import com.clefal.teams.server.ModComponents;
import com.clefal.teams.utils.Failure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;

public class ATServerTeamData
extends SavedData {
    private static final String TEAMS_KEY = "teams";
    private Map<String, ATServerTeam> teams = new HashMap<String, ATServerTeam>();
    ServerLevel serverLevel;
    Scoreboard scoreboard;

    private ATServerTeamData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
        this.scoreboard = serverLevel.m_6188_();
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        this.toNBT(compoundTag);
        return compoundTag;
    }

    public com.clefal.nirvana_lib.relocated.io.vavr.collection.List<ATServerTeam> getTeams() {
        return com.clefal.nirvana_lib.relocated.io.vavr.collection.List.ofAll(this.teams.values());
    }

    private void announceUpdate(S2CTeamDataUpdatePacket.Type type, Collection<ServerPlayer> players, String ... name) {
        NetworkUtils.sendToClients((Object)new S2CTeamDataUpdatePacket(type, name), players);
        this.m_77762_();
    }

    public ATServerTeam createTeam(@NotNull String name, @NotNull ServerPlayer creator) {
        ATServerTeam team;
        if (((IHasTeam)creator).hasTeam()) {
            creator.m_213846_((Component)ModComponents.translatable("teams.error.alreadyinteam", creator.m_7755_().getString()));
            team = ((IHasTeam)creator).getTeam();
        } else {
            team = new ATServerTeam.Builder(name).complete(this, creator.m_20148_());
            this.teams.put(team.m_5758_(), team);
            team.addPlayer(creator);
            team.promote(creator);
            List players = creator.m_20194_().m_6846_().m_11314_();
            this.announceUpdate(S2CTeamDataUpdatePacket.Type.ONLINE, players, team.m_5758_());
        }
        return team;
    }

    public ATServerTeam createPublicTeam(@NotNull String name, @NotNull ServerPlayer creator) {
        ATServerTeam team = this.createTeam(name, creator);
        team.setPublic(true);
        return team;
    }

    public void disbandTeam(ATServerTeam team) {
        this.teams.remove(team.m_5758_());
        MinecraftServer server = this.serverLevel.m_7654_();
        this.scoreboard.m_83475_(this.scoreboard.m_83489_(team.m_5758_()));
        team.clear();
        List players = server.m_6846_().m_11314_();
        this.announceUpdate(S2CTeamDataUpdatePacket.Type.DISBAND, players, team.m_5758_());
    }

    public boolean isEmpty() {
        return this.teams.isEmpty();
    }

    public boolean hasTeam(String team) {
        return this.teams.containsKey(team);
    }

    public ATServerTeam getTeam(ServerPlayer player) {
        return ((IHasTeam)player).getTeam();
    }

    public ATServerTeam getTeam(String name) {
        return this.teams.get(name);
    }

    public Either<Failure, Boolean> invitePlayerToTeam(ServerPlayer player, ATServerTeam team) {
        IHasTeam player1 = (IHasTeam)player;
        if (player1.hasTeam()) {
            return Either.left((Object)Failure.in_a_team);
        }
        if (!player1.getInvitations().containsKey(team.m_5758_())) {
            ((IHasTeam)player).addInvitation(new Invitation(team.m_5758_()));
            return Either.right((Object)true);
        }
        return Either.left((Object)Failure.already_invite);
    }

    public boolean addPlayerToTeam(ServerPlayer player, ATServerTeam team) {
        if (((IHasTeam)player).hasTeam()) {
            return false;
        }
        team.addPlayer(player);
        AdvancedTeam.post(new ServerJoinTeamEvent(team, player));
        return true;
    }

    public boolean removePlayerFromTeam(ServerPlayer player) {
        ATServerTeam playerTeam = ((IHasTeam)player).getTeam();
        if (playerTeam == null) {
            return false;
        }
        playerTeam.removePlayer(player);
        if (playerTeam.isEmpty()) {
            this.disbandTeam(playerTeam);
        }
        return true;
    }

    public void fromNBT(CompoundTag compound) {
        this.teams.clear();
        ListTag list = compound.m_128437_(TEAMS_KEY, 10);
        ArrayList<String> add = new ArrayList<String>();
        for (Tag tag : list) {
            ATServerTeam atServerTeam = ATServerTeam.fromNBT((CompoundTag)tag, this);
            this.teams.put(atServerTeam.m_5758_(), atServerTeam);
            add.add(atServerTeam.m_5758_());
        }
        if (!list.isEmpty()) {
            this.announceUpdate(S2CTeamDataUpdatePacket.Type.ADD, this.serverLevel.m_7654_().m_6846_().m_11314_(), (String[])add.toArray(String[]::new));
        }
    }

    public void toNBT(CompoundTag compound) {
        ListTag list = new ListTag();
        for (ATServerTeam team : this.teams.values()) {
            list.add((Object)team.toNBT());
        }
        compound.m_128365_(TEAMS_KEY, (Tag)list);
    }

    static ATServerTeamData getOrMake(ServerLevel serverLevel) {
        return (ATServerTeamData)serverLevel.m_8895_().m_164861_(compoundTag -> ATServerTeamData.loadStatic(compoundTag, serverLevel), () -> new ATServerTeamData(serverLevel), TEAMS_KEY);
    }

    public static ATServerTeamData getOrMakeDefault(MinecraftServer server) {
        return ATServerTeamData.getOrMake(server.m_129783_());
    }

    public static ATServerTeamData loadStatic(CompoundTag compoundTag, ServerLevel level) {
        ATServerTeamData id = new ATServerTeamData(level);
        id.fromNBT(compoundTag);
        return id;
    }
}

