/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.server;

import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.config.ATServerConfig;
import com.clefal.teams.event.server.ServerOnPlayerOnlineEvent;
import com.clefal.teams.event.server.ServerPromoteEvent;
import com.clefal.teams.mixin.AdvancementAccessor;
import com.clefal.teams.network.client.S2CPermissionUpdatePacket;
import com.clefal.teams.network.client.S2CSyncRenderMatPacket;
import com.clefal.teams.network.client.S2CTeamAppliedPacket;
import com.clefal.teams.network.client.S2CTeamClearPacket;
import com.clefal.teams.network.client.S2CTeamDataUpdatePacket;
import com.clefal.teams.network.client.S2CTeamInitPacket;
import com.clefal.teams.network.client.S2CTeamPlayerDataPacket;
import com.clefal.teams.network.client.S2CTeamUpdatePacket;
import com.clefal.teams.network.client.config.S2CTeamConfigBooleanPacket;
import com.clefal.teams.server.ATServerTeamData;
import com.clefal.teams.server.Application;
import com.clefal.teams.server.ExpirableObject;
import com.clefal.teams.server.IHasTeam;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public class ATServerTeam
extends Team {
    public final String name;
    private final ATServerTeamData teamData;
    private final Set<Advancement> advancements = new LinkedHashSet<Advancement>();
    private UUID leader;
    private Set<Application> applications;
    private Set<UUID> players;
    private Map<UUID, ServerPlayer> onlinePlayers;
    private PlayerTeam scoreboardTeam;
    private boolean isPublic = false;
    private boolean allowEveryoneInvite = false;

    private ATServerTeam(Scoreboard scoreboard, String name, ATServerTeamData teamData, UUID leader) {
        this.name = name;
        this.teamData = teamData;
        this.leader = leader;
        this.players = new HashSet<UUID>();
        this.applications = new LinkedHashSet<Application>();
        this.onlinePlayers = new LinkedHashMap<UUID, ServerPlayer>();
        this.scoreboardTeam = scoreboard.m_83489_(name);
        if (this.scoreboardTeam == null) {
            this.scoreboardTeam = scoreboard.m_83492_(name);
        }
    }

    static ATServerTeam fromNBT(CompoundTag compound, ATServerTeamData teamData) {
        ATServerTeam team = new Builder(compound.m_128461_("name")).complete(teamData, compound.m_128342_("leader"));
        PlayerTeam vanillaTeam = team.scoreboardTeam;
        vanillaTeam.m_83351_(ChatFormatting.m_126657_((String)compound.m_128461_("colour")));
        vanillaTeam.m_83344_(Team.CollisionRule.m_83555_((String)compound.m_128461_("collision")));
        vanillaTeam.m_83355_(compound.m_128471_("friendlyFire"));
        vanillaTeam.m_83362_(compound.m_128471_("showInvisible"));
        vanillaTeam.m_83358_(Team.Visibility.m_83579_((String)compound.m_128461_("deathMessages")));
        vanillaTeam.m_83346_(Team.Visibility.m_83579_((String)compound.m_128461_("nameTags")));
        team.setPublic(compound.m_128471_("public"));
        team.setAllowEveryoneInvite(compound.m_128471_("allowEveryoneInvite"));
        for (Object application : compound.m_128437_("applications", 10)) {
            CompoundTag application1 = (CompoundTag)application;
            team.applications.add(Application.fromNBT(application1));
        }
        ListTag players = compound.m_128437_("players", 11);
        for (Tag elem : players) {
            try {
                UUID uuid = NbtUtils.m_129233_((Tag)elem);
                team.addPlayer(uuid);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ListTag advancements = compound.m_128437_("advancement", 8);
        for (Tag adv : advancements) {
            ResourceLocation id = ResourceLocation.m_135820_((String)adv.m_7916_());
            team.addAdvancement(teamData.serverLevel.m_7654_().m_129889_().m_136041_(id));
        }
        return team;
    }

    public void announceConfigChangeToClients() {
        List allPlayerForPublication = this.teamData.serverLevel.m_7654_().m_6846_().m_11314_();
        NetworkUtils.sendToClients((Object)new S2CTeamConfigBooleanPacket.Public(this.name, this.isPublic), (Iterable)allPlayerForPublication);
        NetworkUtils.sendToClients((Object)new S2CTeamConfigBooleanPacket.EveryoneCanInvite(this.name, this.allowEveryoneInvite), this.onlinePlayers.values());
    }

    public void announceConfigChangeToClient(ServerPlayer player) {
        NetworkUtils.sendToClient((Object)new S2CTeamConfigBooleanPacket.Public(this.name, this.isPublic), (ServerPlayer)player);
        NetworkUtils.sendToClient((Object)new S2CTeamConfigBooleanPacket.EveryoneCanInvite(this.name, this.allowEveryoneInvite), (ServerPlayer)player);
    }

    public void promote(ServerPlayer player) {
        this.leader = player.m_20148_();
        for (ServerPlayer onlinePlayer : this.onlinePlayers.values()) {
            NetworkUtils.sendToClient((Object)new S2CPermissionUpdatePacket(this.playerHasPermissions(onlinePlayer), this.leader), (ServerPlayer)onlinePlayer);
        }
        AdvancedTeam.post(new ServerPromoteEvent(player, this));
    }

    public void addApplication(Application application) {
        ServerPlayer player = this.teamData.serverLevel.m_7654_().m_6846_().m_11259_(application.applicant);
        if (player == null) {
            throw new NullPointerException("can't find player with UUID " + application.applicant + " when try to add application.");
        }
        this.applications.add(application);
        this.getOnlinePlayers().filter(this::playerHasPermissions).forEach(x -> {
            NetworkUtils.sendToClient((Object)new S2CSyncRenderMatPacket(player.m_7755_().getString(), S2CSyncRenderMatPacket.Action.ADD, S2CSyncRenderMatPacket.Type.APPLICATION), (ServerPlayer)x);
            NetworkUtils.sendToClient((Object)new S2CTeamAppliedPacket(this.name, player.m_20148_()), (ServerPlayer)x);
        });
    }

    public boolean isApplying(ServerPlayer player) {
        return this.applications.contains(new Application(player.m_20148_()));
    }

    public void tickApplication() {
        Iterator<Application> iterator = this.applications.iterator();
        while (iterator.hasNext()) {
            Application next = iterator.next();
            if (!next.update()) continue;
            iterator.remove();
            ServerPlayer player = this.teamData.serverLevel.m_7654_().m_6846_().m_11259_(next.applicant);
            if (player == null) {
                throw new NullPointerException("can't find player with UUID " + next.applicant + " when try to remove application.");
            }
            this.getOnlinePlayers().filter(this::playerHasPermissions).forEach(x -> NetworkUtils.sendToClient((Object)new S2CSyncRenderMatPacket(player.m_7755_().getString(), S2CSyncRenderMatPacket.Action.REMOVE, S2CSyncRenderMatPacket.Type.APPLICATION), (ServerPlayer)x));
        }
    }

    public void markApplicationAsRemoval(UUID target) {
        this.applications.stream().filter(x -> x.applicant.equals(target)).findFirst().ifPresent(ExpirableObject::markRemoval);
    }

    public boolean playerHasPermissions(ServerPlayer player) {
        return this.getLeader().equals(player.m_20148_()) || player.m_20310_(2);
    }

    public com.clefal.nirvana_lib.relocated.io.vavr.collection.List<ServerPlayer> getOnlinePlayers() {
        return com.clefal.nirvana_lib.relocated.io.vavr.collection.List.ofAll(this.onlinePlayers.values());
    }

    public boolean isEmpty() {
        return this.players.isEmpty();
    }

    public boolean hasPlayer(ServerPlayer player) {
        return this.hasPlayer(player.m_20148_());
    }

    public boolean hasPlayer(UUID player) {
        return this.players.contains(player);
    }

    public void addPlayer(ServerPlayer player) {
        this.addPlayer(player.m_20148_());
    }

    public void removePlayer(ServerPlayer player) {
        this.removePlayer(player.m_20148_());
    }

    public void clear() {
        ArrayList<UUID> playersCopy = new ArrayList<UUID>(this.players);
        playersCopy.forEach(player -> this.removePlayer((UUID)player));
        this.advancements.clear();
    }

    public void addAdvancement(Advancement advancement) {
        this.advancements.add(advancement);
    }

    public void onPlayerOnline(ServerPlayer player, boolean sendPackets) {
        this.onlinePlayers.put(player.m_20148_(), player);
        ((IHasTeam)player).setTeam(this);
        if (sendPackets) {
            List players;
            NetworkUtils.sendToClient((Object)new S2CTeamInitPacket(this.name, this.leader), (ServerPlayer)player);
            if (this.onlinePlayers.size() == 1) {
                players = this.teamData.serverLevel.m_7654_().m_6846_().m_11314_();
                NetworkUtils.sendToClients((Object)new S2CTeamDataUpdatePacket(S2CTeamDataUpdatePacket.Type.ONLINE, this.name), (Iterable)players);
            }
            players = this.getOnlinePlayers().toJavaList();
            NetworkUtils.sendToClients((Object)new S2CTeamPlayerDataPacket(player, S2CTeamPlayerDataPacket.Type.ADD), (Iterable)players);
            for (ServerPlayer teammate : players) {
                NetworkUtils.sendToClient((Object)new S2CTeamPlayerDataPacket(teammate, S2CTeamPlayerDataPacket.Type.ADD), (ServerPlayer)player);
                NetworkUtils.sendToClient((Object)new S2CPermissionUpdatePacket(this.playerHasPermissions(teammate), this.leader), (ServerPlayer)player);
            }
        }
        if (ATServerConfig.config.shareAchievements) {
            for (Advancement advancement : this.advancements) {
                AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
                for (String criterion : progress.m_8219_()) {
                    player.m_8960_().m_135988_(advancement, criterion);
                }
            }
        }
        if (this.playerHasPermissions(player)) {
            for (Application application : this.applications) {
                ServerPlayer target = this.teamData.serverLevel.m_7654_().m_6846_().m_11259_(application.applicant);
                if (target == null) {
                    throw new NullPointerException("can't find target with UUID " + application.applicant + " when try to add application.");
                }
                NetworkUtils.sendToClient((Object)new S2CSyncRenderMatPacket(target.m_7755_().getString(), S2CSyncRenderMatPacket.Action.ADD, S2CSyncRenderMatPacket.Type.APPLICATION), (ServerPlayer)player);
            }
        }
        AdvancedTeam.post(new ServerOnPlayerOnlineEvent(player));
    }

    public void onPlayerOffline(ServerPlayer player, boolean sendPackets) {
        this.onlinePlayers.remove(player.m_20148_());
        if (sendPackets) {
            Object players;
            if (this.isEmpty()) {
                players = this.teamData.serverLevel.m_7654_().m_6846_().m_11314_();
                NetworkUtils.sendToClients((Object)new S2CTeamDataUpdatePacket(S2CTeamDataUpdatePacket.Type.OFFLINE, this.name), players);
            }
            players = this.getOnlinePlayers();
            NetworkUtils.sendToClients((Object)new S2CTeamPlayerDataPacket(player, S2CTeamPlayerDataPacket.Type.REMOVE), players);
        }
    }

    private void addPlayer(UUID player) {
        ServerPlayer playerEntity;
        PlayerTeam playerScoreboardTeam;
        this.players.add(player);
        String playerName = this.getNameFromUUID(player);
        if (ATServerConfig.config.enableVanillaTeamCompat && ((playerScoreboardTeam = this.teamData.scoreboard.m_83500_(playerName)) == null || !playerScoreboardTeam.m_83536_((Team)this.scoreboardTeam))) {
            this.teamData.scoreboard.m_6546_(playerName, this.scoreboardTeam);
        }
        if ((playerEntity = this.teamData.serverLevel.m_7654_().m_6846_().m_11259_(player)) != null) {
            NetworkUtils.sendToClient((Object)new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.JOINED, true), (ServerPlayer)playerEntity);
            NetworkUtils.sendToClients((Object)new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.JOINED, false), (Iterable)this.getOnlinePlayers().toJavaList());
            this.onPlayerOnline(playerEntity, true);
            this.announceConfigChangeToClient(playerEntity);
            Set<Advancement> advancements = ((AdvancementAccessor)playerEntity.m_8960_()).getVisibleAdvancements();
            for (Advancement advancement : advancements) {
                if (!playerEntity.m_8960_().m_135996_(advancement).m_8193_()) continue;
                this.addAdvancement(advancement);
            }
            ((IHasTeam)playerEntity).clearInvitations();
            this.applications.stream().filter(x -> x.applicant.equals(player)).findFirst().ifPresent(ExpirableObject::markRemoval);
        }
        this.teamData.m_77762_();
    }

    private void removePlayer(UUID player) {
        ServerPlayer playerEntity;
        PlayerTeam playerScoreboardTeam;
        this.players.remove(player);
        String playerName = this.getNameFromUUID(player);
        if (ATServerConfig.config.enableVanillaTeamCompat && (playerScoreboardTeam = this.teamData.scoreboard.m_83500_(playerName)) != null && playerScoreboardTeam.m_83536_((Team)this.scoreboardTeam)) {
            this.teamData.scoreboard.m_6519_(playerName, this.scoreboardTeam);
        }
        if ((playerEntity = this.teamData.serverLevel.m_7654_().m_6846_().m_11259_(player)) != null) {
            this.onPlayerOffline(playerEntity, true);
            NetworkUtils.sendToClient((Object)new S2CTeamClearPacket(), (ServerPlayer)playerEntity);
            NetworkUtils.sendToClient((Object)new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.LEFT, true), (ServerPlayer)playerEntity);
            NetworkUtils.sendToClients((Object)new S2CTeamUpdatePacket(this.name, playerName, S2CTeamUpdatePacket.Action.LEFT, false), this.onlinePlayers.values());
            ((IHasTeam)playerEntity).setTeam(null);
        }
        com.clefal.nirvana_lib.relocated.io.vavr.collection.List<ServerPlayer> onlinePlayers1 = this.getOnlinePlayers();
        if (this.leader.equals(player) && onlinePlayers1.size() > 1) {
            com.clefal.nirvana_lib.relocated.io.vavr.collection.Iterator iterator = onlinePlayers1.iterator();
            if (iterator.hasNext()) {
                this.promote((ServerPlayer)iterator.next());
            }
        } else if (onlinePlayers1.size() == 1) {
            this.promote((ServerPlayer)onlinePlayers1.getOrElseThrow(() -> new NullPointerException("can't find the last player after removing, even there is still a player in team!")));
        }
        this.teamData.m_77762_();
    }

    private String getNameFromUUID(UUID id) {
        return this.teamData.serverLevel.m_7654_().m_129927_().m_11002_(id).map(GameProfile::getName).orElseThrow();
    }

    CompoundTag toNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("name", this.name);
        compound.m_128362_("leader", this.leader);
        compound.m_128359_("colour", this.scoreboardTeam.m_7414_().m_126666_());
        compound.m_128359_("collision", this.scoreboardTeam.m_7156_().f_83543_);
        compound.m_128359_("deathMessages", this.scoreboardTeam.m_7468_().f_83567_);
        compound.m_128359_("nameTags", this.scoreboardTeam.m_7470_().f_83567_);
        compound.m_128379_("friendlyFire", this.scoreboardTeam.m_6260_());
        compound.m_128379_("showInvisible", this.scoreboardTeam.m_6259_());
        compound.m_128379_("public", this.isPublic);
        compound.m_128379_("allowEveryoneInvite", this.allowEveryoneInvite);
        ListTag applicationList = new ListTag();
        for (Application application : this.applications) {
            applicationList.add((Object)application.toNBT());
        }
        compound.m_128365_("applications", (Tag)applicationList);
        ListTag playerList = new ListTag();
        for (UUID player : this.players) {
            playerList.add((Object)NbtUtils.m_129226_((UUID)player));
        }
        compound.m_128365_("players", (Tag)playerList);
        ListTag listTag = new ListTag();
        for (Advancement advancement : this.advancements) {
            listTag.add((Object)StringTag.m_129297_((String)advancement.m_138327_().toString()));
        }
        compound.m_128365_("advancements", (Tag)listTag);
        return compound;
    }

    public String m_5758_() {
        return this.name;
    }

    public MutableComponent m_6870_(Component name) {
        return this.scoreboardTeam.m_6870_(name);
    }

    public boolean m_6259_() {
        return this.scoreboardTeam.m_6259_();
    }

    public void setShowFriendlyInvisibles(boolean value) {
        this.scoreboardTeam.m_83362_(value);
    }

    public boolean m_6260_() {
        return this.scoreboardTeam.m_6260_();
    }

    public void setFriendlyFireAllowed(boolean value) {
        this.scoreboardTeam.m_83355_(value);
    }

    public Team.Visibility m_7470_() {
        return this.scoreboardTeam.m_7470_();
    }

    public void setNameTagVisibilityRule(Team.Visibility value) {
        this.scoreboardTeam.m_83346_(value);
    }

    public ChatFormatting m_7414_() {
        return this.scoreboardTeam.m_7414_();
    }

    public void setColour(ChatFormatting colour) {
        this.scoreboardTeam.m_83351_(colour);
    }

    public Collection<String> m_6809_() {
        return this.scoreboardTeam.m_6809_();
    }

    public Team.Visibility m_7468_() {
        return this.scoreboardTeam.m_7468_();
    }

    public void setDeathMessageVisibilityRule(Team.Visibility value) {
        this.scoreboardTeam.m_83358_(value);
    }

    public Team.CollisionRule m_7156_() {
        return this.scoreboardTeam.m_7156_();
    }

    public void setCollisionRule(Team.CollisionRule value) {
        this.scoreboardTeam.m_83344_(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ATServerTeam)) return false;
        ATServerTeam team = (ATServerTeam)((Object)obj);
        if (!Objects.equals(team.name, this.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public PlayerTeam getScoreboardTeam() {
        return this.scoreboardTeam;
    }

    @Generated
    public UUID getLeader() {
        return this.leader;
    }

    @Generated
    public boolean isPublic() {
        return this.isPublic;
    }

    @Generated
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Generated
    public boolean isAllowEveryoneInvite() {
        return this.allowEveryoneInvite;
    }

    @Generated
    public void setAllowEveryoneInvite(boolean allowEveryoneInvite) {
        this.allowEveryoneInvite = allowEveryoneInvite;
    }

    public static class Builder {
        private final String name;

        public Builder(String name) {
            this.name = name;
        }

        public ATServerTeam complete(ATServerTeamData teamData, UUID leader) {
            ATServerTeam team = new ATServerTeam(teamData.scoreboard, this.name, teamData, leader);
            return team;
        }
    }
}

