/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.network.client;

import com.clefal.nirvana_lib.network.newtoolchain.S2CModPacket;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.HashSet;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.event.client.ClientEvent;
import com.clefal.teams.event.client.ClientReadPropertyEvent;
import com.clefal.teams.event.server.ServerEvent;
import com.clefal.teams.event.server.ServerGatherPropertyEvent;
import com.clefal.teams.modules.internal.propertyhandler.IProperty;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class S2CTeamPlayerDataPacket
implements S2CModPacket<S2CTeamPlayerDataPacket> {
    public static final String ID_KEY = "playerUuid";
    public static final String NAME_KEY = "playerName";
    public static final String SKIN_KEY = "playerSkin";
    public static final String SKIN_SIG_KEY = "playerSkinSignature";
    public static final String TYPE_KEY = "actionType";
    public List<String> propertiesName = new ArrayList<String>();
    public HashSet<String> keys;
    CompoundTag tag = new CompoundTag();

    public S2CTeamPlayerDataPacket(ServerPlayer player, Type type, HashSet<String> keys) {
        this.tag.m_128362_(ID_KEY, player.m_20148_());
        this.tag.m_128359_(TYPE_KEY, type.toString());
        switch (type) {
            case ADD: {
                this.tag.m_128359_(NAME_KEY, player.m_7755_().getString());
                PropertyMap properties = player.m_36316_().getProperties();
                Property skin = null;
                if (properties.containsKey((Object)"textures")) {
                    skin = (Property)properties.get((Object)"textures").iterator().next();
                }
                this.tag.m_128359_(SKIN_KEY, skin != null ? skin.getValue() : "");
                this.tag.m_128359_(SKIN_SIG_KEY, skin != null ? (skin.getSignature() != null ? skin.getSignature() : "") : "");
                this.postAndDo(new ServerGatherPropertyEvent.ServerGatherAllPropertyEvent(player), event -> event.gather.forEach(tuple2 -> {
                    ((ServerGatherPropertyEvent.PropertyConsumer)tuple2._2()).accept((IProperty)tuple2._1(), this.tag);
                    this.propertiesName.add(((IProperty)tuple2._1()).getIdentifier());
                }));
                break;
            }
            case UPDATE: {
                this.postAndDo(new ServerGatherPropertyEvent(player, keys), event -> event.gather.forEach(tuple2 -> {
                    ((ServerGatherPropertyEvent.PropertyConsumer)tuple2._2()).accept((IProperty)tuple2._1(), this.tag);
                    this.propertiesName.add(((IProperty)tuple2._1()).getIdentifier());
                }));
            }
        }
    }

    public S2CTeamPlayerDataPacket(ServerPlayer player, Type type) {
        this(player, type, (HashSet<String>)HashSet.empty());
    }

    public S2CTeamPlayerDataPacket() {
    }

    public void write(FriendlyByteBuf to) {
        to.m_130079_(this.tag);
        to.m_236828_(this.propertiesName, FriendlyByteBuf::m_130070_);
    }

    public void read(FriendlyByteBuf friendlyByteBuf) {
        this.tag = friendlyByteBuf.m_130260_();
        this.propertiesName = friendlyByteBuf.m_236845_(FriendlyByteBuf::m_130277_);
    }

    public Class<S2CTeamPlayerDataPacket> getSelfClass() {
        return S2CTeamPlayerDataPacket.class;
    }

    public void handleClient() {
        UUID uuid = this.tag.m_128342_(ID_KEY);
        Type type1 = Type.valueOf(this.tag.m_128461_(TYPE_KEY));
        switch (type1) {
            case ADD: {
                if (ClientTeam.INSTANCE.hasPlayer(uuid)) {
                    return;
                }
                String name = this.tag.m_128461_(NAME_KEY);
                String skinVal = this.tag.m_128461_(SKIN_KEY);
                String skinSig = this.tag.m_128461_(SKIN_SIG_KEY);
                if (!skinVal.isEmpty()) {
                    GameProfile dummy = new GameProfile(UUID.randomUUID(), "");
                    dummy.getProperties().put((Object)"textures", (Object)new Property("textures", skinVal, skinSig));
                    Minecraft.m_91087_().m_91109_().m_118817_(dummy, (type, id, texture) -> {
                        if (type == MinecraftProfileTexture.Type.SKIN) {
                            this.postAndDo(new ClientReadPropertyEvent(this.tag, (List<String>)ImmutableList.copyOf(this.propertiesName)), event -> ClientTeam.INSTANCE.addPlayer(uuid, name, id, event.getResults()));
                        } else {
                            this.postAndDo(new ClientReadPropertyEvent(this.tag, (List<String>)ImmutableList.copyOf(this.propertiesName)), event -> ClientTeam.INSTANCE.addPlayer(uuid, name, DefaultPlayerSkin.m_118627_((UUID)uuid), event.getResults()));
                        }
                    }, false);
                    break;
                }
                this.postAndDo(new ClientReadPropertyEvent(this.tag, (List<String>)ImmutableList.copyOf(this.propertiesName)), event -> ClientTeam.INSTANCE.addPlayer(uuid, name, DefaultPlayerSkin.m_118627_((UUID)uuid), event.getResults()));
                break;
            }
            case UPDATE: {
                this.postAndDo(new ClientReadPropertyEvent(this.tag, (List<String>)ImmutableList.copyOf(this.propertiesName)), event -> ClientTeam.INSTANCE.updatePlayer(uuid, event.getResults()));
                break;
            }
            case REMOVE: {
                ClientTeam.INSTANCE.removePlayer(uuid);
            }
        }
    }

    private <T extends Event> void postAndDo(T event, Consumer<T> handle) {
        if (event instanceof ServerEvent) {
            handle.accept(AdvancedTeam.serverBus.post(event));
        } else if (event instanceof ClientEvent) {
            handle.accept(AdvancedTeam.clientBus.post(event));
        }
    }

    public static enum Type {
        ADD,
        UPDATE,
        REMOVE;

    }
}

