/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.network.client;

import com.clefal.nirvana_lib.network.newtoolchain.S2CModPacket;
import com.clefal.teams.client.core.ClientTeamData;
import com.clefal.teams.client.gui.screens.noteam.NoTeamScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class S2CTeamDataUpdatePacket
implements S2CModPacket<S2CTeamDataUpdatePacket> {
    private static final String TEAM_KEY = "teamName";
    private static final String TYPE_KEY = "type";
    CompoundTag tag = new CompoundTag();

    public S2CTeamDataUpdatePacket(Type type, String ... teams) {
        ListTag nbtList = new ListTag();
        for (String team : teams) {
            nbtList.add((Object)StringTag.m_129297_((String)team));
        }
        this.tag.m_128365_(TEAM_KEY, (Tag)nbtList);
        this.tag.m_128359_(TYPE_KEY, type.name());
    }

    public S2CTeamDataUpdatePacket() {
    }

    public void write(FriendlyByteBuf to) {
        to.m_130079_(this.tag);
    }

    public void read(FriendlyByteBuf friendlyByteBuf) {
        this.tag = friendlyByteBuf.m_130260_();
    }

    public Class<S2CTeamDataUpdatePacket> getSelfClass() {
        return S2CTeamDataUpdatePacket.class;
    }

    public void handleClient() {
        Type type = Type.valueOf(this.tag.m_128461_(TYPE_KEY));
        ListTag nbtList = this.tag.m_128437_(TEAM_KEY, 8);
        for (Tag elem : nbtList) {
            String team = elem.m_7916_();
            switch (type) {
                case ADD: {
                    ClientTeamData.INSTANCE.addTeam(team);
                    NoTeamScreen.refreshThis();
                    break;
                }
                case DISBAND: {
                    ClientTeamData.INSTANCE.removeTeam(team);
                    NoTeamScreen.refreshThis();
                    break;
                }
                case ONLINE: {
                    ClientTeamData.INSTANCE.teamOnline(team);
                    NoTeamScreen.refreshThis();
                    break;
                }
                case OFFLINE: {
                    ClientTeamData.INSTANCE.teamOffline(team);
                    NoTeamScreen.refreshThis();
                    break;
                }
                case CLEAR: {
                    ClientTeamData.INSTANCE.clear();
                }
            }
        }
    }

    public static enum Type {
        ADD,
        DISBAND,
        ONLINE,
        OFFLINE,
        CLEAR;

    }
}

