/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.modules.internal.propertyhandler;

import com.clefal.teams.config.ATClientConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import org.joml.Vector2f;

public record PositionContext(float oneEntryHeight, float iconAndTextInterval, float barWidth, float barHeight, Vector2f origin, Vector2f finalEffectPosition) {
    public static final int iconSize = 16;
    public static final int interval = 2;
    public static final int nameInterval = 10;

    public static PositionContext fromOrigin(Vector2f origin) {
        float oneEntryHeight = PositionContext.getRelativeHeight(0.03f);
        float iconAndTextInterval = PositionContext.getRelativeWidth(0.025f);
        float barWidth = PositionContext.getRelativeWidth(0.15f);
        float barHeight = PositionContext.getRelativeHeight(0.026f);
        return new PositionContext(oneEntryHeight, iconAndTextInterval, barWidth, barHeight, origin, new Vector2f(iconAndTextInterval + barWidth + 5.0f, barHeight));
    }

    public static float getRelativeWidth(float factor) {
        return (float)Minecraft.m_91087_().m_91268_().m_85445_() * factor;
    }

    public static float getRelativeHeight(float factor) {
        return (float)Minecraft.m_91087_().m_91268_().m_85446_() * factor;
    }

    public PoseStack setupEffectPosition(PoseStack poseStack) {
        this.setupNamePosition(poseStack);
        poseStack.m_252880_(this.finalEffectPosition().x, this.finalEffectPosition().y, 0.0f);
        return poseStack;
    }

    public PositionContext updateOrigin(Vector2f origin) {
        return PositionContext.fromOrigin(origin);
    }

    public PoseStack setupInitialPosition(PoseStack poseStack) {
        poseStack.m_166856_();
        float scale = ((Float)ATClientConfig.config.overlays.scale.get()).floatValue();
        poseStack.m_85841_(scale, scale, 1.0f);
        poseStack.m_252880_(this.origin.x, this.origin.y, 0.0f);
        return poseStack;
    }

    public PoseStack setupNamePosition(PoseStack poseStack) {
        this.setupInitialPosition(poseStack);
        poseStack.m_252880_((float)(this.getPlayerHeadIconSize() + 10), 0.0f, 0.0f);
        return poseStack;
    }

    public int getPlayerHeadIconSize() {
        return (int)(this.barWidth() / 3.0f);
    }
}

