/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.modules.internal.effect.handlers;

import com.clefal.nirvana_lib.relocated.io.vavr.Function1;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.SubscribeEvent;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.core.property.impl.PropertyRenderer;
import com.clefal.teams.client.core.property.renderer.RendererManager;
import com.clefal.teams.client.gui.util.VertexContainer;
import com.clefal.teams.event.client.ClientReadPropertyEvent;
import com.clefal.teams.event.client.ClientRegisterPropertyRendererEvent;
import com.clefal.teams.modules.internal.effect.handlers.VanillaPotionEffectProperty;
import com.clefal.teams.modules.internal.propertyhandler.IProperty;
import com.clefal.teams.modules.internal.propertyhandler.IPropertyClientHandler;
import com.clefal.teams.modules.internal.propertyhandler.PositionContext;
import com.clefal.teams.utils.GuiUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class VanillaPotionEffectPropertyClientHandler
implements IPropertyClientHandler {
    public static final VanillaPotionEffectPropertyClientHandler INSTANCE = new VanillaPotionEffectPropertyClientHandler();

    @Override
    @SubscribeEvent
    public void onReadProperty(ClientReadPropertyEvent event) {
        List<String> properties = event.properties;
        CompoundTag tag = event.tag;
        if (properties.contains("vanilla_potion_effect") && tag.m_128425_("vanilla_potion_effect", 9)) {
            ListTag listTag = tag.m_128437_("vanilla_potion_effect", 10);
            ArrayList<MobEffectInstance> mobEffectInstances = new ArrayList<MobEffectInstance>();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                MobEffectInstance mobEffectInstance = MobEffectInstance.m_19560_((CompoundTag)compoundTag);
                if (mobEffectInstance == null) continue;
                mobEffectInstances.add(mobEffectInstance);
            }
            event.addResult(new VanillaPotionEffectProperty((List<MobEffectInstance>)mobEffectInstances));
        }
    }

    @Override
    @SubscribeEvent
    public void onRegisterRenderer(ClientRegisterPropertyRendererEvent event) {
        event.register("vanilla_potion_effect", (Function1<IProperty, PropertyRenderer<? extends IProperty>>)Function1.of((Function1 & Serializable)potion -> new PropertyRenderer<VanillaPotionEffectProperty>((VanillaPotionEffectProperty)potion){

            @Override
            public void render(GuiGraphics gui, VertexContainer container, ClientTeam.Teammate teammate, PositionContext positionContext) {
                PoseStack pose = gui.m_280168_();
                pose.m_85836_();
                positionContext.setupEffectPosition(pose);
                int i = 0;
                int iconSize = 16;
                MobEffectTextureManager mobEffectTextureManager = Minecraft.m_91087_().m_91306_();
                for (MobEffectInstance mobEffectInstance : ((VanillaPotionEffectProperty)this.property).getMobEffectInstance()) {
                    MobEffect mobEffect = mobEffectInstance.m_19544_();
                    TextureAtlasSprite textureAtlasSprite = mobEffectTextureManager.m_118732_(mobEffect);
                    gui.m_280159_(i, 0, 0, iconSize, iconSize, textureAtlasSprite);
                    GuiUtils.renderDuration(gui, mobEffectInstance.m_19557_(), pose, i, iconSize);
                    i += iconSize + 2;
                }
                positionContext.finalEffectPosition().add((float)i, 0.0f);
                pose.m_85849_();
            }
        }));
    }

    @Override
    public void onRender(GuiGraphics gui, VertexContainer container, ClientTeam.Teammate teammate, PositionContext positionContext) {
        for (IProperty iProperty : teammate.getProperty("vanilla_potion_effect")) {
            RendererManager.getRenderer(iProperty).render(gui, container, teammate, positionContext);
        }
    }
}

