/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.mixin;

import com.clefal.nirvana_lib.relocated.io.vavr.collection.HashSet;
import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.event.server.ServerFreezePropertyUpdateEvent;
import com.clefal.teams.event.server.ServerPlayerTickJobEvent;
import com.clefal.teams.network.client.S2CSyncRenderMatPacket;
import com.clefal.teams.network.client.S2CTeamPlayerDataPacket;
import com.clefal.teams.server.ATServerTeam;
import com.clefal.teams.server.ATServerTeamData;
import com.clefal.teams.server.IHasTeam;
import com.clefal.teams.server.IPropertySender;
import com.clefal.teams.server.Invitation;
import com.clefal.teams.utils.ServerHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
implements IHasTeam,
IPropertySender {
    @Unique
    private final Map<String, Invitation> invitations = new ConcurrentHashMap<String, Invitation>();
    @Unique
    private final Set<String> advancedTeam$updateKey = new java.util.HashSet<String>(10);
    @Shadow
    @Final
    public ServerPlayerGameMode f_8941_;
    @Unique
    private ATServerTeam team;

    @Shadow
    public abstract ServerLevel m_284548_();

    @Override
    public boolean hasTeam() {
        return this.team != null;
    }

    @Override
    public ATServerTeam getTeam() {
        return this.team;
    }

    @Override
    public void setTeam(ATServerTeam team) {
        this.team = team;
    }

    @Override
    public boolean isTeammate(ServerPlayer other) {
        return this.team.equals((Object)((IHasTeam)other).getTeam());
    }

    @Override
    public void addInvitation(Invitation invitation) {
        ServerHelper.addInv(this.invitations, invitation, this.self());
    }

    @Override
    public void tickInvitations() {
        Map<String, Invitation> invitations = this.getInvitations();
        Iterator<Map.Entry<String, Invitation>> iterator = invitations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Invitation> next = iterator.next();
            if (!next.getValue().update()) continue;
            NetworkUtils.sendToClient((Object)new S2CSyncRenderMatPacket(next.getKey(), S2CSyncRenderMatPacket.Action.REMOVE, S2CSyncRenderMatPacket.Type.INVITATION), (ServerPlayer)this.self());
            iterator.remove();
        }
    }

    @Override
    public void clearInvitations() {
        this.invitations.forEach((x, y) -> y.markRemoval());
    }

    @Override
    public Map<String, Invitation> getInvitations() {
        return this.invitations;
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData"})
    private void writeCustomDataToNbt(CompoundTag nbt, CallbackInfo info) {
        if (this.team != null) {
            nbt.m_128359_("playerTeam", this.team.m_5758_());
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData"})
    private void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo info) {
        ServerPlayer serverPlayer = (ServerPlayer)this;
        if (this.team == null && nbt.m_128441_("playerTeam")) {
            this.team = ATServerTeamData.getOrMakeDefault(this.m_284548_().m_7654_()).getTeam(nbt.m_128461_("playerTeam"));
            if (this.team != null && !this.team.hasPlayer(serverPlayer)) {
                this.team = null;
            }
        }
    }

    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/server/level/ServerPlayer;getHealth()F", ordinal=1)}, method={"doTick"})
    private void UpdateHealthInfoForEveryone(CallbackInfo info) {
        this.addUpdate("health");
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tickJob(CallbackInfo ci) {
        AdvancedTeam.post(new ServerPlayerTickJobEvent(this.self()));
    }

    private ServerPlayer self() {
        return (ServerPlayer)this;
    }

    @Override
    public void addUpdate(String key) {
        this.advancedTeam$updateKey.add(key);
    }

    @Override
    public void clear() {
        this.advancedTeam$updateKey.clear();
    }

    @Override
    public void handleUpdate() {
        if (!this.advancedTeam$updateKey.isEmpty()) {
            HashSet<String> result = AdvancedTeam.post(new ServerFreezePropertyUpdateEvent(this.advancedTeam$updateKey)).getResult();
            if (this.team != null) {
                List players = this.team.getOnlinePlayers().asJava();
                S2CTeamPlayerDataPacket s2CTeamPlayerDataPacket = new S2CTeamPlayerDataPacket(this.self(), S2CTeamPlayerDataPacket.Type.UPDATE, result);
                NetworkUtils.sendToClients((Object)s2CTeamPlayerDataPacket, (Iterable)players);
            }
            this.clear();
        }
    }
}

