/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.compat.mine_and_slash.property;

import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.core.property.INumberTracking;
import com.clefal.teams.client.core.property.RenderableTrackedProperty;
import com.clefal.teams.client.core.property.impl.PropertyRenderer;
import com.clefal.teams.client.gui.util.FillBufferInfo;
import com.clefal.teams.client.gui.util.FillGradientBufferInfo;
import com.clefal.teams.client.gui.util.VertexContainer;
import com.clefal.teams.modules.internal.propertyhandler.PositionContext;
import com.google.common.collect.ImmutableMap;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MNSOtherResource
extends RenderableTrackedProperty<MNSOtherResource, Float> {
    public static Function<ResourceType, String> identifier = type1 -> "MNS" + type1;
    private static final Map<String, Integer> colorMap = ImmutableMap.of((Object)identifier.apply(ResourceType.blood), (Object)FastColor.ARGB32.m_13660_((int)190, (int)221, (int)16, (int)16), (Object)identifier.apply(ResourceType.mana), (Object)FastColor.ARGB32.m_13660_((int)190, (int)78, (int)161, (int)241), (Object)identifier.apply(ResourceType.energy), (Object)FastColor.ARGB32.m_13660_((int)190, (int)93, (int)236, (int)149));
    private final ResourceType type;
    private final ResourceLocation icon = AdvancedTeam.id("textures/gui/health.png");

    public MNSOtherResource(Float currentValue, Float maxValue, ResourceType type) {
        super(currentValue, maxValue);
        this.type = type;
    }

    public static MNSOtherResource fromNetworkString(String str) {
        String[] split = str.split(":");
        ResourceType type = ResourceType.valueOf((String)split[0]);
        String[] split1 = split[1].split("/");
        return new MNSOtherResource(Float.valueOf(Float.parseFloat(split1[0])), Float.valueOf(Float.parseFloat(split1[1])), type);
    }

    public String getNetworkString() {
        return this.type + ":" + this.getRenderString();
    }

    @Override
    public void update() {
        this.currentValue = ((Float)this.currentValue).floatValue() < ((Float)this.targetValue).floatValue() ? (Number)Float.valueOf(Math.min(((Float)this.currentValue).floatValue() + INumberTracking.lerpTo(((Float)this.currentValue).floatValue(), ((Float)this.targetValue).floatValue()), ((Float)this.maxValue).floatValue())) : (Number)this.targetValue;
    }

    @Override
    public int getTrackedBarColor() {
        return 0;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.icon;
    }

    @Override
    public String getRenderString() {
        return this.targetValue + "/" + this.maxValue;
    }

    @Override
    public String getIdentifier() {
        return identifier.apply(this.type);
    }

    @Override
    public MNSOtherResource mergeWith(MNSOtherResource old) {
        if (old == null) {
            return this;
        }
        old.targetValue = this.currentValue;
        old.maxValue = this.maxValue;
        return old;
    }

    public static class Renderer
    extends PropertyRenderer<MNSOtherResource> {
        public Renderer(@Nullable MNSOtherResource property) {
            super(property);
        }

        public static Renderer getRenderer(MNSOtherResource other) {
            return new Renderer(other);
        }

        @Override
        public void render(GuiGraphics gui, VertexContainer container, ClientTeam.Teammate teammate, PositionContext positionContext) {
            float width = positionContext.barWidth() / 2.0f;
            float height = positionContext.barHeight() / 3.0f;
            Matrix4f matrix4f = new Matrix4f((Matrix4fc)gui.m_280168_().m_85850_().m_252922_());
            float trackedBarLengthFactor = ((MNSOtherResource)this.property).getTrackedBarLengthFactor();
            container.putFill(FillBufferInfo.fillOf(0.0f, 0.0f, width * trackedBarLengthFactor, height, -0.01f, colorMap.get(((MNSOtherResource)this.property).getIdentifier()), matrix4f));
            container.putFill(FillGradientBufferInfo.getShadow(0.0f, 0.0f, width * trackedBarLengthFactor, height, matrix4f));
        }
    }
}

