/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.compat.mine_and_slash.property;

import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.core.property.Constants;
import com.clefal.teams.client.core.property.RenderableCompoundProperty;
import com.clefal.teams.client.gui.util.FillBufferInfo;
import com.clefal.teams.client.gui.util.FillGradientBufferInfo;
import com.clefal.teams.client.gui.util.TextureBufferInfo;
import com.clefal.teams.client.gui.util.VertexContainer;
import com.clefal.teams.compat.mine_and_slash.property.MNSHealth;
import com.clefal.teams.compat.mine_and_slash.property.MNSMagicShield;
import com.clefal.teams.modules.internal.propertyhandler.PositionContext;
import com.clefal.teams.server.ModComponents;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MNSHealthResource
extends RenderableCompoundProperty<MNSHealthResource> {
    public static final String KEY = "MNSHealthResource";
    private final int healthColor = FastColor.ARGB32.m_13660_((int)190, (int)80, (int)231, (int)39);
    private final int magicShieldColor = FastColor.ARGB32.m_13660_((int)190, (int)66, (int)241, (int)224);
    private MNSHealth health;
    private MNSMagicShield magicShield;

    public MNSHealthResource(@NotNull MNSHealth health, @NotNull MNSMagicShield magicShield) {
        super(new HashMap(Map.of(health.getIdentifier(), health, magicShield.getIdentifier(), magicShield)));
        this.health = health;
        this.magicShield = magicShield;
    }

    public boolean isInDanger() {
        return (((Float)this.health.currentValue).floatValue() + ((Float)this.magicShield.currentValue).floatValue()) / (((Float)this.health.maxValue).floatValue() + ((Float)this.magicShield.maxValue).floatValue()) < 0.2f;
    }

    @Override
    public void render(GuiGraphics gui, VertexContainer container, ClientTeam.Teammate teammate, PositionContext positionContext) {
        float max;
        float current = ((Float)this.health.currentValue).floatValue() + ((Float)this.magicShield.currentValue).floatValue();
        float healthResourceRatio = Math.max(0.0f, Math.min(1.0f, current / (max = ((Float)this.health.maxValue).floatValue() + ((Float)this.magicShield.maxValue).floatValue())));
        healthResourceRatio = healthResourceRatio > 0.99f ? 1.0f : healthResourceRatio;
        float WholeWidth = Constants.getRelativeWidth(Constants.barWidth);
        float currentBarLength = WholeWidth * healthResourceRatio;
        float healthFactor = Math.min(1.0f, ((Float)this.health.currentValue).floatValue() / current);
        PoseStack pose = gui.m_280168_();
        pose.m_252880_(0.0f, positionContext.oneEntryHeight(), 0.0f);
        Matrix4f matrix4f = new Matrix4f((Matrix4fc)gui.m_280168_().m_85850_().m_252922_());
        pose.m_85836_();
        int i = positionContext.getPlayerHeadIconSize() / 3;
        if (this.isInDanger()) {
            float randomFactor = Constants.random.nextFloat(-0.005f, 0.005f);
            container.putBliz(this.getResourceLocation(), TextureBufferInfo.of(PositionContext.getRelativeWidth(randomFactor * 2.0f), PositionContext.getRelativeHeight(randomFactor), i, i, 0.0f, 0.0f, 9, 9, 9, 9, matrix4f));
        } else {
            container.putBliz(this.getResourceLocation(), TextureBufferInfo.of(0.0f, 0.0f, i, i, 0.0f, 0.0f, 9, 9, 9, 9, matrix4f));
        }
        pose.m_252880_(positionContext.iconAndTextInterval(), 0.0f, 0.0f);
        Matrix4f matrix4f1 = new Matrix4f((Matrix4fc)gui.m_280168_().m_85850_().m_252922_());
        container.putFill(FillBufferInfo.fillOf(0.0f, 0.0f, currentBarLength * healthFactor, positionContext.barHeight(), 0.002f, this.health.getTrackedBarColor(), matrix4f1));
        container.putFill(FillBufferInfo.fillOf(currentBarLength * healthFactor, 0.0f, currentBarLength, positionContext.barHeight(), 0.002f, this.magicShieldColor, matrix4f1));
        container.putFill(FillGradientBufferInfo.getShadow(0.0f, 0.0f, currentBarLength, positionContext.barHeight(), matrix4f1));
        if (Screen.m_96638_()) {
            pose.m_252880_(0.0f, Constants.getRelativeHeight(0.005f), 10.0f);
            Minecraft.m_91087_().f_91062_.m_272077_((Component)ModComponents.literal(this.getRenderString()), 0.0f, 0.0f, ChatFormatting.WHITE.m_126665_().intValue(), false, new Matrix4f((Matrix4fc)pose.m_85850_().m_252922_()), (MultiBufferSource)gui.m_280091_(), Font.DisplayMode.NORMAL, FastColor.ARGB32.m_13660_((int)0, (int)255, (int)255, (int)255), 0xF000F0);
        }
        pose.m_85849_();
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return ((Float)this.health.maxValue).floatValue() >= ((Float)this.magicShield.maxValue).floatValue() ? this.health.getResourceLocation() : this.magicShield.getResourceLocation();
    }

    @Override
    public String getRenderString() {
        return ((Float)this.health.targetValue).intValue() + ((Float)this.magicShield.targetValue).intValue() + "/" + (((Float)this.health.maxValue).intValue() + ((Float)this.magicShield.maxValue).intValue());
    }

    @Override
    public String getIdentifier() {
        return KEY;
    }

    @Override
    public void update() {
        this.health.update();
        this.magicShield.update();
    }
}

