/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.compat.mine_and_slash;

import com.clefal.nirvana_lib.relocated.io.vavr.Function1;
import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.SubscribeEvent;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.core.property.Constants;
import com.clefal.teams.client.core.property.impl.PropertyRenderer;
import com.clefal.teams.client.core.property.renderer.RendererManager;
import com.clefal.teams.client.gui.util.VertexContainer;
import com.clefal.teams.compat.mine_and_slash.MineAndSlashCompatModule;
import com.clefal.teams.compat.mine_and_slash.property.MNSHealth;
import com.clefal.teams.compat.mine_and_slash.property.MNSHealthResource;
import com.clefal.teams.compat.mine_and_slash.property.MNSMagicShield;
import com.clefal.teams.compat.mine_and_slash.property.MNSOtherResource;
import com.clefal.teams.compat.mine_and_slash.property.MNSStatusEffect;
import com.clefal.teams.compat.mine_and_slash.property.MNSStatusEffectData;
import com.clefal.teams.event.client.ClientReadPropertyEvent;
import com.clefal.teams.event.client.ClientRegisterPropertyRendererEvent;
import com.clefal.teams.modules.internal.propertyhandler.IProperty;
import com.clefal.teams.modules.internal.propertyhandler.IPropertyClientHandler;
import com.clefal.teams.modules.internal.propertyhandler.PositionContext;
import com.clefal.teams.utils.GuiUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public class MNSPropertyClientHandler
implements IPropertyClientHandler {
    public static final MNSPropertyClientHandler INSTANCE = new MNSPropertyClientHandler();

    @Override
    @SubscribeEvent
    public void onReadProperty(ClientReadPropertyEvent event) {
        if (!MineAndSlashCompatModule.getClientConfig().showModProperty) {
            return;
        }
        List<String> properties = event.properties;
        CompoundTag tag = event.tag;
        if (properties.contains("MNSHealth") && tag.m_128441_("MNSHealth")) {
            MNSHealth mNSHealth = MNSHealth.fromString(tag.m_128461_("MNSHealth"));
            String ms = tag.m_128461_("MNSMagicShield");
            MNSMagicShield shield = ms.isEmpty() ? new MNSMagicShield(0.0f, 0.0f) : MNSMagicShield.fromString(ms);
            event.addResult(new MNSHealthResource(mNSHealth, shield));
        }
        for (ResourceType value : ResourceType.values()) {
            String identifier;
            if (value == ResourceType.health || value == ResourceType.magic_shield || !properties.contains(identifier = MNSOtherResource.identifier.apply(value)) || !tag.m_128441_(identifier)) continue;
            MNSOtherResource mnsOtherResource = MNSOtherResource.fromNetworkString(tag.m_128461_(identifier));
            event.addResult(mnsOtherResource);
        }
        if (properties.contains("MNSEffect") && tag.m_128425_("MNSEffect", 9)) {
            ListTag listTag = tag.m_128437_("MNSEffect", 10);
            ArrayList<MNSStatusEffectData> mnsStatusEffectData = new ArrayList<MNSStatusEffectData>();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag = listTag.m_128728_(i);
                mnsStatusEffectData.add(new MNSStatusEffectData(compoundTag.m_128461_("effect"), compoundTag.m_128451_("stack"), compoundTag.m_128451_("duration")));
            }
            event.addResult(new MNSStatusEffect((List<MNSStatusEffectData>)mnsStatusEffectData));
        }
    }

    @Override
    @SubscribeEvent
    public void onRegisterRenderer(ClientRegisterPropertyRendererEvent event) {
        for (ResourceType value : ResourceType.values()) {
            if (value == ResourceType.health || value == ResourceType.magic_shield) continue;
            event.register(MNSOtherResource.identifier.apply(value), (Function1<IProperty, PropertyRenderer<? extends IProperty>>)Function1.of((Function1 & Serializable)property -> MNSOtherResource.Renderer.getRenderer((MNSOtherResource)property)));
        }
    }

    @Override
    public void onRender(GuiGraphics gui, VertexContainer container, ClientTeam.Teammate teammate, PositionContext positionContext) {
        Option<IProperty> property = teammate.getProperty("MNSHealthResource");
        for (IProperty iProperty : property) {
            if (!(iProperty instanceof MNSHealthResource)) continue;
            MNSHealthResource healthResource = (MNSHealthResource)iProperty;
            healthResource.update();
            healthResource.render(gui, container, teammate, positionContext);
        }
        int count = 0;
        PoseStack pose = gui.m_280168_();
        pose.m_252880_(0.0f, positionContext.oneEntryHeight(), 0.0f);
        pose.m_252880_(positionContext.iconAndTextInterval(), 0.0f, 0.0f);
        for (ResourceType value : ResourceType.values()) {
            if (value == ResourceType.health || value == ResourceType.magic_shield) continue;
            String identifier = MNSOtherResource.identifier.apply(value);
            for (IProperty iProperty : teammate.getProperty(identifier)) {
                if (!(iProperty instanceof MNSOtherResource)) continue;
                MNSOtherResource otherResource = (MNSOtherResource)iProperty;
                if (((Float)otherResource.maxValue).equals(Float.valueOf(0.0f))) continue;
                RendererManager.getRenderer(otherResource).render(gui, container, teammate, positionContext);
                if (++count % 2 == 0) {
                    pose.m_252880_(-Constants.getRelativeWidth(Constants.barWidth) / 2.0f * 2.0f, Constants.getRelativeHeight(Constants.barHeight) / 3.0f, 0.0f);
                    continue;
                }
                pose.m_252880_(Constants.getRelativeWidth(Constants.barWidth) / 2.0f, 0.0f, 0.0f);
            }
        }
        for (IProperty iProperty : teammate.getProperty("MNSEffect")) {
            MNSStatusEffect effect = (MNSStatusEffect)iProperty;
            pose.m_85836_();
            positionContext.setupEffectPosition(pose);
            int i = 0;
            Iterator var8 = effect.effects.iterator();
            while (var8.hasNext()) {
                MNSStatusEffectData next = (MNSStatusEffectData)var8.next();
                if (next.duration() == 1) {
                    var8.remove();
                }
                ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get(next.effect());
                gui.m_280411_(eff.getTexture(), i, 0, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
                GuiUtils.renderDuration(gui, next.duration(), pose, i, 16);
                i += 18;
            }
            pose.m_85849_();
        }
    }
}

