/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.keybind;

import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.client.gui.hud.CompassOverlay;
import com.clefal.teams.client.gui.hud.StatusOverlay;
import com.clefal.teams.client.gui.toast.ToastApplied;
import com.clefal.teams.client.gui.toast.ToastInvited;
import com.clefal.teams.network.server.C2SAcceptApplicationPacket;
import com.clefal.teams.network.server.C2STeamJoinPacket;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;

public class TeamsKeys {
    public static final TeamsKey ACCEPT = new TeamsKey("key.teams.accept", 93, client -> {
        ToastComponent toastManager = client.m_91300_();
        ToastInvited invited = (ToastInvited)toastManager.m_94926_(ToastInvited.class, Toast.f_94894_);
        if (invited != null) {
            invited.respond();
            NetworkUtils.sendToServer((Object)new C2STeamJoinPacket(invited.team));
        } else {
            ToastApplied requested = (ToastApplied)toastManager.m_94926_(ToastApplied.class, Toast.f_94894_);
            if (requested != null) {
                requested.respond();
                NetworkUtils.sendToServer((Object)new C2SAcceptApplicationPacket(requested.id));
            }
        }
    });
    public static final TeamsKey REJECT = new TeamsKey("key.teams.reject", 91, client -> {
        ToastComponent toastManager = client.m_91300_();
        ToastInvited toast = (ToastInvited)toastManager.m_94926_(ToastInvited.class, Toast.f_94894_);
        if (toast != null) {
            toast.respond();
        } else {
            ToastApplied requested = (ToastApplied)toastManager.m_94926_(ToastApplied.class, Toast.f_94894_);
            if (requested != null) {
                requested.respond();
            }
        }
    });
    public static final TeamsKey TOGGLE_HUD = new TeamsKey("key.teams.toggle_hud", 66, client -> {
        StatusOverlay.INSTANCE.enabled = !StatusOverlay.INSTANCE.enabled;
        CompassOverlay.INSTANCE.enabled = !CompassOverlay.INSTANCE.enabled;
    });
    static final TeamsKey[] KEYS = new TeamsKey[]{ACCEPT, REJECT, TOGGLE_HUD};

    public static void registerAllKey(Consumer<KeyMapping[]> handle) {
        handle.accept((KeyMapping[])Arrays.stream(KEYS).map(x -> x.keyBinding).toArray(KeyMapping[]::new));
    }

    public static void consumerKeys() {
        for (TeamsKey key : KEYS) {
            if (!key.keyBinding.m_90859_()) continue;
            key.onPress.execute(Minecraft.m_91087_());
        }
    }

    public static class TeamsKey {
        final KeyMapping keyBinding;
        final OnPress onPress;

        private TeamsKey(String keyName, int keyBind, OnPress action) {
            this.keyBinding = new KeyMapping(keyName, InputConstants.Type.KEYSYM, keyBind, "key.category.teams");
            this.onPress = action;
        }

        public void register(Consumer<KeyMapping> handle) {
            handle.accept(this.keyBinding);
        }

        public String getLocalizedName() {
            return this.keyBinding.m_90863_().getString();
        }

        @FunctionalInterface
        public static interface OnPress {
            public void execute(Minecraft var1);
        }
    }
}

