/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.gui.screens.request;

import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.core.ClientRenderPersistentData;
import com.clefal.teams.client.gui.components.ATEntryList;
import com.clefal.teams.client.gui.components.ATEntryListTemplate;
import com.clefal.teams.client.gui.components.ComponentButton;
import com.clefal.teams.client.gui.screens.TeamsScreen;
import com.clefal.teams.client.gui.util.PlayerWithSkin;
import com.clefal.teams.network.server.C2STeamJoinPacket;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ApplicationsList
extends ATEntryListTemplate {
    public boolean updated = false;
    Function<Component, Integer> getWidth = component -> Minecraft.m_91087_().f_91062_.m_92895_(component.getString());
    ResourceLocation pending = AdvancedTeam.id("pending");
    Minecraft client = Minecraft.m_91087_();
    Font font;
    int textHeight;

    public ApplicationsList(TeamsScreen screen) {
        super(screen);
        this.font = this.client.f_91062_;
        Objects.requireNonNull(this.font);
        this.textHeight = 9;
        for (String app : ClientRenderPersistentData.getInstance().applications) {
            this.m_7085_(new ApplicationEntry(app, this.pending));
        }
    }

    public void updateList(List<PlayerWithSkin> players) {
        if (this.updated) {
            AdvancedTeam.LOGGER.warn("already update the application screen!");
        }
        List<ResourceLocation> resourceLocations = players.stream().map(PlayerWithSkin::getSkin).toList();
        this.m_93516_();
        if (resourceLocations.isEmpty()) {
            this.updated = true;
            return;
        }
        for (int i = 0; i < players.size(); ++i) {
            this.m_7085_(new ApplicationEntry(players.get(i).name(), resourceLocations.get(i)));
        }
        this.updated = true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int height = this.client.m_91268_().m_85446_() / 2;
        int width = this.client.m_91268_().m_85445_() / 2;
        if (!this.updated) {
            guiGraphics.m_280614_(this.font, (Component)Component.m_237115_((String)"teams.menu.invite.need_update"), (this.f_93388_ - this.getWidth.apply((Component)Component.m_237115_((String)"teams.menu.invite.need_update"))) / 2, height - this.textHeight / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
        } else if (this.m_5773_() == 0) {
            guiGraphics.m_280614_(this.font, (Component)Component.m_237115_((String)"teams.menu.apply.no_available_application"), (this.f_93388_ - this.getWidth.apply((Component)Component.m_237115_((String)"teams.menu.apply.no_available_application"))) / 2, height - this.textHeight / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
        }
    }

    public class ApplicationEntry
    extends ATEntryList.ATEntry {
        String name;
        ResourceLocation skin;
        Button accept;
        Button reject;

        public ApplicationEntry(String name, ResourceLocation skin) {
            this.name = name;
            this.skin = skin;
            this.accept = ComponentButton.builder((Component)Component.m_237115_((String)"teams.menu.invitation.accept"), button -> {
                if (ClientRenderPersistentData.getInstance().applications.contains(name)) {
                    NetworkUtils.sendToServer((Object)new C2STeamJoinPacket(name));
                    ClientRenderPersistentData.getInstance().applications.remove(name);
                } else {
                    Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"teams.menu.application_expired"));
                    ApplicationsList.this.m_93502_(this);
                }
            }, (Component)Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN)).size(8, 8).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"teams.menu.invitation.accept"))).build();
            this.reject = ComponentButton.builder((Component)Component.m_237115_((String)"teams.menu.invitation.reject"), button -> ClientRenderPersistentData.getInstance().applications.remove(name), (Component)Component.m_237113_((String)"\u00d7").m_130940_(ChatFormatting.RED)).size(8, 8).tooltip(Tooltip.m_257550_((Component)Component.m_237115_((String)"teams.menu.invitation.reject"))).build();
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.accept.m_6375_(mouseX, mouseY, button) || this.reject.m_6375_(mouseX, mouseY, button);
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            guiGraphics.m_280056_(font, this.name, left + 8, top + 12 - 9 / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
            if (hovering) {
                this.accept.f_93623_ = true;
                this.reject.f_93623_ = true;
                this.accept.m_264152_(left + width - 48, top + 8);
                this.reject.m_264152_(left + width - 24, top + 8);
                this.accept.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
                this.reject.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            } else {
                this.accept.f_93623_ = false;
                this.reject.f_93623_ = false;
            }
        }
    }
}

