/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.gui.screens.invite;

import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.gui.components.ATEntryList;
import com.clefal.teams.client.gui.components.ATEntryListTemplate;
import com.clefal.teams.client.gui.screens.TeamsScreen;
import com.clefal.teams.client.gui.util.PlayerWithSkin;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class AvailablePlayersList
extends ATEntryListTemplate {
    public boolean updated = false;
    Function<Component, Integer> getWidth = component -> Minecraft.m_91087_().f_91062_.m_92895_(component.getString());
    Minecraft client = Minecraft.m_91087_();
    Font font;
    int textHeight;

    public AvailablePlayersList(TeamsScreen screen, List<String> players) {
        super(screen);
        this.font = this.client.f_91062_;
        Objects.requireNonNull(this.font);
        this.textHeight = 9;
        for (String player : players) {
            this.m_7085_(new PlayerEntry(player, DefaultPlayerSkin.m_118627_((UUID)Minecraft.m_91087_().f_91074_.m_20148_())));
        }
    }

    public List<String> getAllSelection() {
        return this.m_6702_().stream().filter(x -> ((PlayerEntry)x).selected.m_93840_()).map(x -> ((PlayerEntry)x).name).toList();
    }

    public void updateList(List<PlayerWithSkin> players) {
        if (this.updated) {
            AdvancedTeam.LOGGER.warn("already update the invite screen!");
        }
        List<ResourceLocation> resourceLocations = players.stream().map(PlayerWithSkin::getSkin).toList();
        this.m_93516_();
        if (resourceLocations.isEmpty()) {
            this.updated = true;
            return;
        }
        for (int i = 0; i < players.size(); ++i) {
            this.m_7085_(new PlayerEntry(players.get(i).name(), resourceLocations.get(i)));
        }
        this.updated = true;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int height = this.client.m_91268_().m_85446_() / 2;
        int width = this.client.m_91268_().m_85445_() / 2;
        if (!this.updated) {
            guiGraphics.m_280614_(this.font, (Component)Component.m_237115_((String)"teams.menu.invite.need_update"), (this.f_93388_ - this.getWidth.apply((Component)Component.m_237115_((String)"teams.menu.invite.need_update"))) / 2, height - this.textHeight / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
        } else if (this.m_5773_() == 0) {
            guiGraphics.m_280614_(this.font, (Component)Component.m_237115_((String)"teams.menu.invite.no_available_players"), (this.f_93388_ - this.getWidth.apply((Component)Component.m_237115_((String)"teams.menu.invite.no_available_players"))) / 2, height - this.textHeight / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
        }
    }

    public class PlayerEntry
    extends ATEntryList.ATEntry {
        String name;
        ResourceLocation skin;
        Checkbox selected;

        public PlayerEntry(String name, ResourceLocation skin) {
            this.name = name;
            this.skin = skin;
            this.selected = new Checkbox(0, 0, 20, 20, (Component)Component.m_237113_((String)""), false, false);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.selected.m_7435_(Minecraft.m_91087_().m_91106_());
            this.selected.m_5691_();
            return true;
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            float scale = 0.5f;
            this.selected.m_252865_((int)((float)(left + width - 24 - 2) * (1.0f / scale)));
            this.selected.m_253211_((int)((float)(top + 8 - 2) * (1.0f / scale)));
            PoseStack pose = guiGraphics.m_280168_();
            pose.m_85836_();
            pose.m_85841_(scale, scale, 1.0f);
            this.selected.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            if (this.skin != null) {
                PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)this.skin, (int)((int)((float)(left + 4) / scale)), (int)((int)((float)(top + 4) / scale)), (int)32);
            }
            pose.m_85849_();
            this.selected.m_93692_(hovering);
            Font font = Minecraft.m_91087_().f_91062_;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            guiGraphics.m_280056_(font, this.name, left + 24, top + 12 - 9 / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
        }
    }
}

