/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.gui.screens.hasteam;

import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.gui.components.ATEntryList;
import com.clefal.teams.client.gui.components.ATEntryListTemplate;
import com.clefal.teams.client.gui.screens.TeamsScreen;
import com.clefal.teams.network.server.C2SPromotePacket;
import com.clefal.teams.network.server.C2STeamKickPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TeammateEntryList
extends ATEntryListTemplate {
    public TeammateEntryList(TeamsScreen screen) {
        super(screen);
        int index = 0;
        for (ClientTeam.Teammate teammate : ClientTeam.INSTANCE.getTeammates()) {
            boolean local = this.f_93386_.f_91074_.m_20148_().equals(teammate.id);
            TeammateEntry entry = new TeammateEntry(teammate, local, index);
            this.m_7085_(entry);
            ++index;
        }
        this.m_93488_(false);
        this.m_93437_(this.f_93388_, this.f_93389_, this.f_93390_, screen.getY() + 166 - 32);
    }

    protected class TeammateEntry
    extends ATEntryList.ATEntry {
        private static final ResourceLocation TEXTURE = AdvancedTeam.id("textures/gui/screen_background.png");
        private final ResourceLocation FLAG = AdvancedTeam.id("textures/gui/flags.png");
        private final Minecraft client = Minecraft.m_91087_();
        private final ClientTeam.Teammate teammate;
        private final ImageButton kickButton;
        private final ImageButton promoteButton;
        private final boolean isLocal;

        public TeammateEntry(ClientTeam.Teammate teammate, boolean local, int index) {
            this.teammate = teammate;
            int rowRight = TeammateEntryList.this.m_93520_();
            int rowTop = TeammateEntryList.this.m_7610_(index);
            ImageButton kickButton = new ImageButton(rowRight - 24, rowTop + 8, 8, 8, 16, 190, TEXTURE, button -> {
                NetworkUtils.sendToServer((Object)new C2STeamKickPacket(ClientTeam.INSTANCE.getName(), teammate.id));
                ClientTeam.INSTANCE.removePlayer(teammate.id);
            });
            kickButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"teams.button.kick")));
            this.kickButton = kickButton;
            this.kickButton.f_93623_ = false;
            ImageButton promoteButton = new ImageButton(rowRight - 48, rowTop + 8, 8, 8, 0, 0, 64, this.FLAG, 64, 128, button -> NetworkUtils.sendToServer((Object)new C2SPromotePacket(teammate.id))){

                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                    int i = 0;
                    if (!this.m_142518_()) {
                        i += 64;
                    } else if (this.m_198029_()) {
                        i += 32;
                    }
                    RenderSystem.enableDepthTest();
                    RenderSystem.enableBlend();
                    guiGraphics.m_280411_(TeammateEntry.this.FLAG, this.m_252754_(), this.m_252907_(), 8, 8, 0.0f, (float)i, 32, 32, 32, 64);
                }
            };
            promoteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"teams.button.promote")));
            this.promoteButton = promoteButton;
            this.promoteButton.f_93623_ = false;
            this.isLocal = local;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            return this.kickButton.m_6375_(mouseX, mouseY, button) || this.promoteButton.m_6375_(mouseX, mouseY, button);
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            float scale = 0.5f;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
            PlayerFaceRenderer.m_280354_((GuiGraphics)guiGraphics, (ResourceLocation)this.teammate.skin, (int)((int)((float)(left + 4) / scale)), (int)((int)((float)(top + 4) / scale)), (int)32);
            guiGraphics.m_280168_().m_85849_();
            Font font = this.client.f_91062_;
            String string = this.teammate.name;
            Objects.requireNonNull(this.client.f_91062_);
            guiGraphics.m_280056_(font, string, left + 24, top + 12 - 9 / 2, ChatFormatting.BLACK.m_126665_().intValue(), false);
            if (ClientTeam.INSTANCE.hasPermissions() && hovering) {
                if (this.isLocal) {
                    if (AdvancedTeam.IN_DEV) {
                        this.wakeButtons(guiGraphics, top, left, width, mouseX, mouseY, partialTick);
                    }
                } else {
                    this.wakeButtons(guiGraphics, top, left, width, mouseX, mouseY, partialTick);
                }
            } else {
                this.kickButton.f_93623_ = false;
                this.promoteButton.f_93623_ = false;
            }
        }

        private void wakeButtons(GuiGraphics guiGraphics, int top, int left, int width, int mouseX, int mouseY, float partialTick) {
            this.kickButton.f_93623_ = true;
            this.promoteButton.f_93623_ = true;
            this.kickButton.m_252865_(left + width - 24);
            this.kickButton.m_253211_(top + 8);
            this.promoteButton.m_252865_(left + width - 48);
            this.promoteButton.m_253211_(top + 8);
            this.kickButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
            this.promoteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        @Generated
        public ImageButton getKickButton() {
            return this.kickButton;
        }
    }
}

