/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.gui.screens.hasteam;

import com.clefal.nirvana_lib.relocated.io.vavr.collection.List;
import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.PlaceUtils;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.core.ClientTeamData;
import com.clefal.teams.client.gui.components.ATCheckBox;
import com.clefal.teams.client.gui.screens.ITeamMenu;
import com.clefal.teams.client.gui.screens.TeamsScreen;
import com.clefal.teams.client.gui.screens.hasteam.HasTeamMenu;
import com.clefal.teams.client.gui.screens.hasteam.HasTeamMenuTab;
import com.clefal.teams.client.gui.screens.hasteam.TeammateEntryList;
import com.clefal.teams.client.gui.screens.invite.TeamsInvitePlayerScreen;
import com.clefal.teams.client.gui.screens.noteam.NoTeamScreen;
import com.clefal.teams.client.gui.screens.request.TeamApplicationScreen;
import com.clefal.teams.client.gui.toast.ToastConfigSave;
import com.clefal.teams.network.server.C2STeamLeavePacket;
import com.clefal.teams.network.server.config.C2STeamConfigSavePacket;
import com.clefal.teams.server.ModComponents;
import com.mojang.blaze3d.vertex.PoseStack;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class HasTeamScreen
extends TeamsScreen {
    private static final ResourceLocation TEXTURE = AdvancedTeam.id("textures/gui/screen_background.png");
    private HasTeamMenu currentMenu;

    public HasTeamScreen(Screen parent) {
        super(parent, ModComponents.TEAMS_MENU_TITLE);
    }

    public void changeMenu(HasTeamMenu menu) {
        if (this.currentMenu != null) {
            this.currentMenu.releaseAll();
        }
        this.currentMenu = menu;
        this.currentMenu.registerAll();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        List menus = List.of((Object)new TeammateMenu(this));
        if (ClientTeam.INSTANCE.hasPermissions() || AdvancedTeam.IN_DEV) {
            menus = menus.prepend((Object)new TeamConfigMenu(this));
        }
        menus = menus.reverse();
        menus.forEach(ITeamMenu::init);
        int YCursor = this.y + 3;
        for (HasTeamMenuTab hasTeamMenuTab : menus.map(HasTeamMenu::getTab)) {
            this.m_142416_((GuiEventListener)hasTeamMenuTab);
            hasTeamMenuTab.m_264152_(this.x - hasTeamMenuTab.m_5711_() + 3, YCursor);
            YCursor += (int)((float)hasTeamMenuTab.m_93694_() * 1.5f);
        }
        this.changeMenu((HasTeamMenu)menus.head());
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.currentMenu.render(graphics, mouseX, mouseY, delta);
    }

    @Override
    protected int getWidth() {
        return 256;
    }

    @Override
    protected int getHeight() {
        return 166;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return TEXTURE;
    }

    @Override
    public void refresh() {
        if (!ClientTeam.INSTANCE.isInTeam()) {
            this.f_96541_.m_91152_(this.parent);
        } else {
            this.f_96541_.m_91152_((Screen)new HasTeamScreen(this.parent));
        }
    }

    @Generated
    public HasTeamMenu getCurrentMenu() {
        return this.currentMenu;
    }

    public static class TeammateMenu
    extends HasTeamMenu {
        private static final ResourceLocation ICON = AdvancedTeam.id("textures/gui/teammate.png");
        private TeammateEntryList entryList;
        private Button leaveTeamButton;
        private Button inviteButton;
        private Button checkRequest;

        public TeammateMenu(HasTeamScreen screen) {
            super(screen);
        }

        @Override
        public void registerAll() {
            this.screen.m_142416_((GuiEventListener)this.entryList);
            this.screen.m_142416_((GuiEventListener)this.leaveTeamButton);
            if (ClientTeam.INSTANCE.canInvite()) {
                this.screen.m_142416_((GuiEventListener)this.inviteButton);
                this.screen.m_142416_((GuiEventListener)this.checkRequest);
            }
        }

        @Override
        public void releaseAll() {
            this.screen.m_169411_((GuiEventListener)this.entryList);
            this.screen.m_169411_((GuiEventListener)this.leaveTeamButton);
            this.screen.m_169411_((GuiEventListener)this.inviteButton);
            this.screen.m_169411_((GuiEventListener)this.checkRequest);
        }

        @Override
        public HasTeamMenuTab getTab() {
            return new HasTeamMenuTab((Component)Component.m_237115_((String)"teams.menu.tab.teammates"), this.screen, ICON){

                public void m_5691_() {
                    TeammateMenu teammateMenu = new TeammateMenu(this.screen);
                    teammateMenu.init();
                    this.screen.changeMenu(teammateMenu);
                }

                @Override
                public boolean isInItsMenu() {
                    return this.screen.currentMenu instanceof TeammateMenu;
                }

                @Override
                public void renderIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                    PoseStack pose = guiGraphics.m_280168_();
                    pose.m_85836_();
                    guiGraphics.m_280411_(ICON, this.m_252754_() + 8, this.m_252907_() + 2, 13, 13, 0.0f, 0.0f, 64, 64, 64, 64);
                    pose.m_85849_();
                }
            };
        }

        @Override
        public void init() {
            this.entryList = new TeammateEntryList(this.screen);
            Minecraft minecraft = Minecraft.m_91087_();
            this.leaveTeamButton = Button.m_253074_((Component)ModComponents.LEAVE_TEXT, button -> {
                NetworkUtils.sendToServer((Object)new C2STeamLeavePacket());
                minecraft.m_91152_((Screen)new NoTeamScreen(null));
            }).m_252987_(this.screen.f_96543_ / 2 - 125, this.screen.y + 166 - 30, 80, 20).m_253136_();
            this.inviteButton = Button.m_253074_((Component)ModComponents.INVITE_TEXT, button -> minecraft.m_91152_((Screen)new TeamsInvitePlayerScreen(this.screen))).m_252987_(this.screen.f_96543_ / 2 - 40, this.screen.y + 166 - 30, 80, 20).m_253136_();
            this.checkRequest = Button.m_253074_((Component)Component.m_237115_((String)"teams.menu.teammates.check_request"), button -> minecraft.m_91152_((Screen)new TeamApplicationScreen(this.screen))).m_252987_(this.screen.f_96543_ / 2 + 45, this.screen.y + 166 - 30, 80, 20).m_253136_();
            if (ClientTeam.INSTANCE.canInvite()) {
                PlaceUtils.placeThreeButton(this.screen, this.leaveTeamButton, this.inviteButton, this.checkRequest);
            } else {
                PlaceUtils.placeOneButton(this.screen, this.leaveTeamButton);
            }
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        }
    }

    public static class TeamConfigMenu
    extends HasTeamMenu {
        private static final ResourceLocation ICON = AdvancedTeam.id("textures/gui/cogs.png");
        private Button saveButton;
        private ATCheckBox isPublic;
        private ATCheckBox everyoneInvite;

        public TeamConfigMenu(HasTeamScreen screen) {
            super(screen);
        }

        @Override
        public void registerAll() {
            this.screen.m_142416_((GuiEventListener)this.saveButton);
            this.screen.m_142416_((GuiEventListener)this.isPublic);
            this.screen.m_142416_((GuiEventListener)this.everyoneInvite);
        }

        @Override
        public void releaseAll() {
            this.screen.m_169411_((GuiEventListener)this.saveButton);
            this.screen.m_169411_((GuiEventListener)this.isPublic);
            this.screen.m_169411_((GuiEventListener)this.everyoneInvite);
        }

        @Override
        public HasTeamMenuTab getTab() {
            return new HasTeamMenuTab((Component)Component.m_237115_((String)"teams.menu.tab.team_config"), this.screen, ICON){

                public void m_5691_() {
                    TeamConfigMenu teamConfigMenu1 = new TeamConfigMenu(this.screen);
                    teamConfigMenu1.init();
                    this.screen.changeMenu(teamConfigMenu1);
                }

                @Override
                public boolean isInItsMenu() {
                    return this.screen.currentMenu instanceof TeamConfigMenu;
                }

                @Override
                public void renderIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                    PoseStack pose = guiGraphics.m_280168_();
                    pose.m_85836_();
                    pose.m_252880_(5.0f, 0.0f, 0.0f);
                    guiGraphics.m_280411_(ICON, this.m_252754_() + 3, this.m_252907_() + 3, 13, 13, 0.0f, 0.0f, 50, 50, 50, 50);
                    pose.m_85849_();
                }
            };
        }

        @Override
        public void init() {
            this.isPublic = new ATCheckBox(this.screen.x + 20, this.screen.y + 10, 10, 10, (Component)Component.m_237115_((String)"teams.menu.team_config.is_public"), ClientTeamData.INSTANCE.isPublicTeam(ClientTeam.INSTANCE.getName()));
            this.everyoneInvite = new ATCheckBox(this.screen.x + 20, this.screen.y + 30, 10, 10, (Component)Component.m_237115_((String)"teams.menu.team_config.everyone_can_invite"), ClientTeam.INSTANCE.allowEveryoneInvite());
            this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"teams.menu.team_config.save"), button -> {
                NetworkUtils.sendToServer((Object)new C2STeamConfigSavePacket(this.isPublic.selected(), this.everyoneInvite.selected()));
                new TeammateMenu(this.screen).getTab().m_5691_();
                Minecraft.m_91087_().m_91300_().m_94922_((Toast)new ToastConfigSave(ClientTeam.INSTANCE.getName()));
            }).m_253136_();
            PlaceUtils.placeOneButton(this.screen, this.saveButton);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        }
    }
}

