/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.gui.hud;

import com.clefal.nirvana_lib.utils.DevUtils;
import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.gui.util.VertexContainer;
import com.clefal.teams.config.ATClientConfig;
import com.clefal.teams.modules.internal.HandlerManager;
import com.clefal.teams.modules.internal.propertyhandler.IPropertyClientHandler;
import com.clefal.teams.modules.internal.propertyhandler.PositionContext;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.joml.Vector2f;

public class StatusOverlay {
    public static final StatusOverlay INSTANCE = new StatusOverlay();
    private final ResourceLocation FLAG = AdvancedTeam.id("textures/gui/flags.png");
    public boolean enabled = true;
    private final Minecraft client = Minecraft.m_91087_();
    private final List<IPropertyClientHandler> handlers = HandlerManager.INSTANCE.getClientHandlers();
    private final VertexContainer container = new VertexContainer();

    public void render(GuiGraphics graphics) {
        if (!ATClientConfig.config.overlays.enableStatusOverlay || !this.enabled) {
            return;
        }
        List<ClientTeam.Teammate> teammates = ClientTeam.INSTANCE.getTeammates();
        int shown = 0;
        RenderSystem.enableDepthTest();
        graphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        PositionContext positionContext = PositionContext.fromOrigin(new Vector2f((float)ATClientConfig.config.overlays.originX, (float)ATClientConfig.config.overlays.originY));
        for (int i = 0; i < teammates.size() && shown < ATClientConfig.config.overlays.maxEntryAmount; ++i) {
            ClientTeam.Teammate teammate = teammates.get(i);
            if (!DevUtils.isInDev() && this.client.f_91074_.m_20148_().equals(teammate.id)) continue;
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            positionContext.setupInitialPosition(pose);
            PlayerFaceRenderer.m_280354_((GuiGraphics)graphics, (ResourceLocation)teammate.skin, (int)0, (int)0, (int)positionContext.getPlayerHeadIconSize());
            if (ClientTeam.INSTANCE.isLeader(teammate.id)) {
                pose.m_85836_();
                int size = 14;
                pose.m_252880_((float)(positionContext.getPlayerHeadIconSize() - size), -3.0f, 0.0f);
                graphics.m_280411_(this.FLAG, 0, 0, size, size, 0.0f, 0.0f, 32, 32, 32, 64);
                pose.m_85849_();
            }
            positionContext.setupNamePosition(pose);
            graphics.m_280430_(this.client.f_91062_, (Component)Component.m_237113_((String)teammate.name), 0, 0, ChatFormatting.WHITE.m_126665_().intValue());
            for (IPropertyClientHandler handler : this.handlers) {
                handler.onRender(graphics, this.container, teammate, positionContext);
            }
            positionContext = positionContext.updateOrigin(positionContext.origin().add(0.0f, (float)(positionContext.getPlayerHeadIconSize() + ATClientConfig.config.overlays.entryInterval)));
            pose.m_85849_();
            ++shown;
        }
        this.container.draw((MultiBufferSource)graphics.m_280091_());
        graphics.m_280509_(0, 0, 1, 1, FastColor.ARGB32.m_13660_((int)0, (int)0, (int)0, (int)0));
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85849_();
    }
}

