/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.gui.components;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.suggestion.Suggestion;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class ATSuggestionsList {
    private final Rect2i rect;
    private final String originalContents;
    private final List<Suggestion> suggestionList;
    private int offset;
    private int current;
    private Vec2 lastMouse;
    private boolean tabCycles;
    private int lastNarratedEntry;
    private boolean anchorToBottom = true;
    final int suggestionLineLimit;
    EditBox input;
    int fillColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    Font font;
    Minecraft minecraft;
    boolean shouldHide;
    int lineStartOffset;
    boolean keepSuggestions;

    ATSuggestionsList(int xPos, int yPos, int width, List<Suggestion> suggestionList, boolean narrateFirstSuggestion, int suggestionLineLimit, EditBox input) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.minecraft = Minecraft.m_91087_();
        this.shouldHide = false;
        this.lineStartOffset = 2;
        this.lastMouse = Vec2.f_82462_;
        this.input = input;
        this.suggestionLineLimit = suggestionLineLimit;
        int i = xPos - 1;
        int j = this.anchorToBottom ? yPos - 3 - Math.min(suggestionList.size(), this.suggestionLineLimit) * 12 : yPos;
        this.rect = new Rect2i(i, j, width + 1, Math.min(suggestionList.size(), this.suggestionLineLimit) * 12);
        this.originalContents = this.input.m_94155_();
        this.lastNarratedEntry = narrateFirstSuggestion ? -1 : 0;
        this.suggestionList = suggestionList;
        this.select(0);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Message message;
        boolean bl4;
        int i = Math.min(this.suggestionList.size(), this.suggestionLineLimit);
        int j = -5592406;
        boolean bl = this.offset > 0;
        boolean bl2 = this.suggestionList.size() > this.offset + i;
        boolean bl3 = bl || bl2;
        boolean bl5 = bl4 = this.lastMouse.f_82470_ != (float)mouseX || this.lastMouse.f_82471_ != (float)mouseY;
        if (bl4) {
            this.lastMouse = new Vec2((float)mouseX, (float)mouseY);
        }
        if (bl3) {
            int k;
            guiGraphics.m_280509_(this.rect.m_110085_(), this.rect.m_110086_() - 1, this.rect.m_110085_() + this.rect.m_110090_(), this.rect.m_110086_(), this.fillColor);
            guiGraphics.m_280509_(this.rect.m_110085_(), this.rect.m_110086_() + this.rect.m_110091_(), this.rect.m_110085_() + this.rect.m_110090_(), this.rect.m_110086_() + this.rect.m_110091_() + 1, this.fillColor);
            if (bl) {
                for (k = 0; k < this.rect.m_110090_(); ++k) {
                    if (k % 2 != 0) continue;
                    guiGraphics.m_280509_(this.rect.m_110085_() + k, this.rect.m_110086_() - 1, this.rect.m_110085_() + k + 1, this.rect.m_110086_(), -1);
                }
            }
            if (bl2) {
                for (k = 0; k < this.rect.m_110090_(); ++k) {
                    if (k % 2 != 0) continue;
                    guiGraphics.m_280509_(this.rect.m_110085_() + k, this.rect.m_110086_() + this.rect.m_110091_(), this.rect.m_110085_() + k + 1, this.rect.m_110086_() + this.rect.m_110091_() + 1, -1);
                }
            }
        }
        boolean bl52 = false;
        for (int l = 0; l < i; ++l) {
            Suggestion suggestion = this.suggestionList.get(l + this.offset);
            guiGraphics.m_280509_(this.rect.m_110085_(), this.rect.m_110086_() + 12 * l, this.rect.m_110085_() + this.rect.m_110090_(), this.rect.m_110086_() + 12 * l + 12, this.fillColor);
            if (mouseX > this.rect.m_110085_() && mouseX < this.rect.m_110085_() + this.rect.m_110090_() && mouseY > this.rect.m_110086_() + 12 * l && mouseY < this.rect.m_110086_() + 12 * l + 12) {
                if (bl4) {
                    this.select(l + this.offset);
                }
                bl52 = true;
            }
            guiGraphics.m_280488_(this.font, suggestion.getText(), this.rect.m_110085_() + 1, this.rect.m_110086_() + 2 + 12 * l, l + this.offset == this.current ? -256 : -5592406);
        }
        if (bl52 && (message = this.suggestionList.get(this.current).getTooltip()) != null) {
            guiGraphics.m_280557_(this.font, ComponentUtils.m_130729_((Message)message), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.rect.m_110087_(mouseX, mouseY)) {
            return false;
        }
        int i = (mouseY - this.rect.m_110086_()) / 12 + this.offset;
        if (i >= 0 && i < this.suggestionList.size()) {
            this.select(i);
            this.useSuggestion();
        }
        return true;
    }

    public boolean mouseScrolled(double delta) {
        int j;
        int i = (int)(this.minecraft.f_91067_.m_91589_() * (double)this.minecraft.m_91268_().m_85445_() / (double)this.minecraft.m_91268_().m_85443_());
        if (this.rect.m_110087_(i, j = (int)(this.minecraft.f_91067_.m_91594_() * (double)this.minecraft.m_91268_().m_85446_() / (double)this.minecraft.m_91268_().m_85444_()))) {
            this.offset = Mth.m_14045_((int)((int)((double)this.offset - delta)), (int)0, (int)Math.max(this.suggestionList.size() - this.suggestionLineLimit, 0));
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.cycle(-1);
            this.tabCycles = false;
            return true;
        }
        if (keyCode == 264) {
            this.cycle(1);
            this.tabCycles = false;
            return true;
        }
        if (keyCode == 258) {
            if (this.tabCycles) {
                this.cycle(Screen.m_96638_() ? -1 : 1);
            }
            this.useSuggestion();
            return true;
        }
        return false;
    }

    public void cycle(int change) {
        this.select(this.current + change);
        int i = this.offset;
        int j = this.offset + this.suggestionLineLimit - 1;
        if (this.current < i) {
            this.offset = Mth.m_14045_((int)this.current, (int)0, (int)Math.max(this.suggestionList.size() - this.suggestionLineLimit, 0));
        } else if (this.current > j) {
            this.offset = Mth.m_14045_((int)(this.current + this.lineStartOffset - this.suggestionLineLimit), (int)0, (int)Math.max(this.suggestionList.size() - this.suggestionLineLimit, 0));
        }
    }

    public void select(int index) {
        this.current = index;
        if (this.current < 0) {
            this.current += this.suggestionList.size();
        }
        if (this.current >= this.suggestionList.size()) {
            this.current -= this.suggestionList.size();
        }
        Suggestion suggestion = this.suggestionList.get(this.current);
        this.input.m_94167_(ATSuggestionsList.calculateSuggestionSuffix(this.input.m_94155_(), suggestion.apply(this.originalContents)));
        if (this.lastNarratedEntry != this.current) {
            this.minecraft.m_240477_().m_168785_(this.getNarrationMessage());
        }
    }

    @Nullable
    static String calculateSuggestionSuffix(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    public void useSuggestion() {
        Suggestion suggestion = this.suggestionList.get(this.current);
        this.keepSuggestions = true;
        this.input.m_94144_(suggestion.apply(this.originalContents));
        int i = suggestion.getRange().getStart() + suggestion.getText().length();
        this.input.m_94196_(i);
        this.input.m_94208_(i);
        this.select(this.current);
        this.keepSuggestions = false;
        this.tabCycles = true;
    }

    Component getNarrationMessage() {
        this.lastNarratedEntry = this.current;
        Suggestion suggestion = this.suggestionList.get(this.current);
        Message message = suggestion.getTooltip();
        return message != null ? Component.m_237110_((String)"narration.suggestion.tooltip", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText(), message}) : Component.m_237110_((String)"narration.suggestion", (Object[])new Object[]{this.current + 1, this.suggestionList.size(), suggestion.getText()});
    }
}

