/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.core.property.impl;

import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.core.property.Constants;
import com.clefal.teams.client.core.property.HealthTemplate;
import com.clefal.teams.client.core.property.impl.PropertyRenderer;
import com.clefal.teams.client.gui.util.FillBufferInfo;
import com.clefal.teams.client.gui.util.FillGradientBufferInfo;
import com.clefal.teams.client.gui.util.TextureBufferInfo;
import com.clefal.teams.client.gui.util.VertexContainer;
import com.clefal.teams.config.ATClientConfig;
import com.clefal.teams.modules.internal.propertyhandler.PositionContext;
import com.clefal.teams.server.ModComponents;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class Health
extends HealthTemplate<Health> {
    public static final String KEY = "health";
    private final ResourceLocation icon = AdvancedTeam.id("textures/gui/health.png");

    public Health(float health, float maxValue) {
        super(Float.valueOf(health), Float.valueOf(maxValue));
    }

    public static Health fromString(String str) {
        String[] split = str.split("/");
        return new Health(Float.parseFloat(split[0]), Float.parseFloat(split[1]));
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.icon;
    }

    @Override
    public String getIdentifier() {
        return KEY;
    }

    public static class Renderer
    extends PropertyRenderer<Health> {
        private static Renderer renderer;

        public Renderer(@Nullable Health property) {
            super(property);
        }

        public static Renderer getRenderer(Health health) {
            if (renderer == null) {
                renderer = new Renderer(health);
            }
            return renderer;
        }

        @Override
        public void render(GuiGraphics gui, VertexContainer container, ClientTeam.Teammate teammate, PositionContext positionContext) {
            if (ATClientConfig.config.overlays.showHealth) {
                RenderSystem.enableBlend();
                PoseStack pose = gui.m_280168_();
                pose.m_252880_(0.0f, positionContext.oneEntryHeight(), 0.0f);
                pose.m_85836_();
                Matrix4f matrix4f = new Matrix4f((Matrix4fc)gui.m_280168_().m_85850_().m_252922_());
                if (((Health)this.property).isInDanger()) {
                    float randomFactor = Constants.random.nextFloat(-0.001f, 0.001f);
                    container.putBliz(((Health)this.property).getResourceLocation(), TextureBufferInfo.of(PositionContext.getRelativeWidth(randomFactor * 2.0f), PositionContext.getRelativeHeight(randomFactor), 0.0f, 0.0f, 9, 9, 9, 9, matrix4f));
                } else {
                    container.putBliz(((Health)this.property).getResourceLocation(), TextureBufferInfo.of(0.0f, 0.0f, 0.0f, 0.0f, 9, 9, 9, 9, matrix4f));
                }
                pose.m_252880_(positionContext.iconAndTextInterval(), 0.0f, 0.0f);
                Matrix4f matrix4f1 = new Matrix4f((Matrix4fc)pose.m_85850_().m_252922_());
                float maxX = positionContext.iconAndTextInterval() + positionContext.barWidth() * ((Health)this.property).getTrackedBarLengthFactor();
                float maxY = positionContext.barHeight();
                container.putFill(FillBufferInfo.fillOf(0.0f, 0.0f, maxX, maxY, -0.01f, ((Health)this.property).getTrackedBarColor(), matrix4f1));
                container.putFill(FillGradientBufferInfo.getShadow(0.0f, 0.0f, maxX, maxY, matrix4f1));
                if (Screen.m_96638_()) {
                    pose.m_252880_(0.0f, Constants.getRelativeHeight(0.005f), 10.0f);
                    gui.m_280430_(Minecraft.m_91087_().f_91062_, (Component)ModComponents.literal(((Health)this.property).getRenderString()), 0, 0, ChatFormatting.WHITE.m_126665_().intValue());
                }
                RenderSystem.disableBlend();
                pose.m_85849_();
            }
        }
    }
}

