/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.core.property;

import com.clefal.teams.client.core.property.Color;
import com.clefal.teams.client.core.property.INumberTracking;
import com.clefal.teams.client.core.property.RenderableTrackedFloatProperty;
import com.clefal.teams.client.core.property.RenderableTrackedProperty;
import net.minecraft.util.FastColor;

public abstract class HealthTemplate<SELF>
extends RenderableTrackedFloatProperty<SELF> {
    private final Color whenLow = new Color(245, 31, 23);
    private final Color whenHigh = new Color(80, 231, 39);

    public HealthTemplate(Float health, Float maxHealth) {
        super(health, maxHealth);
    }

    @Override
    public String getRenderString() {
        return this.targetValue + "/" + this.maxValue;
    }

    @Override
    public void update() {
        this.currentValue = ((Float)this.currentValue).floatValue() < ((Float)this.targetValue).floatValue() ? (Number)Float.valueOf(Math.min(((Float)this.currentValue).floatValue() + INumberTracking.lerpTo(((Float)this.currentValue).floatValue(), ((Float)this.targetValue).floatValue()), ((Float)this.maxValue).floatValue())) : (Number)this.targetValue;
    }

    public boolean isInDanger() {
        return ((Float)this.targetValue).floatValue() / ((Float)this.maxValue).floatValue() < 0.2f;
    }

    @Override
    public int getTrackedBarColor() {
        double healthRatio = ((Float)this.targetValue).floatValue() / ((Float)this.maxValue).floatValue();
        healthRatio = Math.max(0.0, Math.min(1.0, healthRatio));
        int red = (int)((double)this.whenHigh.red() * healthRatio + (double)this.whenLow.red() * (1.0 - healthRatio));
        int green = (int)((double)this.whenHigh.green() * healthRatio + (double)this.whenLow.green() * (1.0 - healthRatio));
        int blue = (int)((double)this.whenHigh.blue() * healthRatio + (double)this.whenLow.blue() * (1.0 - healthRatio));
        return FastColor.ARGB32.m_13660_((int)190, (int)red, (int)green, (int)blue);
    }

    @Override
    public SELF mergeWith(SELF old) {
        if (old == null) {
            return (SELF)this;
        }
        ((RenderableTrackedProperty)old).targetValue = this.currentValue;
        ((RenderableTrackedProperty)old).maxValue = this.maxValue;
        return old;
    }
}

