/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.core;

import com.clefal.teams.AdvancedTeam;
import com.clefal.teams.client.core.ClientTeam;
import com.clefal.teams.client.gui.screens.TeamsScreen;
import com.clefal.teams.client.gui.screens.hasteam.HasTeamScreen;
import com.clefal.teams.client.gui.screens.noteam.NoTeamScreen;
import com.clefal.teams.modules.internal.propertyhandler.IProperty;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

class ClientTeamImpl
implements ClientTeam {
    private Minecraft client = Minecraft.m_91087_();
    private UUID leader;
    private Map<UUID, ClientTeam.Teammate> teammates = new HashMap<UUID, ClientTeam.Teammate>();
    private boolean initialized = false;
    private String name = "";
    private boolean hasPermission;
    private boolean allowEveryoneInvite;

    ClientTeamImpl() {
    }

    @Override
    public void init(String name, UUID leader) {
        if (this.initialized) {
            throw new IllegalArgumentException("Cannot initialize already initialized team. Did you clear it first?");
        }
        this.name = name;
        this.leader = leader;
        this.initialized = true;
    }

    @Override
    public void changeLeader(UUID leader) {
        this.leader = leader;
        Screen screen = this.client.f_91080_;
        if (screen instanceof HasTeamScreen) {
            HasTeamScreen screen2 = (HasTeamScreen)screen;
            screen2.refresh();
        }
    }

    @Override
    public boolean isLeader(UUID id) {
        return this.leader.equals(id);
    }

    @Override
    public void updatePermission(boolean hasPermission) {
        this.hasPermission = hasPermission;
        Screen screen = this.client.f_91080_;
        if (screen instanceof HasTeamScreen) {
            HasTeamScreen screen2 = (HasTeamScreen)screen;
            screen2.refresh();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canInvite() {
        return this.allowEveryoneInvite || this.hasPermission;
    }

    @Override
    public boolean allowEveryoneInvite() {
        return this.allowEveryoneInvite;
    }

    @Override
    public void setCanInvite(boolean canInvite) {
        this.allowEveryoneInvite = canInvite;
        Screen screen = this.client.f_91080_;
        if (screen instanceof HasTeamScreen) {
            HasTeamScreen screen2 = (HasTeamScreen)screen;
            screen2.refresh();
        }
    }

    @Override
    public boolean hasPermissions() {
        return this.hasPermission;
    }

    @Override
    public boolean isInTeam() {
        return this.initialized;
    }

    @Override
    public boolean isTeamEmpty() {
        return this.teammates.isEmpty() || this.teammates.size() == 1 && this.teammates.get(this.client.f_91074_.m_20148_()) != null;
    }

    @Override
    public List<ClientTeam.Teammate> getTeammates() {
        ImmutableList.Builder builder = ImmutableList.builder();
        ClientTeam.Teammate leader = this.teammates.get(this.leader);
        if (leader != null) {
            builder.add((Object)leader);
        }
        for (ClientTeam.Teammate teammate : this.teammates.values()) {
            if (teammate.id.equals(this.leader)) continue;
            builder.add((Object)teammate);
        }
        return builder.build();
    }

    @Override
    public boolean hasPlayer(UUID player) {
        return this.teammates.containsKey(player);
    }

    @Override
    public void addPlayer(UUID player, String name, ResourceLocation skin, IProperty ... others) {
        this.teammates.put(player, new ClientTeam.Teammate(player, name, skin, others));
        Screen screen = this.client.f_91080_;
        if (screen instanceof HasTeamScreen) {
            HasTeamScreen screen2 = (HasTeamScreen)screen;
            screen2.refresh();
        } else if (player.equals(this.client.f_91074_.m_20148_()) && this.client.f_91080_ instanceof TeamsScreen) {
            this.client.m_91152_(null);
        }
    }

    @Override
    public void updatePlayer(UUID player, IProperty ... properties) {
        ClientTeam.Teammate teammate = this.teammates.get(player);
        if (teammate != null) {
            for (IProperty property : properties) {
                teammate.addProperty(property);
            }
        } else if (this.teammates.get(this.client.f_91074_.m_20148_()) != null) {
            AdvancedTeam.LOGGER.warn("Tried updating player with UUID " + player + ", but they are not in this client team");
            AdvancedTeam.LOGGER.info(this.teammates.keySet().toString());
        }
    }

    @Override
    public void removePlayer(UUID player) {
        this.teammates.remove(player);
        Screen screen = this.client.f_91080_;
        if (screen instanceof HasTeamScreen) {
            HasTeamScreen screen2 = (HasTeamScreen)screen;
            if (this.teammates.isEmpty() || player.equals(this.client.f_91074_.m_20148_())) {
                this.client.m_91152_(screen2.parent);
            } else {
                screen2.refresh();
            }
        } else {
            screen = this.client.f_91080_;
            if (screen instanceof NoTeamScreen) {
                NoTeamScreen screen3 = (NoTeamScreen)screen;
                screen3.refresh();
            }
        }
    }

    @Override
    public void reset() {
        this.teammates.clear();
        this.name = "";
        this.leader = null;
        this.hasPermission = false;
        this.allowEveryoneInvite = false;
        this.initialized = false;
        if (this.client.f_91080_ instanceof TeamsScreen) {
            this.client.m_91152_((Screen)new NoTeamScreen(null));
        }
    }
}

