/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.core;

import com.clefal.nirvana_lib.relocated.io.vavr.collection.List;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClientTeamData {
    public static ClientTeamData INSTANCE = new ClientTeamData();
    private final Set<String> teams = new LinkedHashSet<String>();
    private final Set<String> onlineTeams = new LinkedHashSet<String>();
    private final Set<String> publicTeams = new LinkedHashSet<String>();

    private ClientTeamData() {
    }

    public List<String> getTeams() {
        return List.ofAll(this.teams);
    }

    public List<String> getOnlineTeams() {
        return List.ofAll(this.onlineTeams);
    }

    public boolean noPublicTeam() {
        return this.publicTeams.isEmpty();
    }

    public void addPublicTeam(String team) {
        this.publicTeams.add(team);
    }

    public void removePublicTeam(String team) {
        this.publicTeams.remove(team);
    }

    public boolean isPublicTeam(String team) {
        return this.publicTeams.contains(team);
    }

    public void addTeam(String team) {
        this.teams.add(team);
    }

    public void removeTeam(String team) {
        this.teams.remove(team);
        this.teamOffline(team);
    }

    public boolean containsTeam(String team) {
        return this.teams.contains(team);
    }

    public void teamOnline(String team) {
        this.onlineTeams.add(team);
    }

    public void teamOffline(String team) {
        this.onlineTeams.remove(team);
    }

    public boolean containsOnlineTeam(String team) {
        return this.onlineTeams.contains(team);
    }

    public void clear() {
        this.teams.clear();
        this.onlineTeams.clear();
    }
}

