/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams.client.core;

import com.clefal.nirvana_lib.relocated.io.vavr.control.Option;
import com.clefal.teams.client.core.ClientTeamImpl;
import com.clefal.teams.client.core.property.INumberTracking;
import com.clefal.teams.modules.internal.propertyhandler.IProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

public interface ClientTeam {
    public static final ClientTeam INSTANCE = new ClientTeamImpl();

    public void init(String var1, UUID var2);

    public String getName();

    public boolean canInvite();

    public boolean allowEveryoneInvite();

    public void setCanInvite(boolean var1);

    public void changeLeader(UUID var1);

    public boolean isLeader(UUID var1);

    public void updatePermission(boolean var1);

    public boolean hasPermissions();

    public boolean isInTeam();

    public boolean isTeamEmpty();

    public List<Teammate> getTeammates();

    public boolean hasPlayer(UUID var1);

    public void addPlayer(UUID var1, String var2, ResourceLocation var3, IProperty ... var4);

    public void updatePlayer(UUID var1, IProperty ... var2);

    public void removePlayer(UUID var1);

    public void reset();

    public static class Teammate {
        public final UUID id;
        public final String name;
        public final ResourceLocation skin;
        private final Map<String, IProperty> properties = new LinkedHashMap<String, IProperty>();

        Teammate(UUID id, String name, ResourceLocation skin, IProperty ... properties) {
            this.id = id;
            this.name = name;
            this.skin = skin;
            for (IProperty property : properties) {
                this.properties.put(property.getIdentifier(), property);
            }
        }

        public void addProperty(IProperty property) {
            if (property instanceof INumberTracking) {
                INumberTracking tracking = (INumberTracking)((Object)property);
                IProperty old = this.properties.get(property.getIdentifier());
                INumberTracking o = (INumberTracking)((Object)tracking.mergeWith(old));
                this.properties.put(property.getIdentifier(), (IProperty)((Object)o));
            } else {
                this.properties.put(property.getIdentifier(), property);
            }
        }

        public Option<IProperty> getProperty(String key) {
            return Option.of((Object)this.properties.get(key));
        }
    }
}

