/*
 * Decompiled with CFR 0.152.
 */
package com.clefal.teams;

import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.BusBuilder;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.Event;
import com.clefal.nirvana_lib.relocated.net.neoforged.bus.api.IEventBus;
import com.clefal.nirvana_lib.utils.NetworkUtils;
import com.clefal.teams.client.core.property.renderer.RendererManager;
import com.clefal.teams.config.ConfigManager;
import com.clefal.teams.event.client.ClientEvent;
import com.clefal.teams.event.server.ServerEvent;
import com.clefal.teams.modules.internal.HandlerManager;
import com.clefal.teams.modules.internal.propertyhandler.IPropertyClientHandler;
import com.clefal.teams.modules.internal.propertyhandler.IPropertyServerHandler;
import com.clefal.teams.network.Packets;
import com.clefal.teams.network.client.S2CTeamDataUpdatePacket;
import com.clefal.teams.server.ATServerTeam;
import com.clefal.teams.server.ATServerTeamData;
import com.clefal.teams.server.IHasTeam;
import com.clefal.teams.server.IPropertySender;
import net.minecraft.advancements.Advancement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedTeam {
    public static final boolean IN_DEV = Boolean.getBoolean("at.dev.tool");
    public static final String MODID = "teams";
    public static final String MOD_NAME = "Advanced Team";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Advanced Team");
    public static final IEventBus clientBus = BusBuilder.builder().setExceptionHandler((iEventBus, event, eventListeners, i, throwable) -> {
        try {
            throw throwable;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }).build();
    public static final IEventBus serverBus = BusBuilder.builder().setExceptionHandler((iEventBus, event, eventListeners, i, throwable) -> {
        try {
            throw throwable;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }).build();

    public static <T extends Event> T post(T t) {
        if (t instanceof ServerEvent) {
            serverBus.post(t);
        } else if (t instanceof ClientEvent) {
            clientBus.post(t);
        }
        return t;
    }

    public static void registerAtClient(Object o) {
        clientBus.register(o);
    }

    public static void registerAtServer(Object o) {
        serverBus.register(o);
    }

    public static void packetInit() {
        Packets.registerClientPackets();
        Packets.registerServerPackets();
    }

    public static void clientInit() {
        ConfigManager.init();
        for (IPropertyClientHandler han : HandlerManager.INSTANCE.getClientHandlers()) {
            clientBus.register((Object)han);
        }
        RendererManager.init();
    }

    public static void serverInit() {
        ConfigManager.init();
        for (IPropertyServerHandler han : HandlerManager.INSTANCE.getServerHandlers()) {
            serverBus.register((Object)han);
        }
        serverBus.addListener(x -> AdvancedTeam.onServerPlayerTick(x.player));
    }

    public static void onAdvancement(ServerPlayer player, Advancement advancement) {
        ATServerTeamData teamData = ATServerTeamData.getOrMakeDefault(player.f_8924_);
        ATServerTeam team = teamData.getTeam(player);
        if (team != null) {
            team.addAdvancement(advancement);
        }
    }

    public static void onServerPlayerTick(ServerPlayer player) {
        IHasTeam hasTeam = (IHasTeam)player;
        IPropertySender propertySender = (IPropertySender)player;
        hasTeam.tickInvitations();
        propertySender.handleUpdate();
    }

    public static void whenServerTick(MinecraftServer server) {
        for (ATServerTeam team : ATServerTeamData.getOrMakeDefault(server).getTeams()) {
            if (!team.getOnlinePlayers().find(team::playerHasPermissions).isDefined()) continue;
            team.tickApplication();
        }
    }

    public static void whenPlayerConnect(ServerPlayer player) {
        ATServerTeamData teamData = ATServerTeamData.getOrMakeDefault(player.f_8924_);
        ATServerTeam team = teamData.getTeam(player);
        if (team != null) {
            team.onPlayerOnline(player, true);
        }
        String[] teams = (String[])teamData.getTeams().map(ATServerTeam::m_5758_).toJavaArray(String[]::new);
        String[] onlineTeams = (String[])teamData.getTeams().filter(t -> !t.getOnlinePlayers().isEmpty()).map(ATServerTeam::m_5758_).toJavaArray(String[]::new);
        NetworkUtils.sendToClient((Object)new S2CTeamDataUpdatePacket(S2CTeamDataUpdatePacket.Type.ADD, teams), (ServerPlayer)player);
        NetworkUtils.sendToClient((Object)new S2CTeamDataUpdatePacket(S2CTeamDataUpdatePacket.Type.ONLINE, onlineTeams), (ServerPlayer)player);
    }

    public static void whenPlayerOffline(ServerPlayer player) {
        ATServerTeamData teamData = ATServerTeamData.getOrMakeDefault(player.f_8924_);
        ATServerTeam team = teamData.getTeam(player);
        if (team != null) {
            team.onPlayerOffline(player, true);
        }
    }

    public static void whenplayerClone(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean alive) {
        ATServerTeamData teamData = ATServerTeamData.getOrMakeDefault(oldPlayer.f_8924_);
        ATServerTeam team = teamData.getTeam(oldPlayer);
        if (team != null) {
            team.onPlayerOffline(oldPlayer, false);
            team.onPlayerOnline(newPlayer, false);
        }
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static void onServerStopped(MinecraftServer server) {
    }

    public static void onServerStarted(MinecraftServer server) {
    }
}

