/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import se.gory_moon.globalgamerules.Config;

public class WorldEvents {
    private static final Logger LOGGER = LogManager.getLogger((String)"GlobalGameRules");

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            Level world = event.getLevel();
            MinecraftServer server = world.m_7654_();
            if (server != null) {
                ((List)Config.COMMON.defaultCommands.get()).forEach(s -> {
                    String command = s.replaceAll("@p", player.m_36316_().getName());
                    server.m_129892_().m_230957_(server.m_129893_(), command);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)levelAccessor;
        LevelData levelData = world.m_6106_();
        if (!(levelData instanceof PrimaryLevelData)) {
            return;
        }
        PrimaryLevelData info = (PrimaryLevelData)levelData;
        if (((Boolean)Config.COMMON.useAsDefaultsOnly.get()).booleanValue() && info.m_6535_()) {
            return;
        }
        final GameRules rules = info.m_5470_();
        final MinecraftServer server = world.m_7654_();
        LOGGER.info("Applying config gamerules to level {}", (Object)info.m_5462_());
        Config.COMMON.gameRules.forEach((key, configValue) -> {
            GameRules.Value rule = rules.m_46170_(key);
            if (rule instanceof GameRules.IntegerValue) {
                GameRules.IntegerValue intVal = (GameRules.IntegerValue)rule;
                if (configValue instanceof ForgeConfigSpec.IntValue) {
                    ForgeConfigSpec.IntValue config = (ForgeConfigSpec.IntValue)configValue;
                    intVal.m_151489_(((Integer)config.get()).intValue(), server);
                    return;
                }
            }
            if (rule instanceof GameRules.BooleanValue) {
                GameRules.BooleanValue boolVal = (GameRules.BooleanValue)rule;
                if (configValue instanceof ForgeConfigSpec.BooleanValue) {
                    ForgeConfigSpec.BooleanValue config = (ForgeConfigSpec.BooleanValue)configValue;
                    boolVal.m_46246_(((Boolean)config.get()).booleanValue(), server);
                    return;
                }
            }
            LOGGER.warn("Could not apply gamerule {} as it is not an integer or boolean, it's {}", (Object)key.m_46328_(), (Object)configValue.getClass().getSimpleName());
        });
        final Map entries = ((com.electronwill.nightconfig.core.Config)Config.COMMON.modGameRules.get()).valueMap();
        if (!entries.isEmpty()) {
            LOGGER.info("Applying config modded gamerules to level {}", (Object)info.m_5462_());
            GameRules.m_46164_((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                /*
                 * Enabled aggressive block sorting
                 */
                public <T extends GameRules.Value<T>> void m_6889_(// Could not load outer class - annotation placement on inner may be incorrect
                @NotNull GameRules.Key<T> key, // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull GameRules.Type<T> type) {
                    String category = key.m_46332_().toString().toLowerCase();
                    Object cat = entries.get(category);
                    if (!(cat instanceof com.electronwill.nightconfig.core.Config)) return;
                    com.electronwill.nightconfig.core.Config cfg = (com.electronwill.nightconfig.core.Config)cat;
                    Object val = cfg.get(key.m_46328_());
                    if (val == null) {
                        return;
                    }
                    GameRules.Value rule = rules.m_46170_(key);
                    if (rule instanceof GameRules.IntegerValue) {
                        GameRules.IntegerValue intRule = (GameRules.IntegerValue)rule;
                        if (val instanceof Integer) {
                            Integer iVal = (Integer)val;
                            intRule.m_151489_(iVal.intValue(), server);
                            return;
                        }
                    }
                    if (rule instanceof GameRules.BooleanValue) {
                        GameRules.BooleanValue boolRule = (GameRules.BooleanValue)rule;
                        if (val instanceof Boolean) {
                            Boolean bVal = (Boolean)val;
                            boolRule.m_46246_(bVal.booleanValue(), server);
                            return;
                        }
                    }
                    LOGGER.warn("Could not apply mod gamerule {} as it is not an integer or boolean, it's {}", (Object)key.m_46328_(), (Object)val.getClass().getSimpleName());
                }
            });
        } else {
            LOGGER.info("No modded gamerules to apply to level {}", (Object)info.m_5462_());
        }
        if (!info.m_5474_()) {
            Boolean hardcore = (Boolean)Config.COMMON.hardcore.get();
            Boolean enforceHardcore = (Boolean)Config.COMMON.enforceHardcore.get();
            if (enforceHardcore.booleanValue() && info.m_5466_() != hardcore.booleanValue()) {
                LevelSettings settings = info.f_78443_;
                info.f_78443_ = new LevelSettings(settings.m_46917_(), settings.m_46929_(), hardcore.booleanValue(), settings.m_46931_(), settings.m_46932_(), settings.m_46933_(), settings.m_246291_());
                if (hardcore.booleanValue() && info.m_5472_() != Difficulty.HARD) {
                    server.m_129827_(Difficulty.HARD, false);
                }
                if (hardcore.booleanValue()) {
                    LOGGER.info("Enabling hardcore in level {}", (Object)info.m_5462_());
                } else {
                    LOGGER.info("Disabling hardcore in level {}", (Object)info.m_5462_());
                }
            }
            if (((Boolean)Config.COMMON.setDifficulty.get()).booleanValue()) {
                Difficulty diff = (Difficulty)Config.COMMON.difficulty.get();
                server.m_129827_(diff, false);
                LOGGER.info("Setting difficulty of level {} to {}", (Object)info.m_5462_(), (Object)diff.toString());
            }
        }
        if (((Boolean)Config.COMMON.lockDifficulty.get()).booleanValue()) {
            server.m_129958_(true);
            LOGGER.info("Locking difficulty of level {}", (Object)info.m_5462_());
        }
    }

    @SubscribeEvent
    public static void onWorldUnLoad(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)levelAccessor;
        LevelData levelData = world.m_6106_();
        if (!(levelData instanceof PrimaryLevelData)) {
            return;
        }
        PrimaryLevelData info = (PrimaryLevelData)levelData;
        if (((Boolean)Config.COMMON.useAsDefaultsOnly.get()).booleanValue()) {
            return;
        }
        GameRules rules = info.m_5470_();
        AtomicBoolean dirty = new AtomicBoolean(false);
        if (((Boolean)Config.COMMON.saveGameRules.get()).booleanValue()) {
            Config.COMMON.gameRules.forEach((ruleKey, configValue) -> {
                GameRules.Value val = rules.m_46170_(ruleKey);
                if (val instanceof GameRules.BooleanValue) {
                    GameRules.BooleanValue booleanValue = (GameRules.BooleanValue)val;
                    ForgeConfigSpec.BooleanValue config = (ForgeConfigSpec.BooleanValue)configValue;
                    if (((Boolean)config.get()).booleanValue() != booleanValue.m_46223_()) {
                        config.set((Object)booleanValue.m_46223_());
                        dirty.set(true);
                    }
                } else if (val instanceof GameRules.IntegerValue) {
                    GameRules.IntegerValue intValue = (GameRules.IntegerValue)val;
                    ForgeConfigSpec.IntValue config = (ForgeConfigSpec.IntValue)configValue;
                    if (((Integer)config.get()).intValue() != intValue.m_46288_()) {
                        config.set((Object)intValue.m_46288_());
                        dirty.set(true);
                    }
                }
            });
            if (Config.COMMON.updateModdedGamerules(rules)) {
                dirty.set(true);
            }
        }
        if (((Boolean)Config.COMMON.setDifficulty.get()).booleanValue() && !info.m_5474_() && Config.COMMON.difficulty.get() != info.m_5472_()) {
            Config.COMMON.difficulty.set((Object)info.m_5472_());
            dirty.set(true);
        }
        if (dirty.get()) {
            Config.commonSpec.save();
        }
    }
}

