/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.data;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.emi.emi.EmiPort;
import dev.emi.emi.data.EmiResourceReloadListener;
import dev.emi.emi.runtime.EmiLog;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class EmiDataLoader<T>
extends SimplePreparableReloadListener<T>
implements EmiResourceReloadListener {
    private static final Gson GSON = new Gson();
    private final ResourceLocation id;
    private final String path;
    private final Supplier<T> baseSupplier;
    private final DataConsumer<T> prepare;
    private final Consumer<T> apply;

    public EmiDataLoader(ResourceLocation id, String path, Supplier<T> baseSupplier, DataConsumer<T> prepare, Consumer<T> apply) {
        this.id = id;
        this.path = path;
        this.baseSupplier = baseSupplier;
        this.prepare = prepare;
        this.apply = apply;
    }

    public T m_5944_(ResourceManager manager, ProfilerFiller profiler) {
        T t = this.baseSupplier.get();
        for (ResourceLocation id : EmiPort.findResources(manager, this.path, i -> i.endsWith(".json"))) {
            if (!id.m_135827_().equals("emi")) continue;
            for (Resource resource : manager.m_213829_(id)) {
                try {
                    InputStreamReader reader = new InputStreamReader(EmiPort.getInputStream(resource));
                    JsonObject json = (JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class);
                    this.prepare.accept(t, json, id);
                }
                catch (Exception e) {
                    EmiLog.error("Error loading data for " + String.valueOf(this.id) + " in " + String.valueOf(id), e);
                }
            }
        }
        return t;
    }

    public void m_5787_(T t, ResourceManager manager, ProfilerFiller profiler) {
        this.apply.accept(t);
    }

    @Override
    public ResourceLocation getEmiId() {
        return this.id;
    }

    public static interface DataConsumer<T> {
        public void accept(T var1, JsonObject var2, ResourceLocation var3);
    }
}

