/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.recipe;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

public final class RecipeHandlerRegistry
implements IRecipeHandlerRegistry {
    private final Map<Class<? extends Recipe<?>>, IRecipeHandler<?>> recipeHandlers = new HashMap();

    public <T extends Recipe<?>> void register(Class<? extends T> clazz, IRecipeHandler<T> handler) {
        this.recipeHandlers.put(clazz, handler);
    }

    @Override
    public <T extends Recipe<?>> IRecipeHandler<T> getRecipeHandlerFor(T recipe) {
        return this.getRecipeHandlerFor(recipe.getClass());
    }

    @Override
    public <T extends Recipe<?>> IRecipeHandler<T> getRecipeHandlerFor(Class<T> recipeClass) {
        return this.getRecipeHandlerForClass(recipeClass).orElse(DefaultRecipeHandler.INSTANCE);
    }

    private Optional<IRecipeHandler<?>> getRecipeHandlerForClass(Class<?> recipeClass) {
        ArrayDeque classes = new ArrayDeque();
        classes.offer(recipeClass);
        while (!classes.isEmpty()) {
            Class target = (Class)classes.poll();
            if (target == Recipe.class) continue;
            IRecipeHandler<?> attempt = this.recipeHandlers.get(target);
            if (attempt != null) {
                return Optional.of(attempt);
            }
            if (target.getSuperclass() != null) {
                classes.offer(target.getSuperclass());
            }
            Arrays.stream(target.getInterfaces()).forEach(classes::offer);
        }
        return Optional.empty();
    }

    private static final class DefaultRecipeHandler
    implements IRecipeHandler<Recipe<?>> {
        private static final DefaultRecipeHandler INSTANCE = new DefaultRecipeHandler();

        private DefaultRecipeHandler() {
        }

        @Override
        public String dumpToCommandString(IRecipeManager<? super Recipe<?>> manager, Recipe<?> recipe) {
            String ingredients = recipe.m_7527_().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", "));
            Object[] objectArray = new Object[5];
            objectArray[0] = recipe.m_6423_();
            objectArray[1] = ItemStackUtil.getCommandString(AccessibleElementsProvider.get().registryAccess(arg_0 -> recipe.m_8043_(arg_0)));
            objectArray[2] = ingredients;
            objectArray[3] = recipe.getClass().getName();
            objectArray[4] = BuiltInRegistries.f_256769_.m_7981_((Object)recipe.m_7707_());
            return String.format("~~ Recipe name: %s, Outputs: %s, Inputs: [%s], Recipe Class: %s, Recipe Serializer: %s ~~", objectArray);
        }

        @Override
        public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super Recipe<?>> manager, Recipe<?> firstRecipe, U secondRecipe) {
            return false;
        }

        @Override
        public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super Recipe<?>> manager, Recipe<?> recipe) {
            return Optional.empty();
        }

        @Override
        public Optional<Recipe<?>> recompose(IRecipeManager<? super Recipe<?>> manager, ResourceLocation name, IDecomposedRecipe recipe) {
            return Optional.empty();
        }
    }
}

