/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.core;

import com.blamejared.crafttweaker.api.plugin.ITaggableElementRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.manager.ITagManager;
import com.blamejared.crafttweaker.api.tag.manager.TagManagerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

final class TaggableElementsRegistrationHandler
implements ITaggableElementRegistrationHandler {
    private final List<ElementData> elementRequests = new ArrayList<ElementData>();
    private final List<ManagerData> managerRequests = new ArrayList<ManagerData>();

    private TaggableElementsRegistrationHandler() {
    }

    static TaggableElementsRegistrationHandler of(Consumer<ITaggableElementRegistrationHandler> consumer) {
        TaggableElementsRegistrationHandler handler = new TaggableElementsRegistrationHandler();
        consumer.accept(handler);
        return handler;
    }

    @Override
    public <T> void registerTaggableElement(ResourceKey<Registry<T>> key, Class<T> elementClass) {
        this.elementRequests.add(new ElementData(key, elementClass));
    }

    @Override
    public <T, U extends ITagManager<?>> void registerManager(ResourceKey<Registry<T>> key, TagManagerFactory<T, U> factory) {
        this.managerRequests.add(new ManagerData(key, factory));
    }

    List<ElementData> elementRequests() {
        return Collections.unmodifiableList(this.elementRequests);
    }

    List<ManagerData> managerRequests() {
        return Collections.unmodifiableList(this.managerRequests);
    }

    record ElementData(ResourceKey<?> key, Class<?> elementClass) {
    }

    record ManagerData(ResourceKey<?> key, TagManagerFactory<?, ?> factory) {
    }
}

