/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.serializer;

import com.blamejared.crafttweaker.api.ingredient.type.IngredientList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public enum IngredientListSerializer implements IIngredientSerializer<IngredientList>
{
    INSTANCE;


    public IngredientList parse(FriendlyByteBuf buffer) {
        return new IngredientList(Stream.generate(() -> Ingredient.m_43940_((FriendlyByteBuf)buffer)).limit(buffer.m_130242_()).collect(Collectors.toList()));
    }

    public IngredientList parse(JsonObject json) {
        if (!(json.get("ingredients") instanceof JsonArray)) {
            throw new JsonParseException("No 'ingredients' array to parse!");
        }
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        for (JsonElement jsonElement : json.getAsJsonArray("ingredients")) {
            ingredients.add(Ingredient.m_43917_((JsonElement)jsonElement));
        }
        return new IngredientList(ingredients);
    }

    public void write(FriendlyByteBuf buffer, IngredientList ingredient) {
        CompoundIngredient.Serializer.INSTANCE.write(buffer, (CompoundIngredient)ingredient);
    }
}

