/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketDumper;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker.natives.entity.attribute.ExpandAttribute;
import com.blamejared.crafttweaker.natives.entity.effect.ExpandMobEffect;
import com.blamejared.crafttweaker.natives.item.alchemy.ExpandPotion;
import com.blamejared.crafttweaker.natives.item.enchantment.ExpandEnchantment;
import com.blamejared.crafttweaker.natives.sound.ExpandSoundEvent;
import com.blamejared.crafttweaker.natives.villager.ExpandVillagerProfession;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.BracketDumpers")
@Document(value="vanilla/api/BracketDumpers")
public class BracketDumpers {
    @ZenCodeType.Method
    @BracketDumper(value="attribute")
    public static Collection<String> getAttributeDump() {
        return BuiltInRegistries.f_256951_.m_123024_().map(ExpandAttribute::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="block")
    public static Collection<String> getBlockDump() {
        return BuiltInRegistries.f_256975_.m_123024_().map(ExpandBlock::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.StaticExpansionMethod
    @BracketDumper(value="fluid")
    public static Collection<String> getFluidStackDump() {
        return BuiltInRegistries.f_257020_.m_123024_().map(fluid -> IFluidStack.of(fluid, 1L).getCommandString()).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="mobeffect")
    public static Collection<String> getEffectDump() {
        return BuiltInRegistries.f_256974_.m_123024_().map(ExpandMobEffect::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="enchantment")
    public static Collection<String> getEnchantmentDump() {
        return BuiltInRegistries.f_256876_.m_123024_().map(ExpandEnchantment::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="entitytype")
    public static Collection<String> getEntityTypeDump() {
        return BuiltInRegistries.f_256780_.m_123024_().map(internal -> ExpandEntityType.getCommandString((EntityType<Entity>)((EntityType)GenericUtil.uncheck(internal)))).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="item")
    public static Collection<String> getItemBracketDump() {
        return BuiltInRegistries.f_257033_.m_123024_().map(Item::m_7968_).map(ItemStackUtil::getCommandString).collect(Collectors.toSet());
    }

    @ZenCodeType.Method
    @BracketDumper(value="potion")
    public static Collection<String> getPotionTypeDump() {
        return BuiltInRegistries.f_256980_.m_123024_().map(ExpandPotion::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="profession")
    public static Collection<String> getProfessionDump() {
        return BuiltInRegistries.f_256735_.m_123024_().map(ExpandVillagerProfession::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="soundevent")
    public static Collection<String> getSoundEventDump() {
        return BuiltInRegistries.f_256894_.m_123024_().map(ExpandSoundEvent::getCommandString).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @BracketDumper(value="targetingstrategy")
    public static Collection<String> getTargetingStrategyDump() {
        return CraftTweakerAPI.getRegistry().getReplacerRegistry().allStrategyNames().stream().map(arg_0 -> BracketDumpers.lambda$getTargetingStrategyDump$2("<targetingstrategy:%s>", arg_0)).collect(Collectors.toList());
    }

    private static /* synthetic */ String lambda$getTargetingStrategyDump$2(String rec$, Object xva$0) {
        return "<targetingstrategy:%s>".formatted(xva$0);
    }
}

