/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.dataanchor.mixin;

import dev.corgitaco.dataanchor.data.TickableTrackedData;
import dev.corgitaco.dataanchor.data.TrackedDataContainer;
import dev.corgitaco.dataanchor.data.registry.TrackedDataKey;
import dev.corgitaco.dataanchor.data.registry.TrackedDataRegistries;
import dev.corgitaco.dataanchor.data.type.entity.EntityTrackedData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements TrackedDataContainer<Entity, EntityTrackedData> {
    @Shadow
    private Level f_19853_;
    @Unique
    private TrackedDataContainer<Entity, EntityTrackedData> dataAnchor$container;
    @Unique
    private final Collection<TickableTrackedData> dataAnchor$tickableData = new ArrayList<TickableTrackedData>();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void dataAnchor$init(EntityType entityType, Level level, CallbackInfo ci) {
        this.dataAnchor$createTrackedData();
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="RETURN")})
    private void dataAnchor$saveWithoutId(CompoundTag compound, CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag trackedData = new CompoundTag();
        Collection<TrackedDataKey<EntityTrackedData>> keys = this.dataAnchor$container.dataAnchor$getTrackedDataKeys();
        for (TrackedDataKey<EntityTrackedData> key : keys) {
            this.dataAnchor$container.dataAnchor$getTrackedData(key).ifPresent(data -> {
                CompoundTag saveTag = data.save();
                if (saveTag != null) {
                    trackedData.m_128365_(key.getId().toString(), (Tag)saveTag);
                }
            });
        }
        compound.m_128365_("TrackedData", (Tag)trackedData);
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void dataAnchor$load(CompoundTag loadTag, CallbackInfo ci) {
        if (loadTag != null && loadTag.m_128441_("TrackedData")) {
            CompoundTag trackedData = loadTag.m_128469_("TrackedData");
            Collection<TrackedDataKey<EntityTrackedData>> keys = this.dataAnchor$container.dataAnchor$getTrackedDataKeys();
            for (TrackedDataKey<EntityTrackedData> key : keys) {
                String tagKey = key.getId().toString();
                if (!trackedData.m_128441_(tagKey)) continue;
                this.dataAnchor$container.dataAnchor$getTrackedData(key).ifPresent(entityTrackedData -> entityTrackedData.load(trackedData.m_128469_(tagKey)));
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void dataAnchor$tick(CallbackInfo ci) {
        for (TickableTrackedData tickable : this.dataAnchor$tickableData) {
            tickable.tick();
        }
    }

    @Override
    public <E extends EntityTrackedData> Optional<E> dataAnchor$getTrackedData(TrackedDataKey<E> key) {
        return this.dataAnchor$container.dataAnchor$getTrackedData(key);
    }

    @Override
    public void dataAnchor$createTrackedData() {
        this.dataAnchor$container = TrackedDataContainer.makeBasicContainer(TrackedDataRegistries.ENTITY, (Entity)this, this.f_19853_.m_5776_());
        this.dataAnchor$container.dataAnchor$createTrackedData();
        for (TrackedDataKey<EntityTrackedData> key : this.dataAnchor$container.dataAnchor$getTrackedDataKeys()) {
            this.dataAnchor$container.dataAnchor$getTrackedData(key).ifPresent(entityTrackedData -> {
                if (entityTrackedData instanceof TickableTrackedData) {
                    TickableTrackedData tickable = (TickableTrackedData)((Object)entityTrackedData);
                    this.dataAnchor$tickableData.add(tickable);
                }
            });
        }
    }

    @Override
    public Collection<TrackedDataKey<EntityTrackedData>> dataAnchor$getTrackedDataKeys() {
        return this.dataAnchor$container.dataAnchor$getTrackedDataKeys();
    }
}

