/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.forge.datagen;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.chococraft.common.world.worldgen.ModFeatures;
import net.chococraft.forge.common.modifier.AddChocoboModifier;
import net.chococraft.forge.datagen.client.ChocoBlockModels;
import net.chococraft.forge.datagen.client.ChocoBlockstates;
import net.chococraft.forge.datagen.client.ChocoItemModels;
import net.chococraft.forge.datagen.client.ChocoLanguage;
import net.chococraft.forge.datagen.client.ChocoSoundProvider;
import net.chococraft.forge.datagen.client.patchouli.PatchouliProvider;
import net.chococraft.forge.datagen.data.ChocoLoot;
import net.chococraft.forge.datagen.data.ChocoRecipes;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModDatagenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.addProvider(event.includeServer(), (DataProvider)new ChocoLoot(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new ChocoRecipes(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new PatchouliProvider(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, CompletableFuture.supplyAsync(ModDatagenerator::getProvider), Set.of("chococraft")));
        }
        if (event.includeClient()) {
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoLanguage(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoBlockModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoBlockstates(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoItemModels(packOutput, helper));
            generator.addProvider(event.includeClient(), (DataProvider)new ChocoSoundProvider(packOutput, helper));
        }
    }

    private static HolderLookup.Provider getProvider() {
        RegistrySetBuilder registryBuilder = new RegistrySetBuilder();
        registryBuilder.m_254916_(Registries.f_256911_, context -> ModFeatures.configuredBootstrap(context));
        registryBuilder.m_254916_(Registries.f_256988_, context -> ModFeatures.placedBootstrap((BootstapContext<PlacedFeature>)context));
        registryBuilder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, context -> {
            HolderGetter biomeGetter = context.m_255420_(Registries.f_256952_);
            HolderGetter placedGetter = context.m_255420_(Registries.f_256988_);
            context.m_255272_(ModDatagenerator.createModifierKey("add_plains_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.m_254956_(Tags.Biomes.IS_PLAINS)));
            context.m_255272_(ModDatagenerator.createModifierKey("add_mountain_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.m_254956_(Tags.Biomes.IS_MOUNTAIN)));
            context.m_255272_(ModDatagenerator.createModifierKey("add_nether_chocobos"), (Object)new AddChocoboModifier((HolderSet<Biome>)biomeGetter.m_254956_(BiomeTags.f_207612_)));
            context.m_255272_(ModDatagenerator.createModifierKey("add_gysahl_green"), (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeGetter.m_254956_(BiomeTags.f_215817_), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placedGetter.m_255043_(ModFeatures.PLACED_PATCH_GYSAHL_GREEN)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        });
        registryBuilder.m_254916_(Registries.f_256952_, context -> {});
        RegistryAccess.Frozen regAccess = RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_);
        return registryBuilder.m_254929_((RegistryAccess)regAccess, VanillaRegistries.m_255371_());
    }

    public static ResourceKey<BiomeModifier> createModifierKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("chococraft", name));
    }
}

