/*
 * Decompiled with CFR 0.152.
 */
package net.chococraft.forge.common.config;

import java.util.List;
import net.chococraft.Chococraft;
import net.chococraft.common.config.ChocoConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeChocoConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Chococraft.LOGGER.debug("Loaded Chococraft's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Chococraft.LOGGER.debug("Chococraft's config just got changed on the file system!");
        if (configEvent.getConfig().getModId().equals("chococraft")) {
            if ((Integer)ForgeChocoConfig.COMMON.chocoboPackSizeMin.get() > (Integer)ForgeChocoConfig.COMMON.chocoboPackSizeMax.get()) {
                int t = (Integer)ForgeChocoConfig.COMMON.chocoboPackSizeMax.get();
                ForgeChocoConfig.COMMON.chocoboPackSizeMax.set((Object)((Integer)ForgeChocoConfig.COMMON.chocoboPackSizeMin.get()));
                ForgeChocoConfig.COMMON.chocoboPackSizeMin.set((Object)t);
            }
            configEvent.getConfig().save();
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue chocoboSpawnWeight;
        public final ForgeConfigSpec.IntValue chocoboPackSizeMin;
        public final ForgeConfigSpec.IntValue chocoboPackSizeMax;
        public final ForgeConfigSpec.DoubleValue tameChance;
        public final ForgeConfigSpec.BooleanValue nameTamedChocobos;
        public final ForgeConfigSpec.BooleanValue canChocobosFly;
        public final ForgeConfigSpec.IntValue kwehIntervalLimit;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> maleNames;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> femaleNames;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Spawning configuration").push("spawning");
            this.chocoboSpawnWeight = builder.comment("Controls Chocobo Spawn Weight [Default: 10]").defineInRange("chocoboSpawnWeight", 10, 0, Integer.MAX_VALUE);
            this.chocoboPackSizeMin = builder.comment("Controls Chocobo Pack Size Min [Default: 1]").defineInRange("chocoboPackSizeMin", 1, 0, Integer.MAX_VALUE);
            this.chocoboPackSizeMax = builder.comment("Controls Chocobo Pack Size Max [Default: 3]").defineInRange("chocoboPackSizeMax", 3, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Chocobo configuration").push("Chocobo");
            this.tameChance = builder.comment("This multiplier controls the tame chance per gysahl used, so .15 results in 15% chance to tame [Default: 0.15]").defineInRange("tameChance", 0.15, 0.0, 1.0);
            this.canChocobosFly = builder.comment("If certain chocobos are allowed to fly [Default: true]").define("canChocobosFly", true);
            this.kwehIntervalLimit = builder.comment("Determines the maximum interval duration for the Chocobo's ambient sound [Default: 100]").defineInRange("kwehIntervalLimit", 100, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Naming configuration").push("Naming");
            this.nameTamedChocobos = builder.comment("If taming a chocobo will provide them with a name (unless already named) [Default: true]").define("nameTamedChocobos", true);
            this.maleNames = builder.comment("The list of male names it can choose from if 'nameTamedChocobos' is enabled").defineList("maleNames", List.of(ChocoConfig.maleNames), o -> o instanceof String);
            this.femaleNames = builder.comment("The list of female names it can choose from if 'nameTamedChocobos' is enabled").defineList("femaleNames", List.of(ChocoConfig.femaleNames), o -> o instanceof String);
            builder.pop();
        }
    }
}

