/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.temporary_spawners.temp_spawners;

import com.robertx22.temporary_spawners.configs.TemporarySpawnersConfig;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class TempSpawnerComponent
implements ICapabilitySerializable<CompoundTag> {
    public static final ResourceLocation RESOURCE = new ResourceLocation("temporary_spawners", "spawner_data");
    public static Capability<TempSpawnerComponent> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<TempSpawnerComponent>(){});
    final transient LazyOptional<TempSpawnerComponent> supp = LazyOptional.of(() -> this);
    public SpawnerBlockEntity spawner;
    int ticksNearPlayer = 0;
    int cooldownTicks = 0;

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public static TempSpawnerComponent get(Level provider) {
        return (TempSpawnerComponent)provider.getCapability(INSTANCE).orElse(null);
    }

    public void tickNearPlayer() {
        if (this.cooldownTicks < 1) {
            ++this.ticksNearPlayer;
            if (this.ticksNearPlayer > (Integer)TemporarySpawnersConfig.get().SPAWNER_LIFETIME_MINUTES.get() * 20 * 60) {
                this.ticksNearPlayer = 0;
                if (((Boolean)TemporarySpawnersConfig.get().ENABLE_SPAWNER_DESTRUCTION.get()).booleanValue()) {
                    this.spawner.m_58904_().m_46961_(this.spawner.m_58899_(), false);
                } else {
                    this.cooldownTicks = (Integer)TemporarySpawnersConfig.get().SPAWNER_COOLDOWN_MINUTES.get() * 20 * 60;
                }
            }
        } else {
            --this.cooldownTicks;
            ServerLevel sw = (ServerLevel)this.spawner.m_58904_();
            if (this.cooldownTicks % 10 == 0) {
                sw.m_8767_((ParticleOptions)ParticleTypes.f_123750_, (double)((float)this.spawner.m_58899_().m_123341_() + 0.5f), (double)((float)this.spawner.m_58899_().m_123342_() + 1.5f), (double)((float)this.spawner.m_58899_().m_123343_() + 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void tickWhenNoPlayer() {
        --this.cooldownTicks;
    }

    public boolean shouldCancelTick() {
        return this.cooldownTicks > 0;
    }

    public TempSpawnerComponent(SpawnerBlockEntity spawner) {
        this.spawner = spawner;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("ticks", this.ticksNearPlayer);
        tag.m_128405_("cd", this.cooldownTicks);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.ticksNearPlayer = nbt.m_128451_("ticks");
        this.cooldownTicks = nbt.m_128451_("cd");
    }
}

