/*
 * Decompiled with CFR 0.152.
 */
package net.mahjerion.mns_extras.network;

import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.List;
import java.util.function.Supplier;
import net.mahjerion.mns_extras.config.ProfessionShopConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PurchaseItemPacket {
    private final String profession;
    private final int itemIndex;

    public PurchaseItemPacket(String profession, int itemIndex) {
        this.profession = profession;
        this.itemIndex = itemIndex;
    }

    public static void encode(PurchaseItemPacket packet, FriendlyByteBuf buf) {
        buf.m_130070_(packet.profession);
        buf.writeInt(packet.itemIndex);
    }

    public static PurchaseItemPacket decode(FriendlyByteBuf buf) {
        return new PurchaseItemPacket(buf.m_130277_(), buf.readInt());
    }

    public static void handle(PurchaseItemPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            List<ProfessionShopConfig.ShopItem> items = ProfessionShopConfig.getItemsForProfession(packet.profession);
            if (packet.itemIndex < 0 || packet.itemIndex >= items.size()) {
                return;
            }
            ProfessionShopConfig.ShopItem shopItem = items.get(packet.itemIndex);
            int playerLevel = Load.player((Player)player).professions.getLevel(shopItem.requiredProfession);
            if (playerLevel < shopItem.requiredLevel) {
                return;
            }
            ItemStack currencyStack = shopItem.getCurrencyStack();
            if (player.m_150109_().m_18947_(currencyStack.m_41720_()) < currencyStack.m_41613_()) {
                return;
            }
            int remaining = currencyStack.m_41613_();
            for (int i = 0; i < player.m_150109_().m_6643_() && remaining > 0; ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (stack.m_41720_() != currencyStack.m_41720_()) continue;
                int toRemove = Math.min(remaining, stack.m_41613_());
                stack.m_41774_(toRemove);
                remaining -= toRemove;
            }
            ItemStack purchasedItem = shopItem.getItemStack();
            if (!player.m_150109_().m_36054_(purchasedItem)) {
                player.m_36176_(purchasedItem, false);
            }
        });
        context.setPacketHandled(true);
    }
}

