/*
 * Decompiled with CFR 0.152.
 */
package net.mahjerion.mns_extras.mixins;

import com.mojang.logging.LogUtils;
import com.robertx22.mine_and_slash.capability.player.data.PlayerProfessionsData;
import net.mahjerion.mns_extras.ProfessionAdvancementHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerProfessionsData.class}, remap=false)
public class PlayerProfessionsDataMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"addExp"}, at={@At(value="INVOKE", target="Lcom/robertx22/mine_and_slash/capability/player/data/PlayerProfessionsData$Data;levelUp()V", shift=At.Shift.AFTER)}, remap=false)
    private void onProfessionLevelUp(Player p, String id, int exp, CallbackInfo ci) {
        try {
            LOGGER.info("Mixin triggered: Player {} leveled up in profession {} with {} exp", new Object[]{p.m_7755_().getString(), id, exp});
            if (p instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)p;
                LOGGER.info("Calling ProfessionAdvancementHandler for player {} and profession {}", (Object)serverPlayer.m_7755_().getString(), (Object)id);
                serverPlayer.m_20194_().execute(() -> ProfessionAdvancementHandler.checkProfessionThreshold(serverPlayer, id));
            } else {
                LOGGER.warn("Player is not a ServerPlayer: {}", (Object)p.getClass().getSimpleName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in profession level up mixin for player {} and profession {}: {}", new Object[]{p.m_7755_().getString(), id, e.getMessage(), e});
        }
    }
}

