/*
 * Decompiled with CFR 0.152.
 */
package net.mahjerion.mns_extras.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class ProfessionShopConfig {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "profession_shop.json";
    private static Map<String, List<ShopItem>> shopItems = new HashMap<String, List<ShopItem>>();

    public static void loadConfig() {
        Path configPath = FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE);
        if (!Files.exists(configPath, new LinkOption[0])) {
            ProfessionShopConfig.createDefaultConfig(configPath);
        }
        try (FileReader reader = new FileReader(configPath.toFile());){
            Type type = new TypeToken<Map<String, List<ShopItem>>>(){}.getType();
            Map loaded = (Map)GSON.fromJson((Reader)reader, type);
            if (loaded != null) {
                shopItems = loaded;
            }
            LOGGER.info("Loaded profession shop config with {} profession categories", (Object)shopItems.size());
        }
        catch (IOException e) {
            LOGGER.error("Failed to load profession shop config: {}", (Object)e.getMessage());
            ProfessionShopConfig.createDefaultConfig(configPath);
        }
    }

    private static void createDefaultConfig(Path configPath) {
        shopItems.clear();
        List<ShopItem> miningItems = Arrays.asList(new ShopItem("minecraft:diamond_pickaxe", 1, "minecraft:diamond", 8, "mining", 15, "Diamond Pickaxe"), new ShopItem("minecraft:netherite_ingot", 1, "minecraft:diamond", 4, "mining", 25, "Netherite Ingot"));
        List<ShopItem> farmingItems = Arrays.asList(new ShopItem("minecraft:diamond_hoe", 1, "minecraft:emerald", 6, "farming", 20, "Diamond Hoe"), new ShopItem("minecraft:golden_carrot", 16, "minecraft:emerald", 2, "farming", 10, "Golden Carrots"));
        shopItems.put("mining", miningItems);
        shopItems.put("farming", farmingItems);
        try (FileWriter writer = new FileWriter(configPath.toFile());){
            GSON.toJson(shopItems, (Appendable)writer);
            LOGGER.info("Created default profession shop config at {}", (Object)configPath);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default config: {}", (Object)e.getMessage());
        }
    }

    public static Map<String, List<ShopItem>> getShopItems() {
        return new HashMap<String, List<ShopItem>>(shopItems);
    }

    public static List<ShopItem> getItemsForProfession(String profession) {
        return shopItems.getOrDefault(profession, new ArrayList());
    }

    public static class ShopItem {
        public String itemId;
        public int quantity;
        public String currencyItemId;
        public int currencyQuantity;
        public String requiredProfession;
        public int requiredLevel;
        public String displayName;

        public ShopItem(String itemId, int quantity, String currencyItemId, int currencyQuantity, String requiredProfession, int requiredLevel, String displayName) {
            this.itemId = itemId;
            this.quantity = quantity;
            this.currencyItemId = currencyItemId;
            this.currencyQuantity = currencyQuantity;
            this.requiredProfession = requiredProfession;
            this.requiredLevel = requiredLevel;
            this.displayName = displayName;
        }

        public ItemStack getItemStack() {
            try {
                ResourceLocation location = ResourceLocation.m_135820_((String)this.itemId);
                if (location == null) {
                    LOGGER.warn("Invalid item ID format in shop config: {}", (Object)this.itemId);
                    return ItemStack.f_41583_;
                }
                return new ItemStack((ItemLike)Objects.requireNonNull((Item)BuiltInRegistries.f_257033_.m_7745_(location)), this.quantity);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid item ID in shop config: {}", (Object)this.itemId);
                return ItemStack.f_41583_;
            }
        }

        public ItemStack getCurrencyStack() {
            try {
                ResourceLocation location = ResourceLocation.m_135820_((String)this.currencyItemId);
                if (location == null) {
                    LOGGER.warn("Invalid currency item ID format in shop config: {}", (Object)this.currencyItemId);
                    return ItemStack.f_41583_;
                }
                return new ItemStack((ItemLike)Objects.requireNonNull((Item)BuiltInRegistries.f_257033_.m_7745_(location)), this.currencyQuantity);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid currency item ID in shop config: {}", (Object)this.currencyItemId);
                return ItemStack.f_41583_;
            }
        }
    }
}

