/*
 * Decompiled with CFR 0.152.
 */
package net.mahjerion.mns_extras.client.gui;

import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.mahjerion.mns_extras.config.ProfessionShopConfig;
import net.mahjerion.mns_extras.network.NetworkHandler;
import net.mahjerion.mns_extras.network.PurchaseItemPacket;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ProfessionShopScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("mns_extras", "textures/gui/profession_shop.png");
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 166;
    private static final int MAX_ITEMS_PER_PAGE = 24;
    private static final int ITEMS_PER_ROW = 8;
    private static final int SCROLLBAR_WIDTH = 6;
    private static final int UNAVAILABLE_HIGHLIGHT_COLOR = 0x40FF0000;
    private static final int HOVER_HIGHLIGHT_COLOR = 1082195840;
    private static final int SCROLLBAR_COLOR = -11184811;
    private static final int SCROLLBAR_HANDLE_COLOR = -7829368;
    private static final int TEXT_COLOR = 0xFFFFFF;
    private int leftPos;
    private int topPos;
    private String selectedProfession = "";
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private List<ProfessionShopConfig.ShopItem> currentItems = new ArrayList<ProfessionShopConfig.ShopItem>();
    private final Map<String, List<ProfessionShopConfig.ShopItem>> shopItems = ProfessionShopConfig.getShopItems();
    private final List<String> professionTabs = new ArrayList<String>(this.shopItems.keySet());

    public ProfessionShopScreen() {
        super((Component)Component.m_237115_((String)"gui.mns_extras.profession_shop.title"));
        Collections.sort(this.professionTabs);
        if (!this.professionTabs.isEmpty()) {
            this.selectedProfession = this.professionTabs.get(0);
        }
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 256) / 2;
        this.topPos = (this.f_96544_ - 166) / 2;
        this.createProfessionTabs();
        this.refreshItemButtons();
    }

    private ItemStack getProfessionIcon(String profession) {
        return switch (profession.toLowerCase()) {
            case "farming" -> new ItemStack((ItemLike)Items.f_42405_);
            case "mining" -> new ItemStack((ItemLike)Items.f_42385_);
            case "husbandry" -> new ItemStack((ItemLike)Items.f_42388_);
            case "fishing" -> new ItemStack((ItemLike)Items.f_42523_);
            case "cooking" -> new ItemStack((ItemLike)Items.f_42502_);
            case "alchemy" -> new ItemStack((ItemLike)Items.f_42543_);
            case "enchanting" -> new ItemStack((ItemLike)Items.f_42100_);
            case "gear_crafting" -> new ItemStack((ItemLike)Items.f_42146_);
            case "salvaging" -> new ItemStack((ItemLike)Items.f_42773_);
            default -> new ItemStack((ItemLike)Items.f_42517_);
        };
    }

    private void createProfessionTabs() {
        for (int i = 0; i < this.professionTabs.size(); ++i) {
            String profession = this.professionTabs.get(i);
            int tabX = this.leftPos + 10 + i * 26;
            int tabY = this.topPos + 25;
            ProfessionTabButton tabButton = new ProfessionTabButton(tabX, tabY, 24, 24, profession, button -> this.selectProfession(profession));
            this.m_142416_((GuiEventListener)tabButton);
        }
    }

    private void selectProfession(String profession) {
        this.selectedProfession = profession;
        this.scrollOffset = 0;
        this.refreshItemButtons();
    }

    private void refreshItemButtons() {
        this.f_169369_.removeIf(widget -> widget instanceof ItemButton);
        this.m_6702_().removeIf(widget -> widget instanceof ItemButton);
        if (this.selectedProfession.isEmpty()) {
            return;
        }
        List items = this.shopItems.getOrDefault(this.selectedProfession, new ArrayList());
        items.sort(Comparator.comparingInt(item -> item.requiredLevel));
        this.currentItems.clear();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            for (ProfessionShopConfig.ShopItem item2 : items) {
                try {
                    int playerLevel = Load.player((Player)this.f_96541_.f_91074_).professions.getLevel(item2.requiredProfession);
                    if (playerLevel < item2.requiredLevel) continue;
                    this.currentItems.add(item2);
                }
                catch (Exception e) {
                    this.currentItems.add(item2);
                }
            }
        } else {
            this.currentItems.addAll(items);
        }
        int totalRows = (this.currentItems.size() + 8 - 1) / 8;
        int visibleRows = 3;
        this.maxScroll = Math.max(0, totalRows - visibleRows);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
        int itemStartY = this.topPos + 55;
        int startIndex = this.scrollOffset * 8;
        int endIndex = Math.min(startIndex + 24, this.currentItems.size());
        for (int i = startIndex; i < endIndex; ++i) {
            ProfessionShopConfig.ShopItem item3 = this.currentItems.get(i);
            int relativeIndex = i - startIndex;
            int buttonX = this.leftPos + 10 + relativeIndex % 8 * 28;
            int buttonY = itemStartY + relativeIndex / 8 * 28;
            ItemButton itemButton = new ItemButton(buttonX, buttonY, 24, 24, item3);
            this.m_142416_((GuiEventListener)itemButton);
        }
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        gui.m_280163_(BACKGROUND, this.f_96543_ / 2 - 128, this.f_96544_ / 2 - 83, 0.0f, 0.0f, 256, 166, 256, 166);
        super.m_88315_(gui, mouseX, mouseY, partialTick);
        gui.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 2 - 83 + 8, 0xFFFFFF);
        if (this.maxScroll > 0 && !this.currentItems.isEmpty()) {
            this.drawScrollbar(gui);
        }
        if (this.currentItems.isEmpty() && !this.selectedProfession.isEmpty()) {
            gui.m_280137_(this.f_96547_, "No items available", this.f_96543_ / 2, this.f_96544_ / 2 - 83 + 80, -65536);
        }
        this.renderTooltips(gui, mouseX, mouseY);
    }

    private void drawScrollbar(GuiGraphics guiGraphics) {
        int scrollbarX = this.leftPos + 256 - 6 - 5;
        int scrollbarY = this.topPos + 55;
        int scrollbarHeight = this.topPos + 166 - scrollbarY - 10;
        guiGraphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + 6, scrollbarY + scrollbarHeight, -11184811);
        if (this.maxScroll > 0) {
            int totalRows = (this.currentItems.size() + 8 - 1) / 8;
            int visibleRows = 3;
            float visibilityRatio = Math.min(1.0f, (float)visibleRows / (float)totalRows);
            int handleHeight = Math.max(10, (int)((float)scrollbarHeight * visibilityRatio));
            int handleY = scrollbarY + (scrollbarHeight - handleHeight) * this.scrollOffset / this.maxScroll;
            guiGraphics.m_280509_(scrollbarX, handleY, scrollbarX + 6, handleY + handleHeight, -7829368);
        }
    }

    private void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (Renderable widget : this.f_169369_) {
            ItemButton itemButton;
            if (!(widget instanceof ItemButton) || !(itemButton = (ItemButton)widget).m_5953_(mouseX, mouseY)) continue;
            itemButton.renderTooltip(guiGraphics, mouseX, mouseY);
            return;
        }
        for (Renderable widget : this.f_169369_) {
            ProfessionTabButton tabButton;
            if (!(widget instanceof ProfessionTabButton) || !(tabButton = (ProfessionTabButton)widget).m_5953_(mouseX, mouseY)) continue;
            tabButton.renderTooltip(guiGraphics, mouseX, mouseY);
            return;
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.maxScroll > 0) {
            int oldScrollOffset = this.scrollOffset;
            if (delta > 0.0) {
                this.scrollOffset = Math.max(0, this.scrollOffset - 1);
            } else if (delta < 0.0) {
                this.scrollOffset = Math.min(this.maxScroll, this.scrollOffset + 1);
            }
            if (oldScrollOffset != this.scrollOffset) {
                this.refreshItemButtons();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void purchaseItem(ProfessionShopConfig.ShopItem item) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            List<ProfessionShopConfig.ShopItem> originalItems = this.shopItems.get(this.selectedProfession);
            int itemIndex = originalItems.indexOf(item);
            NetworkHandler.INSTANCE.sendToServer((Object)new PurchaseItemPacket(this.selectedProfession, itemIndex));
        }
    }

    private class ProfessionTabButton
    extends Button {
        private final String profession;
        private final ItemStack professionIcon;

        public ProfessionTabButton(int x, int y, int width, int height, String profession, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.m_237119_(), onPress, f_252438_);
            this.profession = profession;
            this.professionIcon = ProfessionShopScreen.this.getProfessionIcon(profession);
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            boolean isSelected = this.profession.equals(ProfessionShopScreen.this.selectedProfession);
            int backgroundColor = isSelected ? -2130706433 : 0x40000000;
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, backgroundColor);
            int borderColor = isSelected ? -1 : -8355712;
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 1, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_ - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + 1, this.m_252907_() + this.f_93619_, borderColor);
            guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 1, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, borderColor);
            if (!this.professionIcon.m_41619_()) {
                int iconX = this.m_252754_() + (this.f_93618_ - 16) / 2;
                int iconY = this.m_252907_() + (this.f_93619_ - 16) / 2;
                guiGraphics.m_280480_(this.professionIcon, iconX, iconY);
            }
        }

        public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            MutableComponent professionName = Component.m_237115_((String)("profession." + this.profession));
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)professionName, mouseX, mouseY);
        }
    }

    private class ItemButton
    extends Button {
        private final ProfessionShopConfig.ShopItem shopItem;
        private final ItemStack itemStack;
        private boolean canPurchase;

        public ItemButton(int x, int y, int width, int height, ProfessionShopConfig.ShopItem shopItem) {
            super(x, y, width, height, (Component)Component.m_237119_(), button -> ProfessionShopScreen.this.purchaseItem(shopItem), f_252438_);
            this.shopItem = shopItem;
            this.itemStack = shopItem.getItemStack();
            this.canPurchase = this.checkCanPurchase();
        }

        private boolean checkCanPurchase() {
            if (ProfessionShopScreen.this.f_96541_ == null || ((ProfessionShopScreen)ProfessionShopScreen.this).f_96541_.f_91074_ == null) {
                return true;
            }
            try {
                return this.hasEnoughCurrency();
            }
            catch (Exception e) {
                return true;
            }
        }

        private boolean hasEnoughCurrency() {
            ItemStack currencyStack = this.shopItem.getCurrencyStack();
            int playerCurrencyCount = 0;
            for (int i = 0; i < ((ProfessionShopScreen)ProfessionShopScreen.this).f_96541_.f_91074_.m_150109_().m_6643_(); ++i) {
                ItemStack stack = ((ProfessionShopScreen)ProfessionShopScreen.this).f_96541_.f_91074_.m_150109_().m_8020_(i);
                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)currencyStack)) continue;
                playerCurrencyCount += stack.m_41613_();
            }
            return playerCurrencyCount >= this.shopItem.currencyQuantity;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.canPurchase = this.checkCanPurchase();
            if (!this.canPurchase) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x40FF0000);
            } else if (this.m_198029_()) {
                guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 1082195840);
            }
            if (!this.itemStack.m_41619_()) {
                int iconSize = 16;
                int iconX = this.m_252754_() + (this.f_93618_ - iconSize) / 2;
                int iconY = this.m_252907_() + (this.f_93619_ - iconSize) / 2;
                guiGraphics.m_280480_(this.itemStack, iconX, iconY);
            }
        }

        public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            List<Component> tooltip = this.createTooltip();
            guiGraphics.m_280666_(Minecraft.m_91087_().f_91062_, tooltip, mouseX, mouseY);
        }

        private List<Component> createTooltip() {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            if (this.shopItem.quantity > 1) {
                tooltip.add((Component)Component.m_237113_((String)(this.shopItem.quantity + "x " + this.shopItem.displayName)));
            } else {
                tooltip.add((Component)Component.m_237113_((String)this.shopItem.displayName));
            }
            tooltip.add((Component)Component.m_237113_((String)""));
            ItemStack currencyStack = this.shopItem.getCurrencyStack();
            Component currencyName = currencyStack.m_41786_();
            tooltip.add((Component)Component.m_237110_((String)"gui.mns_extras.profession_shop.cost", (Object[])new Object[]{this.shopItem.currencyQuantity, currencyName}).m_130940_(ChatFormatting.GOLD));
            this.addProfessionRequirement(tooltip);
            if (!this.canPurchase) {
                tooltip.add((Component)Component.m_237113_((String)"\u00a7cInsufficient funds!"));
            }
            return tooltip;
        }

        private void addProfessionRequirement(List<Component> tooltip) {
            MutableComponent professionName = Component.m_237115_((String)("profession." + this.shopItem.requiredProfession));
            tooltip.add((Component)Component.m_237110_((String)"gui.mns_extras.profession_shop.required", (Object[])new Object[]{professionName, this.shopItem.requiredLevel}).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

