/*
 * Decompiled with CFR 0.152.
 */
package net.mahjerion.mns_extras;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="mns_extras", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProfessionAdvancementHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final boolean DEV_DEBUG = false;
    private static final Map<String, List<Integer>> PROFESSION_THRESHOLDS = new HashMap<String, List<Integer>>();

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Server starting, DEV_DEBUG = {}", (Object)false);
        LOGGER.info("Total advancements loaded: {}", (Object)event.getServer().m_129889_().m_136028_().size());
        for (String profession : PROFESSION_THRESHOLDS.keySet()) {
            for (int level : PROFESSION_THRESHOLDS.get(profession)) {
                ResourceLocation advancementId = new ResourceLocation("mns_extras", "profession/" + profession + "_level_" + level);
                boolean exists = event.getServer().m_129889_().m_136041_(advancementId) != null;
                LOGGER.info("Advancement {} exists: {}", (Object)advancementId, (Object)exists);
            }
        }
    }

    private static void generateAdvancementFiles() {
        try {
            Path configAdvancementsDir = Paths.get("config", "mns_extras", "generated_data", "data", "mns_extras", "advancements", "profession");
            Files.createDirectories(configAdvancementsDir, new FileAttribute[0]);
            Path resourcesAdvancementsDir = Paths.get("src", "main", "resources", "data", "mns_extras", "advancements", "profession");
            try {
                Files.createDirectories(resourcesAdvancementsDir, new FileAttribute[0]);
            }
            catch (Exception e) {
                LOGGER.warn("Could not create resources directory (this is normal in production): {}", (Object)e.getMessage());
            }
            int totalGenerated = 0;
            for (Map.Entry<String, List<Integer>> entry : PROFESSION_THRESHOLDS.entrySet()) {
                String profession = entry.getKey();
                List<Integer> thresholds = entry.getValue();
                for (int level : thresholds) {
                    ProfessionAdvancementHandler.generateAdvancementFile(configAdvancementsDir, profession, level);
                    try {
                        ProfessionAdvancementHandler.generateAdvancementFile(resourcesAdvancementsDir, profession, level);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Could not write to resources folder: {}", (Object)e.getMessage());
                    }
                    ++totalGenerated;
                }
            }
            LOGGER.info("Generated {} advancement files in config: {}", (Object)totalGenerated, (Object)configAdvancementsDir);
            LOGGER.info("Note: For advancements to work in-game, copy files from config to src/main/resources/data/{}/advancements/profession/", (Object)"mns_extras");
        }
        catch (IOException e) {
            LOGGER.error("Failed to generate advancement files: {}", (Object)e.getMessage());
        }
    }

    private static void generateAdvancementFile(Path baseDir, String profession, int level) throws IOException {
        String fileName = profession + "_level_" + level + ".json";
        Path filePath = baseDir.resolve(fileName);
        JsonObject advancement = ProfessionAdvancementHandler.createAdvancementJson(profession, level);
        try (FileWriter writer = new FileWriter(filePath.toFile());){
            GSON.toJson((JsonElement)advancement, (Appendable)writer);
        }
        LOGGER.debug("Generated advancement file: {}", (Object)fileName);
    }

    private static JsonObject createAdvancementJson(String profession, int level) {
        JsonObject advancement = new JsonObject();
        JsonObject display = new JsonObject();
        JsonObject icon = new JsonObject();
        icon.addProperty("item", ProfessionAdvancementHandler.getProfessionIcon(profession));
        display.add("icon", (JsonElement)icon);
        display.addProperty("title", String.format("%s Master Level %d", profession.substring(0, 1).toUpperCase() + profession.substring(1), level));
        display.addProperty("description", String.format("Reach level %d in %s profession", level, profession));
        display.addProperty("frame", "task");
        display.addProperty("show_toast", Boolean.valueOf(true));
        display.addProperty("announce_to_chat", Boolean.valueOf(true));
        display.addProperty("hidden", Boolean.valueOf(false));
        advancement.add("display", (JsonElement)display);
        JsonObject criteria = new JsonObject();
        JsonObject professionCriterion = new JsonObject();
        professionCriterion.addProperty("trigger", "minecraft:impossible");
        criteria.add("profession_level", (JsonElement)professionCriterion);
        advancement.add("criteria", (JsonElement)criteria);
        JsonArray requirements = new JsonArray();
        JsonArray criterionGroup = new JsonArray();
        criterionGroup.add("profession_level");
        requirements.add((JsonElement)criterionGroup);
        advancement.add("requirements", (JsonElement)requirements);
        JsonObject rewards = new JsonObject();
        rewards.addProperty("experience", (Number)(level * 10));
        advancement.add("rewards", (JsonElement)rewards);
        return advancement;
    }

    private static String getProfessionIcon(String profession) {
        return switch (profession.toLowerCase()) {
            case "farming" -> "minecraft:diamond_hoe";
            case "mining" -> "minecraft:diamond_pickaxe";
            case "husbandry" -> "minecraft:wheat";
            case "fishing" -> "minecraft:fishing_rod";
            case "cooking" -> "minecraft:furnace";
            case "alchemy" -> "minecraft:brewing_stand";
            case "enchanting" -> "minecraft:enchanting_table";
            case "gear_crafting" -> "minecraft:anvil";
            case "salvaging" -> "minecraft:grindstone";
            default -> "minecraft:diamond";
        };
    }

    public static void checkProfessionThreshold(ServerPlayer player, String professionId) {
        LOGGER.info("Checking profession threshold for player {} in profession {}", (Object)player.m_7755_().getString(), (Object)professionId);
        if (!PROFESSION_THRESHOLDS.containsKey(professionId)) {
            LOGGER.debug("No thresholds defined for profession: {}. Available professions: {}", (Object)professionId, PROFESSION_THRESHOLDS.keySet());
            return;
        }
        int currentLevel = ProfessionAdvancementHandler.getProfessionLevel(player, professionId);
        List<Integer> thresholds = PROFESSION_THRESHOLDS.get(professionId);
        LOGGER.info("Player {} has level {} in profession {}, checking thresholds: {}", new Object[]{player.m_7755_().getString(), currentLevel, professionId, thresholds});
        for (int threshold : thresholds) {
            if (currentLevel != threshold) continue;
            LOGGER.info("Player {} reached threshold level {} in profession {}", new Object[]{player.m_7755_().getString(), threshold, professionId});
            ProfessionAdvancementHandler.grantProfessionAdvancement(player, professionId, threshold);
        }
    }

    private static int getProfessionLevel(ServerPlayer player, String profession) {
        try {
            return Load.player((Player)player).professions.getLevel(profession);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get {} profession level for player {}: {}", new Object[]{profession, player.m_7755_().getString(), e.getMessage()});
            return 0;
        }
    }

    private static void grantProfessionAdvancement(ServerPlayer player, String profession, int level) {
        ResourceLocation advancementId = new ResourceLocation("mns_extras", "profession/" + profession + "_level_" + level);
        LOGGER.info("Attempting to grant advancement {} to player {}", (Object)advancementId, (Object)player.m_7755_().getString());
        Advancement advancement = player.f_8924_.m_129889_().m_136041_(advancementId);
        if (advancement != null) {
            AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
            if (!progress.m_8193_()) {
                for (String criterion : advancement.m_138325_().keySet()) {
                    LOGGER.debug("Granting criterion {} for advancement {}", (Object)criterion, (Object)advancementId);
                    player.m_8960_().m_135988_(advancement, criterion);
                }
                LOGGER.info("Successfully granted {} level {} advancement to player {}", new Object[]{profession, level, player.m_7755_().getString()});
            } else {
                LOGGER.debug("Advancement {} already completed for player {}", (Object)advancementId, (Object)player.m_7755_().getString());
            }
        } else {
            LOGGER.warn("Advancement {} not found. Available advancements: {}", (Object)advancementId, (Object)player.f_8924_.m_129889_().m_136028_().size());
            LOGGER.debug("Sample available advancements:");
            player.f_8924_.m_129889_().m_136028_().stream().limit(5L).forEach(adv -> LOGGER.debug("  - {}", (Object)adv.m_138327_()));
        }
    }

    public static void setProfessionThresholds(String profession, List<Integer> levels) {
        PROFESSION_THRESHOLDS.put(profession, new ArrayList<Integer>(levels));
        LOGGER.info("Set {} profession thresholds to levels {}", (Object)profession, levels);
    }

    public static void addProfessionThreshold(String profession, int level) {
        PROFESSION_THRESHOLDS.computeIfAbsent(profession, k -> new ArrayList()).add(level);
        LOGGER.info("Added level {} threshold to {} profession", (Object)level, (Object)profession);
    }

    public static List<Integer> getProfessionThresholds(String profession) {
        return PROFESSION_THRESHOLDS.getOrDefault(profession, new ArrayList());
    }

    static {
        PROFESSION_THRESHOLDS.put("husbandry", Arrays.asList(10, 20, 30, 40, 50, 60, 70, 80, 90, 100));
        PROFESSION_THRESHOLDS.put("mining", Arrays.asList(5, 10, 15, 20, 25));
        PROFESSION_THRESHOLDS.put("farming", Arrays.asList(10, 25, 40));
        PROFESSION_THRESHOLDS.put("fishing", Arrays.asList(12, 24, 36));
        PROFESSION_THRESHOLDS.put("combat", Arrays.asList(20, 40, 60));
    }
}

