/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.item;

import com.refinedmods.refinedstorage.render.Styles;
import dev.smolinacadena.refinedcooking.block.KitchenStationBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class KitchenNetworkCardItem
extends Item {
    private static final String NBT_RECEIVER_X = "ReceiverX";
    private static final String NBT_RECEIVER_Y = "ReceiverY";
    private static final String NBT_RECEIVER_Z = "ReceiverZ";
    private static final String NBT_DIMENSION = "Dimension";

    public KitchenNetworkCardItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Block block = ctx.m_43725_().m_8055_(ctx.m_8083_()).m_60734_();
        if (block instanceof KitchenStationBlock) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_(NBT_RECEIVER_X, ctx.m_8083_().m_123341_());
            tag.m_128405_(NBT_RECEIVER_Y, ctx.m_8083_().m_123342_());
            tag.m_128405_(NBT_RECEIVER_Z, ctx.m_8083_().m_123343_());
            tag.m_128359_(NBT_DIMENSION, ctx.m_43725_().m_46472_().m_135782_().toString());
            ctx.m_43723_().m_21120_(ctx.m_43724_()).m_41751_(tag);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        BlockPos pos = KitchenNetworkCardItem.getReceiver(stack);
        ResourceKey<Level> type = KitchenNetworkCardItem.getDimension(stack);
        if (pos != null && type != null) {
            tooltip.add((Component)Component.m_237110_((String)"misc.refinedcooking.kitchen_network_card.tooltip", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), type.m_135782_().toString()}).m_6270_(Styles.GRAY));
        }
    }

    @Nullable
    public static BlockPos getReceiver(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_RECEIVER_X) && stack.m_41783_().m_128441_(NBT_RECEIVER_Y) && stack.m_41783_().m_128441_(NBT_RECEIVER_Z)) {
            return new BlockPos(stack.m_41783_().m_128451_(NBT_RECEIVER_X), stack.m_41783_().m_128451_(NBT_RECEIVER_Y), stack.m_41783_().m_128451_(NBT_RECEIVER_Z));
        }
        return null;
    }

    @Nullable
    public static ResourceKey<Level> getDimension(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_DIMENSION)) {
            ResourceLocation name = ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_(NBT_DIMENSION));
            if (name == null) {
                return null;
            }
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)name);
        }
        return null;
    }
}

